/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.NativeUtility;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.TrusteeType;
import java.io.File;
import java.io.IOException;

public class FilePermissionsUtil
implements FilePermissions {
    public static final int PERMS_777 = 511;
    public static final int PERMS_755 = 493;
    public static final int PERMS_666 = 438;
    public static final int PERMS_644 = 420;
    public static final int PERMS_555 = 365;
    public static final int PERMS_444 = 292;

    public FilePermissionsUtil(String string) throws JNIException {
        NativeUtility.loadNativeLibrary(string);
    }

    public FilePermissionsUtil() {
    }

    @Override
    public void setFileWritable(File file, boolean bl) throws JNIException {
        file.setWritable(bl);
    }

    @Override
    public boolean allowTrusteeTypeUpdate(File file, TrusteeType trusteeType, String string, long l) {
        boolean bl;
        if (new PlatformImpl().isWindows()) {
            bl = this.addUsersACE(file, trusteeType, string, l);
        } else {
            try {
                bl = true;
                if (file.exists()) {
                    this.setFilePermissions(file.getAbsolutePath(), 438);
                }
            }
            catch (Throwable throwable) {
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public boolean allowOtherUserUpdate(File file, String string) {
        long l = 0x10000000L;
        return this.allowTrusteeTypeUpdate(file, TrusteeType.TRUSTEE_IS_USER, string, l);
    }

    private boolean addUsersACE(File file, TrusteeType trusteeType, String string, long l) {
        String string2 = this.getTrusteeTypeValue(trusteeType);
        int n = 0;
        try {
            long l2;
            if (file.isFile() && l < (l2 = 0xFFFFFFFFL)) {
                String string3 = file.getAbsolutePath();
                n = this.addACEToFilesDACL(string3, string2, string, l);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean bl = false;
        if (n == 0) {
            bl = true;
        }
        return bl;
    }

    private String getTrusteeTypeValue(TrusteeType trusteeType) {
        String string = "0";
        if (trusteeType == TrusteeType.TRUSTEE_IS_UNKNOWN) {
            string = "0";
        } else if (trusteeType == TrusteeType.TRUSTEE_IS_USER) {
            string = "1";
        } else if (trusteeType == TrusteeType.TRUSTEE_IS_GROUP) {
            string = "2";
        } else if (trusteeType == TrusteeType.TRUSTEE_IS_DOMAIN) {
            string = "3";
        } else if (trusteeType == TrusteeType.TRUSTEE_IS_ALIAS) {
            string = "4";
        } else if (trusteeType == TrusteeType.TRUSTEE_IS_WELL_KNOWN_GROUP) {
            string = "5";
        } else if (trusteeType == TrusteeType.TRUSTEE_IS_DELETED) {
            string = "6";
        } else if (trusteeType == TrusteeType.TRUSTEE_IS_INVALID) {
            string = "7";
        } else if (trusteeType == TrusteeType.TRUSTEE_IS_COMPUTER) {
            string = "8";
        }
        return string;
    }

    @Override
    public boolean allowEveryoneFullAccessOnWindows(File file) throws Exception {
        boolean bl = false;
        PlatformImpl platformImpl = new PlatformImpl();
        if (file.exists() && platformImpl.isWindows()) {
            TrusteeType trusteeType = TrusteeType.TRUSTEE_IS_WELL_KNOWN_GROUP;
            String string = this.getTrusteeTypeValue(trusteeType);
            String string2 = file.getAbsolutePath();
            int n = this.addACEToFilesDACL(string2, string, "EVERYONE", 0x10000000L);
            if (n == 0) {
                bl = true;
            }
        }
        return bl;
    }

    private native int addACEToFilesDACL(String var1, String var2, String var3, long var4);

    @Override
    public void setFilePermissions(String string, int n) throws IOException {
        if (!new PlatformImpl().isWindows()) {
            this.setUnixFilePerms(string, n);
        }
    }

    private native void setUnixFilePerms(String var1, int var2) throws IOException;
}

