/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.DefaultSecurityOverrideImpl;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.FolderUtilsImpl;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.IOUtil;
import com.mathworks.instutil.InstUtilResourceBundle;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.NativeUtility;
import com.mathworks.instutil.ParentFolderOperation;
import com.mathworks.instutil.PlatformImpl;
import com.mathworks.instutil.SecurityOverride;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.IOFileFilter;

public class FileIO
implements IO {
    private static final long DEFAULT_BUFFER_SIZE = 0x100000L;
    private static final File[] EMPTY_FILE_ARRAY = new File[0];
    private final FilePermissions filePermissions;
    private final SecurityOverride securityOverride;
    private final FolderUtils folderUtils;

    public FileIO(String string, FilePermissions filePermissions) throws JNIException {
        this(string, filePermissions, new DefaultSecurityOverrideImpl());
    }

    public FileIO(String string, FilePermissions filePermissions, SecurityOverride securityOverride) throws JNIException {
        this(filePermissions, securityOverride);
        NativeUtility.loadNativeLibrary(string);
    }

    public FileIO(FilePermissions filePermissions) {
        this(filePermissions, new DefaultSecurityOverrideImpl());
    }

    public FileIO(FilePermissions filePermissions, SecurityOverride securityOverride) {
        this.filePermissions = filePermissions;
        this.securityOverride = securityOverride;
        this.folderUtils = new FolderUtilsImpl(filePermissions, securityOverride);
    }

    public static long copySingleFile(File file, File file2) {
        try {
            return new FileIO(new FilePermissionsUtil()).copyFile(file, file2, new IOObserver[0]);
        }
        catch (IOException iOException) {
            return -1L;
        }
    }

    public static boolean deleteSingleFile(File file, Logger logger, InstUtilResourceBundle instUtilResourceBundle) throws InterruptedException {
        if (file.exists() && !file.delete()) {
            String string = file.getAbsolutePath();
            Object[] objectArray = new Object[]{string};
            String string2 = instUtilResourceBundle.getString("log.delete.first");
            MessageFormat messageFormat = new MessageFormat(string2);
            String string3 = messageFormat.format(objectArray);
            logger.log(Level.SEVERE, string3);
            Thread.sleep(100L);
            if (!file.delete()) {
                String string4 = instUtilResourceBundle.getString("log.delete.second");
                MessageFormat messageFormat2 = new MessageFormat(string4);
                String string5 = messageFormat2.format(objectArray);
                logger.log(Level.SEVERE, string5);
                return false;
            }
        }
        return true;
    }

    @Override
    public void createSymLink(String string, String string2) throws IOException, InterruptedException {
        File file = new File(string2);
        this.createParentIfNecessary(file);
        if (new PlatformImpl().isWindows()) {
            long l;
            String string3 = this.getParent(file);
            File file2 = new File(string3, string);
            if (file2.isDirectory()) {
                this.writeStringToFile(string, file, 0L, 420, new IOObserver[0]);
            } else if (file2.isFile() && (l = FileIO.copySingleFile(file2, file)) <= 0L) {
                throw new IOException("Error copying file " + file2.getAbsolutePath() + " to " + string2);
            }
        } else {
            if (!file.isDirectory()) {
                this.deleteFile(file);
            }
            FileIO.nativeCreateSymLink(string, string2);
        }
    }

    @Override
    public long createFileFromStream(InputStream inputStream, File file, long l, int n, IOObserver ... iOObserverArray) throws IOException, InterruptedException {
        return this.createFileFromStream(inputStream, file, l, n, false, iOObserverArray);
    }

    private long createFileFromStream(InputStream inputStream, File file, long l, int n, boolean bl, IOObserver ... iOObserverArray) throws IOException, InterruptedException {
        this.enforceMaxPathLength();
        this.folderUtils.createParentIfNecessary(file);
        file.setWritable(true);
        long l2 = FileIO.copyToFileFromStream(inputStream, file, bl, iOObserverArray);
        FileIO.setModificationTime(file, l);
        this.filePermissions.setFilePermissions(file.getAbsolutePath(), n);
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Collection<String>> T readLinesFromFile(File file, T t) throws IOException {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            List list = IOUtils.readLines((Reader)fileReader);
            for (Object e : list) {
                t.add((String)e.toString());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileReader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copyFile(File file, File file2, IOObserver ... iOObserverArray) throws IOException {
        long l = -1L;
        if (!file.equals(file2) && file.isFile()) {
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                l = this.createFileFromStream((InputStream)fileInputStream, file2, file.lastModified(), 511, iOObserverArray);
            }
            catch (InterruptedException interruptedException) {
                try {
                    l = -1L;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fileInputStream);
            }
            IOUtils.closeQuietly((InputStream)fileInputStream);
        }
        return l;
    }

    @Override
    public void deleteFile(File file) {
        HashSet<String> hashSet = new HashSet<String>();
        this.tryToDeleteFile(file, true, hashSet);
    }

    @Override
    public void deleteFile(File file, Set<String> set) {
        this.tryToDeleteFile(file, false, set);
    }

    @Override
    public void deleteFile(File file, boolean bl, Set<String> set) {
        this.tryToDeleteFile(file, bl, set);
    }

    private void tryToDeleteFile(File file, boolean bl, Set<String> set) {
        boolean bl2 = false;
        if (file.isDirectory()) {
            bl2 = !file.delete();
        } else {
            try {
                this.forceDelete(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                bl2 = true;
            }
        }
        if (bl && bl2) {
            FileIO.waitFor100ms();
            this.tryToDeleteFile(file, false, set);
        }
        if (!bl && bl2) {
            set.add(file.toString());
        }
    }

    private static void waitFor100ms() {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void forceDelete(File file) throws IOException {
        if (file.isDirectory()) {
            this.deleteDirectory(file);
        } else {
            boolean bl = file.exists();
            if (!file.delete()) {
                if (!bl) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                String string = "Unable to delete file: " + file;
                throw new IOException(string);
            }
        }
    }

    @Override
    public void copyDirectory(File file, File file2) throws IOException {
        this.deleteDirectory(file2);
        FileUtils.copyDirectory((File)file, (File)file2, (boolean)true);
    }

    @Override
    public void deleteDirectory(File file) throws IOException {
        try {
            FileUtils.cleanDirectory((File)file);
            this.deleteFile(file);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    public String readFileToString(File file) throws IOException {
        return FileUtils.readFileToString((File)file);
    }

    @Override
    public void writeStringToFile(String string, File file, long l, int n, IOObserver ... iOObserverArray) throws IOException, InterruptedException {
        this.writeStringToFile(string, file, l, n, false, iOObserverArray);
    }

    @Override
    public void writeStringToFile(String string, File file, long l, int n, boolean bl, IOObserver ... iOObserverArray) throws IOException, InterruptedException {
        this.createFileFromStream((InputStream)new ByteArrayInputStream(string.getBytes()), file, l, n, bl, iOObserverArray);
    }

    @Override
    public boolean isDirectory(File file) {
        return file.isDirectory();
    }

    @Override
    public boolean isFile(File file) {
        return file.isFile();
    }

    @Override
    public String scrub(String string) {
        return this.folderUtils.scrub(string);
    }

    @Override
    public boolean isAbsolute(String string) {
        return this.folderUtils.isAbsolute(string);
    }

    @Override
    public boolean exists(String string) {
        return this.folderUtils.exists(string);
    }

    @Override
    public boolean canWriteToFolder(String string) {
        return this.folderUtils.canWriteToFolder(string);
    }

    @Override
    public boolean mkdirs(String string) {
        return this.folderUtils.mkdirs(string);
    }

    @Override
    public void createParentIfNecessary(File file) {
        this.folderUtils.createParentIfNecessary(file);
    }

    @Override
    public boolean mkdirAsRoot(String string) {
        return this.folderUtils.mkdirAsRoot(string);
    }

    @Override
    public File getParentFile(File file) {
        return this.folderUtils.getParentFile(file);
    }

    @Override
    public boolean hasParent(File file) {
        return this.folderUtils.hasParent(file);
    }

    @Override
    public boolean canWriteToParent(File file) {
        return this.folderUtils.canWriteToParent(file);
    }

    @Override
    public void recursivelyDeleteFileAndParents(File file, File file2) {
        this.recursivelyOperateOnFileAndParents(file, file2, new ParentFolderOperation(){

            @Override
            public void execute(File file) {
                FileIO.this.deleteFile(file);
            }
        });
    }

    @Override
    public File[] listFiles(File file, FilenameFilter filenameFilter) {
        File[] fileArray = file.listFiles(filenameFilter);
        return fileArray != null ? fileArray : EMPTY_FILE_ARRAY;
    }

    @Override
    public Collection<File> recursiveListFiles(File file, IOFileFilter iOFileFilter, IOFileFilter iOFileFilter2) {
        try {
            return FileUtils.listFiles((File)file, (IOFileFilter)iOFileFilter, (IOFileFilter)iOFileFilter2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new ArrayList<File>();
        }
    }

    @Override
    public void recursivelyOperateOnFileAndParents(File file, File file2, ParentFolderOperation parentFolderOperation) {
        this.folderUtils.recursivelyOperateOnFileAndParents(file, file2, parentFolderOperation);
    }

    @Override
    public boolean firstExistingDirectoryExists(File file) {
        return this.folderUtils.firstExistingDirectoryExists(file);
    }

    @Override
    public File getFirstExistingDirectory(File file) {
        return this.folderUtils.getFirstExistingDirectory(file);
    }

    @Override
    public File getSearchPathForFileBrowser(File file, File file2) {
        return this.folderUtils.getSearchPathForFileBrowser(file, file2);
    }

    @Override
    public String getParent(File file) {
        return this.folderUtils.getParent(file);
    }

    @Override
    public boolean cpFileAsRoot(String string, String string2) {
        return this.securityOverride.cpFileAsRoot(string, string2);
    }

    @Override
    public String getResourceFromFile(URL uRL) throws IOException {
        return IOUtils.toString((InputStream)((InputStream)uRL.getContent()));
    }

    private void enforceMaxPathLength() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copyToFileFromStream(InputStream inputStream, File file, boolean bl, IOObserver ... iOObserverArray) throws IOException, InterruptedException {
        long l;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            fileOutputStream = new FileOutputStream(file, bl);
            fileChannel = fileOutputStream.getChannel();
            ReadableByteChannel readableByteChannel = Channels.newChannel(inputStream);
            l = bl ? file.length() : 0L;
            long l2 = 0x100000L;
            while (l2 == 0x100000L) {
                l2 = fileChannel.transferFrom(readableByteChannel, l, 0x100000L);
                l += l2;
                IOUtil.updateObservers(l2, iOObserverArray);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            IOUtil.closeQuietly(fileChannel);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        IOUtil.closeQuietly(fileChannel);
        return l;
    }

    private static void setModificationTime(File file, long l) {
        if (l > 0L) {
            file.setLastModified(l);
        }
    }

    private static native void nativeCreateSymLink(String var0, String var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void logDownloadError(URL uRL, String string) {
        File file = new File(new File(System.getProperty("java.io.tmpdir")), "mw_download_error.log");
        ByteArrayInputStream byteArrayInputStream = null;
        ReadableByteChannel readableByteChannel = null;
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        try {
            String string2 = InetAddress.getByName(uRL.getHost()).getHostAddress();
            String string3 = new SimpleDateFormat("[MM/dd/yyyy-HH:mm:ss]: ").format(new Date()) + string + " (" + uRL.toString() + ")(" + string2 + ")" + System.getProperty("line.separator");
            byteArrayInputStream = new ByteArrayInputStream(string3.getBytes());
            readableByteChannel = Channels.newChannel(byteArrayInputStream);
            fileOutputStream = new FileOutputStream(file, true);
            fileChannel = fileOutputStream.getChannel();
            fileChannel.transferFrom(readableByteChannel, file.length(), string3.length());
        }
        catch (IOException iOException) {
            IOUtil.closeQuietly(byteArrayInputStream);
            IOUtil.closeQuietly(readableByteChannel);
            IOUtil.closeQuietly(fileOutputStream);
            IOUtil.closeQuietly(fileChannel);
            catch (Throwable throwable) {
                IOUtil.closeQuietly(byteArrayInputStream);
                IOUtil.closeQuietly(readableByteChannel);
                IOUtil.closeQuietly(fileOutputStream);
                IOUtil.closeQuietly(fileChannel);
                throw throwable;
            }
        }
        IOUtil.closeQuietly(byteArrayInputStream);
        IOUtil.closeQuietly(readableByteChannel);
        IOUtil.closeQuietly(fileOutputStream);
        IOUtil.closeQuietly(fileChannel);
    }

    @Override
    public String getDownloadFolder() {
        return this.folderUtils.getDownloadFolder();
    }
}

