/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import com.mathworks.instutil.Downloader;
import com.mathworks.instutil.FolderUtils;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.IOUtil;
import com.mathworks.instutil.URLConnectionFactory;
import com.mathworks.webproxy.ProxyConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.io.IOUtils;

public final class DownloaderImpl
implements Downloader {
    private final URLConnectionFactory urlConnectionFactory;
    private final FolderUtils folderUtils;

    public DownloaderImpl(URLConnectionFactory uRLConnectionFactory, FolderUtils folderUtils) {
        this.urlConnectionFactory = uRLConnectionFactory;
        this.folderUtils = folderUtils;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long download(ProxyConfiguration proxyConfiguration, URL uRL, File file, IOObserver ... iOObserverArray) throws InterruptedException, IOException {
        this.folderUtils.createParentIfNecessary(file);
        FileOutputStream fileOutputStream = null;
        FileChannel fileChannel = null;
        long l = 0L;
        try {
            fileOutputStream = new FileOutputStream(file, false);
            fileChannel = fileOutputStream.getChannel();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileOutputStream);
            IOUtil.closeQuietly(fileChannel);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)fileOutputStream);
        IOUtil.closeQuietly(fileChannel);
        return l += this.downloadFile(fileChannel, uRL, proxyConfiguration.findProxyForURL(uRL), iOObserverArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long downloadFile(FileChannel fileChannel, URL uRL, Proxy proxy, IOObserver ... iOObserverArray) throws IOException, InterruptedException {
        long l = 0L;
        URLConnection uRLConnection = this.urlConnectionFactory.createURLConnection(uRL, proxy, l);
        InputStream inputStream = null;
        ReadableByteChannel readableByteChannel = null;
        try {
            int n;
            inputStream = uRLConnection.getInputStream();
            readableByteChannel = Channels.newChannel(inputStream);
            ByteBuffer byteBuffer = ByteBuffer.allocate(Long.valueOf(0x100000L).intValue());
            while ((n = readableByteChannel.read(byteBuffer)) != -1) {
                l += (long)n;
                byteBuffer.flip();
                fileChannel.write(byteBuffer);
                byteBuffer.clear();
                if (!IOUtil.updateObservers(n, iOObserverArray)) continue;
                IOUtils.closeQuietly((InputStream)inputStream);
                IOUtil.closeQuietly(readableByteChannel);
                URLConnection uRLConnection2 = this.urlConnectionFactory.createURLConnection(uRL, proxy, l, uRLConnection.getContentLengthLong());
                inputStream = uRLConnection2.getInputStream();
                readableByteChannel = Channels.newChannel(inputStream);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
            IOUtil.closeQuietly(readableByteChannel);
        }
        return l;
    }
}

