/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.instutil;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class DaemonThreadFactory {
    public static ExecutorService getNewSingleThreadExecutor(String string) {
        DaemonThread daemonThread = new DaemonThread(string);
        return Executors.newSingleThreadExecutor(daemonThread);
    }

    public static ExecutorService getNewFixedThreadExecutor(int n, String string) {
        DaemonThread daemonThread = new DaemonThread(string);
        return Executors.newFixedThreadPool(n, daemonThread);
    }

    private static class DaemonThread
    implements ThreadFactory {
        private final String threadName;

        private DaemonThread(String string) {
            this.threadName = string + " (Daemon)";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, this.threadName);
            thread.setDaemon(true);
            return thread;
        }
    }
}

