/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.urlmanager;

import com.mathworks.apache.commons.cli.BasicParser;
import com.mathworks.apache.commons.cli.CommandLine;
import com.mathworks.apache.commons.cli.HelpFormatter;
import com.mathworks.apache.commons.cli.Options;
import com.mathworks.apache.commons.cli.ParseException;
import com.mathworks.brsanthu.dataexporter.DataExporter;
import com.mathworks.brsanthu.dataexporter.model.AlignType;
import com.mathworks.brsanthu.dataexporter.model.StringColumn;
import com.mathworks.brsanthu.dataexporter.model.json.JsonExportOptions;
import com.mathworks.brsanthu.dataexporter.model.json.JsonExporter;
import com.mathworks.brsanthu.dataexporter.output.csv.CsvExportOptions;
import com.mathworks.brsanthu.dataexporter.output.csv.CsvExporter;
import com.mathworks.brsanthu.dataexporter.output.html.HtmlExportOptions;
import com.mathworks.brsanthu.dataexporter.output.html.HtmlExporter;
import com.mathworks.brsanthu.dataexporter.output.texttable.TextTableExportOptions;
import com.mathworks.brsanthu.dataexporter.output.texttable.TextTableExportStyle;
import com.mathworks.brsanthu.dataexporter.output.texttable.TextTableExporter;
import com.mathworks.brsanthu.dataexporter.output.xml.XmlExportOptions;
import com.mathworks.brsanthu.dataexporter.output.xml.XmlExporter;
import com.mathworks.webservices.urlmanager.MissingUrlKeyException;
import com.mathworks.webservices.urlmanager.UrlManagerFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class UrlManager {
    public static final String CLOUD_CENTER_SERVICE = Service.CLOUD_CENTER_SERVICE.getServiceId();
    public static final String CLOUD_CENTER = Service.CLOUD_CENTER.getServiceId();
    public static final String CONTENT_SERVICE = Service.CONTENT_SERVICE.getServiceId();
    public static final String DOWNLOADS_SERVICE = Service.DOWNLOADS_SERVICE.getServiceId();
    public static final String MCR_SERVICE = Service.MCR_SERVICE.getServiceId();
    public static final String LOGIN_SERVICE = Service.LOGIN_SERVICE.getServiceId();
    public static final String LICENSE_SERVICE = Service.LICENSE_SERVICE.getServiceId();
    public static final String ACTIVATION_SERVICE = Service.ACTIVATION_SERVICE.getServiceId();
    public static final String STUDENT_ACTIVATION_SERVICE = Service.STUDENT_ACTIVATION_SERVICE.getServiceId();
    public static final String SEGV_SERVICE = Service.SEGV_SERVICE.getServiceId();
    public static final String SERVICE_REQUEST_SERVICE = Service.SERVICE_REQUEST_SERVICE.getServiceId();
    public static final String MATHWORKS_DOT_COM = Service.MATHWORKS_DOT_COM.getServiceId();
    public static final String USAGE_DATA_SERVICE = Service.USAGE_DATA_SERVICE.getServiceId();
    public static final String GDS = Service.GDS.getServiceId();
    public static final String GDS_JOBS = Service.GDS_JOBS.getServiceId();
    public static final String UDC = Service.UDC.getServiceId();
    public static final String UDCPING = Service.UDCPING.getServiceId();
    public static final String SSID = Service.SSID.getServiceId();
    public static final String APS_BROKER_WEBSOCKET = Service.APS_BROKER_WEBSOCKET.getServiceId();
    public static final String EMBEDDED_LOGIN = Service.EMBEDDED_LOGIN.getServiceId();
    public static final String EMBEDDED_SIGNIN = Service.EMBEDDED_SIGNIN.getServiceId();
    public static final String ADD_ONS = Service.ADD_ONS.getServiceId();
    public static final String HELP = Service.HELP.getServiceId();
    public static final String EXAMPLES = Service.EXAMPLES.getServiceId();
    public static final String LCMPC = Service.LCMPC.getServiceId();
    public static final String AUTH = Service.AUTH.getServiceId();
    public static final String APS_AUTH = Service.APS_AUTH.getServiceId();
    public static final String APS_AUTHNZ = Service.APS_AUTHNZ.getServiceId();
    public static final String DDUXWS = Service.DDUXWS.getServiceId();
    public static final String CONNECTIVITY = Service.CONNECTIVITY.getServiceId();
    public static final String MCI = Service.MCI.getServiceId();
    public static final String APS_NOTIFICATIONS = Service.APS_NOTIFICATIONS.getServiceId();
    public static final String DAWS = Service.DAWS.getServiceId();
    public static final String MLDO = Service.MLDO.getServiceId();
    public static final String CCEMBED = Service.CCEMBED.getServiceId();
    public static final String MLDO_EMBED = Service.MLDO_EMBED.getServiceId();
    public static final String FILEEXCHANGE_REPOSITORY = Service.FILEEXCHANGE_REPOSITORY.getServiceId();
    public static final String SSD = Service.SSD.getServiceId();

    public abstract String getUrl(String var1, boolean var2);

    public abstract String getUrl(String var1);

    public String getUrl(Service service, boolean refreshUrlMap) {
        return this.getUrl(service.getServiceId(), refreshUrlMap);
    }

    public String getUrl(Service service) {
        return this.getUrl(service.getServiceId());
    }

    public abstract List<String> getUrlList(String var1, boolean var2);

    public abstract List<String> getUrlList(String var1);

    public List<String> getUrlList(Service service, boolean refreshMap) {
        return this.getUrlList(service.getServiceId(), refreshMap);
    }

    public List<String> getUrlList(Service service) {
        return this.getUrlList(service.getServiceId());
    }

    public int serviceResponding(String serviceName) {
        return this.connect(serviceName, null);
    }

    public int serviceResponding(Service service) {
        return this.serviceResponding(this.getUrl(service.getServiceId()));
    }

    public Map<String, Integer> servicesResponding(String ... services) {
        HashMap<String, Integer> rval = new HashMap<String, Integer>();
        for (String service : services) {
            rval.put(service, this.serviceResponding(service));
        }
        return rval;
    }

    public Map<Service, Integer> servicesResponding(Service ... services) {
        HashMap<Service, Integer> rval = new HashMap<Service, Integer>();
        for (Service service : services) {
            rval.put(service, this.serviceResponding(service));
        }
        return rval;
    }

    public Map<Service, Integer> servicesResponding() {
        return this.servicesResponding(Service.values());
    }

    public static void main(String[] args) {
        if (0 == args.length) {
            UrlManager.run(null, "-i", "loginws", "-e", "integ", "-r", "R2017b", "-f", "xml");
        } else {
            UrlManager.run(null, args);
        }
    }

    public static String getUrlInfo(String ... args) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        UrlManager.run(stream, args);
        String rval = stream.toString();
        return rval;
    }

    static void run(OutputStream stream, String ... args) {
        Options options = new Options().addOption("r", "release", true, "matlab release family e.g. R2017b (required)").addOption("e", "environment", true, "environment, either integ or production (required)").addOption("f", "format", true, "output format, one of: csv, table, xml, json").addOption("t", "test", false, "check each endpoint and make sure it responds").addOption("i", "id", true, "one particular endpoint to generate the xml for. Useful for testing.").addOption("ph", "proxy_host", true, "proxy host").addOption("pp", "proxy_port", true, "proxy port").addOption("pu", "proxy_username", true, "proxy username").addOption("pw", "proxy_password", true, "proxy password").addOption("h", "help", false, "show help.");
        DataExporter exporter = null;
        UrlManager manager = null;
        BasicParser parser = new BasicParser();
        boolean test_connectivity = false;
        String serviceId = null;
        Proxy proxy = null;
        try {
            String format;
            if (null == args || 0 == args.length) {
                UrlManager.help(options);
                return;
            }
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("h")) {
                UrlManager.help(options);
                return;
            }
            String release = cmd.getOptionValue("r");
            String environment = cmd.getOptionValue("e");
            String string = format = cmd.hasOption("f") ? cmd.getOptionValue("f") : "table";
            if (null == release) {
                UrlManager.help("release required", options);
                return;
            }
            if (null == environment) {
                UrlManager.help("environment required", options);
                return;
            }
            test_connectivity = cmd.hasOption("t");
            if (cmd.hasOption("pu") && cmd.hasOption("pw")) {
                final String username = cmd.getOptionValue("pu");
                final String password = cmd.getOptionValue("pw");
                Authenticator authenticator = new Authenticator(){

                    @Override
                    public PasswordAuthentication getPasswordAuthentication() {
                        return new PasswordAuthentication(username, password.toCharArray());
                    }
                };
                Authenticator.setDefault(authenticator);
            }
            if (cmd.hasOption("ph") && cmd.hasOption("pp")) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(cmd.getOptionValue("ph"), (int)new Integer(cmd.getOptionValue("pp"))));
            }
            if (cmd.hasOption("i")) {
                serviceId = cmd.getOptionValue("i");
            }
            manager = UrlManagerFactory.createUrlManager(release, environment);
            exporter = UrlManager.createExporter(format, stream);
        }
        catch (ParseException e) {
            UrlManager.help(options);
            return;
        }
        if (null == serviceId) {
            manager.setupData(exporter, proxy, test_connectivity);
        } else {
            Service service = Service.id2Service(serviceId);
            manager.setupData(service, exporter, proxy, test_connectivity);
        }
        exporter.finishExporting();
    }

    private int connect(String serviceId, Proxy proxy) {
        String urlString = null;
        try {
            urlString = this.getUrl(serviceId + ".validate");
        }
        catch (MissingUrlKeyException ignore) {
            urlString = this.getUrl(serviceId);
        }
        int rval = 404;
        try {
            URL url = new URL(urlString);
            HttpURLConnection connection = (HttpURLConnection)(proxy != null ? url.openConnection(proxy) : url.openConnection());
            connection.setRequestMethod("HEAD");
            rval = connection.getResponseCode();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return rval;
    }

    private void setupDataForService(String serviceName, String serviceId, DataExporter exporter, Proxy proxy, boolean test_connectivity) {
        if (test_connectivity) {
            String connectivity = 200 == this.connect(serviceId, proxy) ? "Alive" : "Dead";
            exporter.addRow(serviceName, serviceId, this.getUrl(serviceId), connectivity);
        } else {
            exporter.addRow(serviceName, serviceId, this.getUrl(serviceId));
        }
    }

    private void setupDataForServices(DataExporter exporter, Proxy proxy, boolean test_connectivity) {
        for (Service service : Service.values()) {
            this.setupDataForService(service.name(), service.getServiceId(), exporter, proxy, test_connectivity);
        }
    }

    private void setupExporter(DataExporter exporter, boolean test_connectivity) {
        exporter.addColumns(new StringColumn("Service Name", 30, AlignType.MIDDLE_LEFT), new StringColumn("Service Id", 20, AlignType.MIDDLE_LEFT), new StringColumn("Url", 100, AlignType.MIDDLE_LEFT));
        if (test_connectivity) {
            exporter.addColumns(new StringColumn("Online", 10, AlignType.MIDDLE_CENTER));
        }
    }

    private void setupData(DataExporter exporter, Proxy proxy, boolean test_connectivity) {
        this.setupExporter(exporter, test_connectivity);
        this.setupDataForServices(exporter, proxy, test_connectivity);
    }

    private void setupData(Service service, DataExporter exporter, Proxy proxy, boolean test_connectivity) {
        String serviceName = service.name();
        String serviceId = service.getServiceId();
        this.setupExporter(exporter, test_connectivity);
        this.setupDataForService(serviceName, serviceId, exporter, proxy, test_connectivity);
    }

    private static DataExporter createExporter(String format, OutputStream stream) {
        DataExporter rval = null;
        switch (format) {
            case "csv": {
                CsvExportOptions options = new CsvExportOptions();
                options.setStrictQuoting(true);
                options.setPrintHeaders(false);
                rval = new CsvExporter(options);
                break;
            }
            case "xml": {
                XmlExportOptions options = new XmlExportOptions();
                options.setPrettyPrint(true);
                XmlExporter exporter = new XmlExporter(options);
                rval = exporter;
                break;
            }
            case "json": {
                JsonExportOptions options = new JsonExportOptions();
                options.setPrettyPrint(true);
                JsonExporter exporter = new JsonExporter(options);
                rval = exporter;
                break;
            }
            case "html": {
                HtmlExportOptions options = new HtmlExportOptions();
                options.setPrettyPrint(true);
                HtmlExporter exporter = new HtmlExporter(options);
                rval = exporter;
                break;
            }
            default: {
                TextTableExportOptions options = new TextTableExportOptions();
                options.setStyle(TextTableExportStyle.CLASSIC_SIMPLE);
                TextTableExporter exporter = new TextTableExporter(options);
                rval = exporter;
            }
        }
        if (null != stream) {
            PrintWriter writer = new PrintWriter(stream);
            rval.setOutputStream(writer);
        }
        return rval;
    }

    private static void help(String msg, Options options) {
        System.out.println(msg);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("-r <release family> -e <environment> <other args>", options);
    }

    private static void help(Options options) {
        UrlManager.help("", options);
    }

    public static enum Service {
        CLOUD_CENTER_SERVICE("ccs"),
        CLOUD_CENTER("cloudcenter"),
        CONTENT_SERVICE("cws"),
        DOWNLOADS_SERVICE("dws"),
        MCR_SERVICE("mcrdws"),
        LOGIN_SERVICE("loginws"),
        LICENSE_SERVICE("mllicserver"),
        ACTIVATION_SERVICE("mwaws"),
        STUDENT_ACTIVATION_SERVICE("svact"),
        SEGV_SERVICE("segv"),
        SERVICE_REQUEST_SERVICE("srws"),
        MATHWORKS_DOT_COM("mw"),
        USAGE_DATA_SERVICE("usagedataws"),
        GDS("gds"),
        GDS_JOBS("gdsjobs"),
        UDC("udc"),
        UDCPING("udcping"),
        SSID("ssidws"),
        APS_BROKER_WEBSOCKET("apsbrokerwebsocket"),
        EMBEDDED_LOGIN("embedded_login"),
        EMBEDDED_SIGNIN("embedded_signin"),
        ADD_ONS("add_ons"),
        HELP("help"),
        EXAMPLES("examples"),
        LCMPC("lcmpc"),
        AUTH("auth"),
        APS_AUTH("apsauth"),
        APS_AUTHNZ("apsauthnz"),
        DDUXWS("dduxws"),
        CONNECTIVITY("ccdiag"),
        MCI("mci"),
        APS_NOTIFICATIONS("apsnotifications"),
        DAWS("daws"),
        MLDO("mldo"),
        CCEMBED("ccembed"),
        MLDO_EMBED("mldoembed"),
        FILEEXCHANGE_REPOSITORY("fileexchangerepository"),
        SSD("ssd");

        private String serviceId;
        private static final Map<String, Service> idToService;

        private Service(String id) {
            this.serviceId = id;
        }

        public String getServiceId() {
            return this.serviceId;
        }

        public static Service id2Service(String id) {
            return idToService.get(id);
        }

        static {
            idToService = new HashMap<String, Service>();
            for (Service service : Service.values()) {
                idToService.put(service.getServiceId(), service);
            }
        }
    }
}

