/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.urlmanager;

import com.mathworks.webservices.urlmanager.ReleaseEnv;
import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;

class ReleaseEnvImpl
implements ReleaseEnv {
    private static final String PROPERTIES_FILE = "UrlManager_generated_props.properties";
    private static final String RELEASE_PROPERTY = "releasefamily";
    private static final String ENVIRONMENT_PROPERTY = "urlenv";
    private static final String RELEASE_OVERRIDE_PROPERTY = "WS_REL";
    private static final String ENVIRONMENT_OVERRIDE_PROPERTY = "WS_ENV";
    private static final String REMOVE_BEFORE_FLIGHT_TOKEN_FILE = "REMOVE_BEFORE_FLIGHT";
    private static final String VERSION_INFO = "VersionInfo.xml";
    private final String matlabRelease;
    private final String environment;
    private static Properties defaultProperties;
    private static boolean remove_before_flight;

    ReleaseEnvImpl() {
        this(defaultProperties);
    }

    ReleaseEnvImpl(Properties props) {
        this(props.getProperty(RELEASE_PROPERTY), props.getProperty(ENVIRONMENT_PROPERTY));
    }

    ReleaseEnvImpl(String releaseName, String releaseEnv) throws MissingResourceException {
        String rel = System.getenv(RELEASE_OVERRIDE_PROPERTY);
        rel = rel != null ? rel : System.getProperty(RELEASE_OVERRIDE_PROPERTY);
        this.matlabRelease = rel = rel != null ? rel : releaseName;
        if (null == this.matlabRelease) {
            throw new MissingResourceException("Properties file must contain property releasefamily", ReleaseEnvImpl.class.getSimpleName(), RELEASE_PROPERTY);
        }
        String env = System.getenv(ENVIRONMENT_OVERRIDE_PROPERTY);
        env = env != null ? env : System.getProperty(ENVIRONMENT_OVERRIDE_PROPERTY);
        String string = env = env != null ? env : releaseEnv;
        this.environment = env = env != null && !env.isEmpty() ? env : (remove_before_flight ? "integ" : "production");
        if (null == this.environment) {
            throw new MissingResourceException("Environment must be set", ReleaseEnvImpl.class.getSimpleName(), ENVIRONMENT_PROPERTY);
        }
    }

    @Override
    public String getMatlabRelease() {
        return this.matlabRelease;
    }

    @Override
    public String getReleaseEnvironment() {
        return this.environment;
    }

    @Override
    public List<String> getSearchPath() {
        return Arrays.asList(new Object[0]);
    }

    static {
        Path path;
        remove_before_flight = false;
        defaultProperties = new Properties();
        try {
            path = Paths.get(ReleaseEnvImpl.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            FileInputStream inputStream = new FileInputStream(Paths.get(path.getParent().toString(), PROPERTIES_FILE).toString());
            defaultProperties.load(inputStream);
            inputStream.close();
        }
        catch (Exception e) {
            System.out.println("Unable to load default properties from UrlManager_generated_props.properties");
        }
        try {
            path = Paths.get(ReleaseEnvImpl.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            while ((path = path.getParent()) != null) {
                if (Files.exists(Paths.get(path.toString(), REMOVE_BEFORE_FLIGHT_TOKEN_FILE), new LinkOption[0])) {
                    remove_before_flight = true;
                } else if (!Files.exists(Paths.get(path.toString(), VERSION_INFO), new LinkOption[0])) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (System.getenv("REMOVE_BEFORE_FLIGHT_DEBUG") != null) {
            if (remove_before_flight) {
                System.out.println("Found 'REMOVE_BEFORE_FLIGHT'");
            } else {
                System.out.println("Did not find 'REMOVE_BEFORE_FLIGHT'");
            }
        }
    }
}

