/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.brsanthu.dataexporter.model;

import com.mathworks.brsanthu.dataexporter.model.AlignType;
import com.mathworks.brsanthu.dataexporter.model.CellDetails;
import com.mathworks.brsanthu.dataexporter.model.Column;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateColumn
extends Column {
    private String dateFormat = null;
    private SimpleDateFormat df = null;

    public DateColumn(String name, int width, String dateFormat) {
        this(name, null, width, AlignType.MIDDLE_LEFT, dateFormat);
    }

    public DateColumn(String name, String title, int width, String dateFormat) {
        this(name, title, width, AlignType.MIDDLE_LEFT, dateFormat);
    }

    public DateColumn(String name, String title, int width, AlignType align, String dateFormat) {
        super(name, title, width, align);
        this.dateFormat = dateFormat;
        this.df = new SimpleDateFormat(dateFormat);
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    @Override
    public int getMaxRowHeight(CellDetails cellDetails) {
        Object cellValue = cellDetails.getCellValue();
        if (cellValue instanceof Date) {
            return (int)Math.ceil((float)this.df.format(cellValue).length() / (float)this.getWidth());
        }
        throw new IllegalArgumentException("Expected Date instance but it is " + cellValue.getClass().getName() + " instance with value " + cellValue);
    }

    @Override
    public String format(CellDetails cellDetails) {
        return this.df.format((Date)cellDetails.getCellValue());
    }
}

