/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.brsanthu.dataexporter.model;

import com.mathworks.brsanthu.dataexporter.TextAligner;
import com.mathworks.brsanthu.dataexporter.model.AlignType;
import com.mathworks.brsanthu.dataexporter.model.CellDetails;
import com.mathworks.brsanthu.dataexporter.model.CellValueGenerator;
import java.util.List;

public abstract class Column {
    public static TextAligner aligner = new TextAligner();
    private CellValueGenerator cellValueGenerator = null;
    private String title = null;
    private String title2 = "";
    private String title3 = "";
    private String name = null;
    private int width = 0;
    private AlignType align = null;
    private boolean generatesOwnData = false;
    private boolean nillable = false;
    protected String headerCellCssClass = null;
    protected String headerCellCssId = null;
    protected String headerCellCssStyle = null;
    protected String rowCellCssClass = null;
    protected String rowCellCssId = null;
    protected String rowCellCssStyle = null;

    public Column(String name) {
        this(name, name.length());
    }

    public Column(String name, int width) {
        this(name, null, width, AlignType.MIDDLE_LEFT);
    }

    public Column(String name, int width, AlignType align) {
        this(name, null, width, align);
    }

    public Column(String name, String title, int width, AlignType align) {
        this.title = title == null ? name : title;
        this.name = name;
        this.width = width;
        this.align = align;
    }

    public CellValueGenerator getCellValueGenerator() {
        return this.cellValueGenerator;
    }

    public Column setCellValueGenerator(CellValueGenerator generator) {
        this.cellValueGenerator = generator;
        return this;
    }

    public boolean isGeneratesOwnData() {
        return this.generatesOwnData;
    }

    public Column setGeneratesOwnData(boolean generatesOwnData) {
        this.generatesOwnData = generatesOwnData;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle2() {
        return this.title2;
    }

    public void setTitle2(String title2) {
        this.title2 = title2;
    }

    public String getTitle3() {
        return this.title3;
    }

    public void setTitle3(String title3) {
        this.title3 = title3;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public AlignType getAlign() {
        return this.align;
    }

    public void setAlign(AlignType align) {
        this.align = align;
    }

    public String getHeaderCellCssClass() {
        return this.headerCellCssClass;
    }

    public void setHeaderCellCssClass(String headerCellCssClass) {
        this.headerCellCssClass = headerCellCssClass;
    }

    public String getHeaderCellCssId() {
        return this.headerCellCssId;
    }

    public void setHeaderCellCssId(String headerCellCssId) {
        this.headerCellCssId = headerCellCssId;
    }

    public String getHeaderCellCssStyle() {
        return this.headerCellCssStyle;
    }

    public void setHeaderCellCssStyle(String headerCellCssStyle) {
        this.headerCellCssStyle = headerCellCssStyle;
    }

    public String getRowCellCssClass() {
        return this.rowCellCssClass;
    }

    public void setRowCellCssClass(String rowCellCssClass) {
        this.rowCellCssClass = rowCellCssClass;
    }

    public String getRowCellCssId() {
        return this.rowCellCssId;
    }

    public void setRowCellCssId(String rowCellCssId) {
        this.rowCellCssId = rowCellCssId;
    }

    public String getRowCellCssStyle() {
        return this.rowCellCssStyle;
    }

    public void setRowCellCssStyle(String rowCellCssStyle) {
        this.rowCellCssStyle = rowCellCssStyle;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public List<String> align(CellDetails cellDetails, String cellData) {
        return this.align(cellDetails, cellData, " ");
    }

    public List<String> align(CellDetails cellDetails, String cellData, String filler) {
        AlignType alignOverride = cellDetails.getCellAlign();
        if (alignOverride == null) {
            alignOverride = cellDetails.getColumn().getAlign();
        }
        return Column.align(cellDetails.getColumn().getWidth(), cellDetails.getRowHeight(), alignOverride, cellData, filler);
    }

    public static List<String> align(int width, int height, AlignType align, String value) {
        return Column.align(width, height, align, value, " ");
    }

    public static List<String> align(int width, int height, AlignType align, String value, String filler) {
        return aligner.align(width, height, align, value, filler);
    }

    public int getMaxRowHeight(String cellData) {
        return Column.getMaxRowHeight(this.getWidth(), cellData);
    }

    public static int getMaxRowHeight(int width, String value) {
        if (width <= 0) {
            width = 1;
        }
        return (int)Math.ceil((float)value.length() / (float)width);
    }

    public abstract int getMaxRowHeight(CellDetails var1);

    public abstract String format(CellDetails var1);
}

