/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.helper.ProjectHelper2;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.util.LoaderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectHelperRepository {
    private static final String DEBUG_PROJECT_HELPER_REPOSITORY = "ant.project-helper-repo.debug";
    private static final boolean DEBUG = "true".equals(System.getProperty("ant.project-helper-repo.debug"));
    private static ProjectHelperRepository instance = new ProjectHelperRepository();
    private List<Constructor<? extends ProjectHelper>> helpers = new ArrayList<Constructor<? extends ProjectHelper>>();
    private static Constructor<ProjectHelper2> PROJECTHELPER2_CONSTRUCTOR;

    public static ProjectHelperRepository getInstance() {
        return instance;
    }

    private ProjectHelperRepository() {
        this.collectProjectHelpers();
    }

    private void collectProjectHelpers() {
        block5: {
            Constructor<? extends ProjectHelper> projectHelper = this.getProjectHelperBySystemProperty();
            this.registerProjectHelper(projectHelper);
            try {
                InputStream systemResource;
                ClassLoader classLoader = LoaderUtils.getContextClassLoader();
                if (classLoader != null) {
                    Enumeration<URL> resources = classLoader.getResources("META-INF/services/org.apache.tools.ant.ProjectHelper");
                    while (resources.hasMoreElements()) {
                        URL resource = resources.nextElement();
                        URLConnection conn = resource.openConnection();
                        conn.setUseCaches(false);
                        projectHelper = this.getProjectHelperByService(conn.getInputStream());
                        this.registerProjectHelper(projectHelper);
                    }
                }
                if ((systemResource = ClassLoader.getSystemResourceAsStream("META-INF/services/org.apache.tools.ant.ProjectHelper")) != null) {
                    projectHelper = this.getProjectHelperByService(systemResource);
                    this.registerProjectHelper(projectHelper);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to load ProjectHelper from service META-INF/services/org.apache.tools.ant.ProjectHelper (" + e.getClass().getName() + ": " + e.getMessage() + ")");
                if (!DEBUG) break block5;
                e.printStackTrace(System.err);
            }
        }
    }

    public void registerProjectHelper(String helperClassName) throws BuildException {
        this.registerProjectHelper(this.getHelperConstructor(helperClassName));
    }

    public void registerProjectHelper(Class<? extends ProjectHelper> helperClass) throws BuildException {
        try {
            this.registerProjectHelper(helperClass.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw new BuildException("Couldn't find no-arg constructor in " + helperClass.getName());
        }
    }

    private void registerProjectHelper(Constructor<? extends ProjectHelper> helperConstructor) {
        if (helperConstructor == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("ProjectHelper " + helperConstructor.getClass().getName() + " registered.");
        }
        this.helpers.add(helperConstructor);
    }

    private Constructor<? extends ProjectHelper> getProjectHelperBySystemProperty() {
        block3: {
            String helperClass = System.getProperty("org.apache.tools.ant.ProjectHelper");
            try {
                if (helperClass != null) {
                    return this.getHelperConstructor(helperClass);
                }
            }
            catch (SecurityException e) {
                System.err.println("Unable to load ProjectHelper class \"" + helperClass + " specified in system property " + "org.apache.tools.ant.ProjectHelper" + " (" + e.getMessage() + ")");
                if (!DEBUG) break block3;
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    private Constructor<? extends ProjectHelper> getProjectHelperByService(InputStream is) {
        block5: {
            try {
                InputStreamReader isr;
                try {
                    isr = new InputStreamReader(is, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    isr = new InputStreamReader(is);
                }
                BufferedReader rd = new BufferedReader(isr);
                String helperClassName = rd.readLine();
                rd.close();
                if (helperClassName != null && !"".equals(helperClassName)) {
                    return this.getHelperConstructor(helperClassName);
                }
            }
            catch (Exception e) {
                System.out.println("Unable to load ProjectHelper from service META-INF/services/org.apache.tools.ant.ProjectHelper (" + e.getMessage() + ")");
                if (!DEBUG) break block5;
                e.printStackTrace(System.err);
            }
        }
        return null;
    }

    private Constructor<? extends ProjectHelper> getHelperConstructor(String helperClass) throws BuildException {
        ClassLoader classLoader = LoaderUtils.getContextClassLoader();
        try {
            Class<?> clazz = null;
            if (classLoader != null) {
                try {
                    clazz = classLoader.loadClass(helperClass);
                }
                catch (ClassNotFoundException ex) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = Class.forName(helperClass);
            }
            return clazz.asSubclass(ProjectHelper.class).getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    public ProjectHelper getProjectHelperForBuildFile(Resource buildFile) throws BuildException {
        Iterator<ProjectHelper> it = this.getHelpers();
        while (it.hasNext()) {
            ProjectHelper helper = it.next();
            if (!helper.canParseBuildFile(buildFile)) continue;
            if (DEBUG) {
                System.out.println("ProjectHelper " + helper.getClass().getName() + " selected for the build file " + buildFile);
            }
            return helper;
        }
        throw new BuildException("BUG: at least the ProjectHelper2 should have supported the file " + buildFile);
    }

    public ProjectHelper getProjectHelperForAntlib(Resource antlib) throws BuildException {
        Iterator<ProjectHelper> it = this.getHelpers();
        while (it.hasNext()) {
            ProjectHelper helper = it.next();
            if (!helper.canParseAntlibDescriptor(antlib)) continue;
            if (DEBUG) {
                System.out.println("ProjectHelper " + helper.getClass().getName() + " selected for the antlib " + antlib);
            }
            return helper;
        }
        throw new BuildException("BUG: at least the ProjectHelper2 should have supported the file " + antlib);
    }

    public Iterator<ProjectHelper> getHelpers() {
        return new ConstructingIterator(this.helpers.iterator());
    }

    static {
        try {
            PROJECTHELPER2_CONSTRUCTOR = ProjectHelper2.class.getConstructor(new Class[0]);
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstructingIterator
    implements Iterator<ProjectHelper> {
        private final Iterator<Constructor<? extends ProjectHelper>> nested;
        private boolean empty = false;

        ConstructingIterator(Iterator<Constructor<? extends ProjectHelper>> nested) {
            this.nested = nested;
        }

        @Override
        public boolean hasNext() {
            return this.nested.hasNext() || !this.empty;
        }

        @Override
        public ProjectHelper next() {
            Constructor c;
            if (this.nested.hasNext()) {
                c = this.nested.next();
            } else {
                this.empty = true;
                c = PROJECTHELPER2_CONSTRUCTOR;
            }
            try {
                return (ProjectHelper)c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new BuildException("Failed to invoke no-arg constructor on " + c.getName());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove is not supported");
        }
    }
}

