/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.release_info;

import com.mathworks.release_info.ReleaseInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class VersionInfoXmlBasedReleaseInfo
implements ReleaseInfo {
    private InputStream xmlStream;
    private String version;
    private String release;
    private String description = "";
    private String date;
    private String checksum;
    private Element rootElement;
    public ReleaseInfo.Status status;
    private Integer updateLevel = 0;
    private Integer build;

    public VersionInfoXmlBasedReleaseInfo(File file) throws IOException {
        if (!file.exists() || file.isDirectory()) {
            throw new FileNotFoundException("File does not exist: " + file.toString());
        }
        this.xmlStream = new FileInputStream(file);
        this.VersionInfoXmlBasedReleaseInfo_common();
    }

    public VersionInfoXmlBasedReleaseInfo(InputStream inputStream) throws IOException {
        this.xmlStream = inputStream;
        this.VersionInfoXmlBasedReleaseInfo_common();
    }

    private void VersionInfoXmlBasedReleaseInfo_common() throws IOException {
        this.parseXmlFile();
        this.deriveInformation();
    }

    private void parseXmlFile() throws IOException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(this.xmlStream);
            this.rootElement = document.getRootElement();
            if (this.rootElement == null) {
                throw new IOException("Failed to read VersionInfo.xml.");
            }
            this.version = this.getValue("version");
            this.release = this.getValue("release");
            this.description = this.getValue("description");
            this.date = this.getValue("date");
            this.checksum = this.getValue("checksum");
        }
        catch (JDOMException jDOMException) {
            throw new IOException("Could not read VersionInfo.xml.");
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private String getValue(String string) throws IOException {
        String string2 = this.rootElement.getChildText(string);
        if (string2 == null) {
            throw new IOException("Failed to read \"" + string + "\" in VersionInfo.xml.");
        }
        return string2;
    }

    private void deriveInformation() {
        this.status = this.description.contains("Development") ? ReleaseInfo.Status.DEVELOPMENT : (this.description.contains("Prerelease") ? ReleaseInfo.Status.PRERELEASE : ReleaseInfo.Status.RELEASE);
        if (this.description.contains("Update")) {
            this.updateLevel = Integer.valueOf(this.description.substring(this.description.lastIndexOf("Update ") + "Update ".length()));
        }
        this.build = Integer.valueOf(this.version.substring(this.version.lastIndexOf(".") + 1));
    }

    @Override
    public String getReleaseFamily() {
        return this.release;
    }

    @Override
    public ReleaseInfo.Status getStatus() {
        return this.status;
    }

    @Override
    public Integer getUpdateLevel() {
        return this.updateLevel;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getDate() {
        return this.date;
    }
}

