/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.release_info;

import com.mathworks.release_info.ReleaseInfo;
import com.mathworks.release_info.VersionInfoXmlBasedReleaseInfo;
import java.io.File;
import java.io.IOException;

public class ReleaseInfoUtils {
    public static String VERSION_INFO_FILE_NAME = "VersionInfo.xml";

    public static boolean sameRelease(ReleaseInfo releaseInfo, ReleaseInfo releaseInfo2) {
        return releaseInfo.getReleaseFamily().equalsIgnoreCase(releaseInfo2.getReleaseFamily());
    }

    public static boolean sameUpdateLevel(ReleaseInfo releaseInfo, ReleaseInfo releaseInfo2) {
        return ReleaseInfoUtils.sameRelease(releaseInfo, releaseInfo2) && releaseInfo.getStatus() == releaseInfo2.getStatus() && releaseInfo.getUpdateLevel().equals(releaseInfo2.getUpdateLevel());
    }

    public static ReleaseInfo getReleaseInfo(String string) throws IOException {
        File file = new File(string + File.separator + VERSION_INFO_FILE_NAME);
        return new VersionInfoXmlBasedReleaseInfo(file);
    }

    public static String getReleaseDescription(ReleaseInfo releaseInfo) {
        String string = releaseInfo.getReleaseFamily();
        if (releaseInfo.getStatus() == ReleaseInfo.Status.DEVELOPMENT) {
            string = string + "_Development";
        } else if (releaseInfo.getStatus() == ReleaseInfo.Status.PRERELEASE) {
            string = string + "_Prerelease";
        }
        if (releaseInfo.getUpdateLevel() != 0) {
            string = string + "_Update_" + releaseInfo.getUpdateLevel();
        }
        return string;
    }
}

