/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.authenticationws.client.rest.impl;

import com.mathworks.webservices.authenticationws.client.rest.impl.AuthenticationWSBaseClient;
import com.mathworks.webservices.authenticationws.client.rest.raw.RawByteResponse;
import com.mathworks.webservices.authenticationws.client.rest.request.BaseLoginServiceRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.ExpandTokenRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.LoginRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.LoginVerifyRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.LogoutRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.PingRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.ResendVerificationCodeRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.TokenExpirationRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.ValidateProfileRequest;
import com.mathworks.webservices.authenticationws.client.rest.request.ValidateTokenRequest;
import com.mathworks.webservices.authenticationws.client.rest.response.LoginResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.LogoutResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.MfaPendingToken;
import com.mathworks.webservices.authenticationws.client.rest.response.PingResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.ResendVerificationCodeDetailResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.ServiceResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.Token;
import com.mathworks.webservices.authenticationws.client.rest.response.TokenExpirationResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.ValidateProfileResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.ValidateTokenResponse;
import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AuthenticationWSClientImpl
extends AuthenticationWSBaseClient {
    private static final String PING_VALIDATION_STRING = "OK!";

    public AuthenticationWSClientImpl() {
    }

    public AuthenticationWSClientImpl(ClientConfiguration config) {
        super(config);
    }

    public AuthenticationWSClientImpl(MathWorksHttpClient httpClient) {
        super(httpClient);
    }

    @Override
    public LoginResponse login(LoginRequest loginRequest) {
        if (this.isEmptyString(loginRequest.getIdentifier())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Identifier cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        if (this.isEmptyString(loginRequest.getCredentials())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Credentials cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        if (this.isEmptyString(loginRequest.getType())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Type cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        HttpRequest req = this.createRequest(HttpMethodName.POST, "/v3/login", loginRequest);
        req.addParameter("identifier", loginRequest.getIdentifier());
        req.addParameter("credentials", loginRequest.getCredentials());
        req.addParameter("type", loginRequest.getType());
        req.addHeader("accept", "application/xml");
        if (!this.isEmptyString(loginRequest.getSourceId())) {
            req.addParameter("sourceId", loginRequest.getSourceId());
        }
        if (!this.isEmptyString(loginRequest.getProfileTier())) {
            req.addParameter("profileTier", loginRequest.getProfileTier());
        }
        if (!this.isEmptyString(loginRequest.getRelease())) {
            req.addParameter("release", loginRequest.getRelease());
        }
        if (!this.isEmptyString(loginRequest.getPlatform())) {
            req.addParameter("platform", loginRequest.getPlatform());
        }
        if (!this.isEmptyString(loginRequest.getEntitlementId())) {
            req.addParameter("entitlementId", loginRequest.getEntitlementId());
        }
        if (!this.isEmptyString(loginRequest.getMfaTokenString())) {
            req.addParameter("mfaTokenString", loginRequest.getMfaTokenString());
        }
        LoginResponse loginResponse = new LoginResponse();
        ServiceResponse response = this.executeRequestNew(req);
        if (response.getStatusCode() == 203) {
            loginResponse.setMfaPendingToken((MfaPendingToken)response.getResponsePayload());
        } else {
            loginResponse.setToken((Token)response.getResponsePayload());
        }
        return loginResponse;
    }

    @Override
    public Token loginVerify(LoginVerifyRequest loginVerifyRequest) {
        if (this.isEmptyString(loginVerifyRequest.getSecurityCode())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Security code cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        if (this.isEmptyString(loginVerifyRequest.getMfaType())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:MFA type cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        if (this.isEmptyString(loginVerifyRequest.getSecurityToken())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Security Token cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        HttpRequest req = this.createRequest(HttpMethodName.POST, "/v3/login/2fa/verification", loginVerifyRequest);
        req.addHeader("accept", "application/xml");
        req.addParameter("tokenString", loginVerifyRequest.getSecurityToken());
        req.addParameter("securityCode", loginVerifyRequest.getSecurityCode());
        req.addParameter("mfaType", loginVerifyRequest.getMfaType());
        if (!this.isEmptyString(loginVerifyRequest.getTrust())) {
            req.addParameter("trust", loginVerifyRequest.getTrust());
        }
        if (!this.isEmptyString(loginVerifyRequest.getUserAgent())) {
            req.addParameter("userAgent", loginVerifyRequest.getUserAgent());
        }
        if (!this.isEmptyString(loginVerifyRequest.getEntitlementId())) {
            req.addParameter("entitlementId", loginVerifyRequest.getEntitlementId());
        }
        if (!this.isEmptyString(loginVerifyRequest.getSourceId())) {
            req.addParameter("sourceId", loginVerifyRequest.getSourceId());
        }
        Token tokenResponse = (Token)this.executeRequestNew(req).getResponsePayload();
        return tokenResponse;
    }

    @Override
    public ResendVerificationCodeDetailResponse resendVerificationCode(ResendVerificationCodeRequest resendVerificationCodeRequest) {
        if (this.isEmptyString(resendVerificationCodeRequest.getMfaType())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:MFA type cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        if (this.isEmptyString(resendVerificationCodeRequest.getSecurityToken())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Security Token cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        HttpRequest req = this.createRequest(HttpMethodName.POST, "/v3/login/2fa/resend", resendVerificationCodeRequest);
        req.addHeader("accept", "application/xml");
        req.addParameter("tokenString", resendVerificationCodeRequest.getSecurityToken());
        req.addParameter("mfaType", resendVerificationCodeRequest.getMfaType());
        ResendVerificationCodeDetailResponse response = (ResendVerificationCodeDetailResponse)this.executeRequestNew(req).getResponsePayload();
        return response;
    }

    @Override
    public Token expandToken(ExpandTokenRequest expandTokenRequest) {
        if (this.isEmptyString(expandTokenRequest.getTokenString())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Token string cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        HttpRequest req = this.createRequest(HttpMethodName.POST, "/v3/tokens", expandTokenRequest);
        req.addParameter("tokenString", expandTokenRequest.getTokenString());
        req.addHeader("accept", "application/xml");
        if (!this.isEmptyString(expandTokenRequest.getTokenPolicyName())) {
            req.addParameter("tokenPolicyName", expandTokenRequest.getTokenPolicyName());
        }
        Token tokenResponse = (Token)this.executeRequestNew(req).getResponsePayload();
        return tokenResponse;
    }

    @Override
    public ValidateTokenResponse validateToken(ValidateTokenRequest validateTokenRequest) {
        if (this.isEmptyString(validateTokenRequest.getTokenString())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Token string cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        HttpRequest req = this.createRequest(HttpMethodName.POST, "/v3/tokens/validate", validateTokenRequest);
        req.addParameter("tokenString", validateTokenRequest.getTokenString());
        req.addParameter("tokenPolicyName", validateTokenRequest.getTokenPolicyName());
        req.addHeader("accept", "text/plain");
        if (!this.isEmptyString(validateTokenRequest.getSourceId())) {
            req.addParameter("sourceId", validateTokenRequest.getSourceId());
        }
        if (!this.isEmptyString(validateTokenRequest.getTokenPolicyName())) {
            req.addParameter("tokenPolicyName", validateTokenRequest.getTokenPolicyName());
        }
        RawByteResponse validateResponse = (RawByteResponse)((Object)this.executeRequestNew(req).getResponsePayload());
        ValidateTokenResponse response = new ValidateTokenResponse();
        response.setValid(Boolean.valueOf(new String(validateResponse.getResponseBody())));
        return response;
    }

    @Override
    public TokenExpirationResponse getTokenExpiration(TokenExpirationRequest tokenExpirationRequest) {
        if (this.isEmptyString(tokenExpirationRequest.getTokenString())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Token string cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        HttpRequest req = this.createRequest(HttpMethodName.POST, "/v3/tokens/expiration", tokenExpirationRequest);
        req.addParameter("tokenString", tokenExpirationRequest.getTokenString());
        req.addHeader("accept", "text/plain");
        if (!this.isEmptyString(tokenExpirationRequest.getPolicyName())) {
            req.addParameter("policyName", tokenExpirationRequest.getPolicyName());
        }
        RawByteResponse validateResponse = (RawByteResponse)((Object)this.executeRequestNew(req).getResponsePayload());
        TokenExpirationResponse response = new TokenExpirationResponse();
        try {
            String dateString = new String(validateResponse.getResponseBody());
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
            Date date = dateFormat.parse(dateString);
            response.setTokenExpirationDate(date);
            return response;
        }
        catch (ParseException e) {
            throw new MathWorksClientException("Failed to parse date", (Throwable)e);
        }
    }

    @Override
    public ValidateProfileResponse validateProfile(ValidateProfileRequest validateProfileRequest) {
        if (this.isEmptyString(validateProfileRequest.getTokenString())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Token cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        HttpRequest req = this.createRequest(HttpMethodName.POST, "/v3/references/validate", validateProfileRequest);
        req.addParameter("tokenString", validateProfileRequest.getTokenString());
        req.addHeader("accept", "text/plain");
        if (!this.isEmptyString(validateProfileRequest.getProfileTier())) {
            req.addParameter("profileTier", validateProfileRequest.getProfileTier());
        }
        if (!this.isEmptyString(validateProfileRequest.getRelease())) {
            req.addParameter("release", validateProfileRequest.getRelease());
        }
        if (!this.isEmptyString(validateProfileRequest.getPlatform())) {
            req.addParameter("platform", validateProfileRequest.getPlatform());
        }
        RawByteResponse validateResponse = (RawByteResponse)((Object)this.executeRequestNew(req).getResponsePayload());
        ValidateProfileResponse response = new ValidateProfileResponse();
        response.setValid(Boolean.valueOf(new String(validateResponse.getResponseBody())));
        return response;
    }

    @Override
    public LogoutResponse logout(LogoutRequest logoutRequest) {
        if (this.isEmptyString(logoutRequest.getTokenString())) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:Token cannot be empty");
            exception.setErrorCode("400");
            throw exception;
        }
        HttpRequest req = this.createRequest(HttpMethodName.DELETE, "/v3/logout", logoutRequest);
        req.setResourcePath(req.getResourcePath() + "/" + logoutRequest.getTokenString());
        return new LogoutResponse();
    }

    @Override
    public PingResponse ping(PingRequest pingRequest) {
        HttpRequest req = this.createRequest(HttpMethodName.GET, "/ping", pingRequest);
        RawByteResponse res = (RawByteResponse)((Object)this.executeRequestNew(req).getResponsePayload());
        String resString = new String(res.getResponseBody());
        PingResponse pingResponse = new PingResponse();
        pingResponse.setValid(resString.contains(PING_VALIDATION_STRING));
        return pingResponse;
    }

    private HttpRequest createRequest(HttpMethodName method, String resourcePath, BaseLoginServiceRequest<?> baseLoginServiceRequest) {
        String locale;
        HttpRequest request = new HttpRequest(method, this.endpoint, resourcePath);
        if (!this.isEmptyString(baseLoginServiceRequest.getClientString())) {
            request.addHeader("X_MW_WS_callerId", baseLoginServiceRequest.getClientString());
        }
        if (!this.isEmptyString(locale = baseLoginServiceRequest.getLocale())) {
            request.addHeader("X_MW_WS_locale", locale);
        } else {
            request.addHeader("X_MW_WS_locale", Locale.US.toString());
        }
        return request;
    }

    @Override
    protected String getContextPath() {
        return "com.mathworks.webservices.authenticationws.client.rest.response";
    }
}

