/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.authenticationws.client.rest.impl;

import com.mathworks.webservices.authenticationws.client.rest.AuthenticationWSClient;
import com.mathworks.webservices.authenticationws.client.rest.http.ContentTypeBaseHandler;
import com.mathworks.webservices.authenticationws.client.rest.raw.RawByteResponseHandler;
import com.mathworks.webservices.authenticationws.client.rest.response.ErrorResponse;
import com.mathworks.webservices.authenticationws.client.rest.response.ServiceResponse;
import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.HttpResponse;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import java.io.IOException;
import org.apache.commons.httpclient.Header;

public abstract class AuthenticationWSBaseClient
extends MathWorksWebServiceClient
implements AuthenticationWSClient {
    static final int SERVER = 500;
    static final int CLIENT_LOWER = 400;
    static final int CLIENT_UPPER = 499;
    static final int REDIRECTION_LOWER = 300;
    static final int REDIRECTION_UPPER = 399;
    static final int SUCCESSFUL = 200;
    static final int TWO_FACTOR_VERIFICATION = 203;
    static final String BAD_REQUEST = "400";
    private com.mathworks.webservices.authenticationws.client.rest.http.ResponseHandler errorResponseHandler;
    private com.mathworks.webservices.authenticationws.client.rest.http.ResponseHandler responseHandlerNew;

    public AuthenticationWSBaseClient() {
        this(new ClientConfiguration());
    }

    public AuthenticationWSBaseClient(ClientConfiguration config) {
        this(new MathWorksHttpClient(config));
    }

    public AuthenticationWSBaseClient(MathWorksHttpClient httpClient) {
        super(httpClient, (ResponseHandler)new JaxbResponseHandler());
        this.initializeErrorHandler();
        this.initializeHandlers();
    }

    private void initializeErrorHandler() {
        this.errorResponseHandler = new com.mathworks.webservices.authenticationws.client.rest.xml.JaxbResponseHandler(this.getContextPath());
    }

    private void initializeHandlers() {
        ContentTypeBaseHandler handler = new ContentTypeBaseHandler();
        handler.setResponseHandler("application/xml", new com.mathworks.webservices.authenticationws.client.rest.xml.JaxbResponseHandler(this.getContextPath()));
        handler.setResponseHandler("text/plain", new RawByteResponseHandler());
        handler.setResponseHandler("application/octet-stream", new RawByteResponseHandler());
        handler.setResponseHandler("*/*", new RawByteResponseHandler());
        this.setResponseHandlerNew(handler);
    }

    protected abstract String getContextPath();

    public String getEndpoint() {
        return this.endpoint;
    }

    protected com.mathworks.webservices.authenticationws.client.rest.http.ResponseHandler getResponseHandlerNew() {
        return this.responseHandlerNew;
    }

    protected void setResponseHandlerNew(com.mathworks.webservices.authenticationws.client.rest.http.ResponseHandler responseHandlerNew) {
        this.responseHandlerNew = responseHandlerNew;
    }

    protected com.mathworks.webservices.authenticationws.client.rest.http.ResponseHandler getErrorResponseHandler() {
        return this.errorResponseHandler;
    }

    protected void setErrorResponseHandler(com.mathworks.webservices.authenticationws.client.rest.http.ResponseHandler errorResponseHandler) {
        this.errorResponseHandler = errorResponseHandler;
    }

    public ServiceResponse executeRequestNew(HttpRequest request) {
        this.validateRequest(request);
        if (this.getResponseHandlerNew() == null) {
            throw new MathWorksClientException("Handler not set. Cannot execute request");
        }
        try {
            ErrorResponse errorResponse;
            Header endpointHeader;
            request.getRequest().setFollowRedirects(false);
            HttpResponse httpResp = this.httpClient.invoke(request.getRequest());
            int respCode = httpResp.getStatusCode();
            if (respCode >= 300 && respCode <= 399 && (endpointHeader = request.getRequest().getResponseHeader("x-mw-new-endpoint")) != null) {
                String newEndpoint = endpointHeader.getValue();
                if (newEndpoint != null && !newEndpoint.equalsIgnoreCase(this.endpoint)) {
                    this.endpoint = newEndpoint;
                    request.setEndpoint(this.endpoint);
                    httpResp = this.httpClient.invoke(request.getRequest(true));
                    respCode = httpResp.getStatusCode();
                } else {
                    ErrorResponse errorResponse2 = (ErrorResponse)this.getErrorResponseHandler().handleResponse(httpResp);
                    MathWorksServiceException mathWorksServiceException = new MathWorksServiceException(errorResponse2.getErrors().get(0).getMessage());
                    mathWorksServiceException.setErrorCode(errorResponse2.getErrors().get(0).getCode());
                    mathWorksServiceException.setStatusCode(httpResp.getStatusCode());
                    throw mathWorksServiceException;
                }
            }
            if (respCode >= 400 && respCode <= 499) {
                errorResponse = (ErrorResponse)this.getErrorResponseHandler().handleResponse(httpResp);
                MathWorksClientException mathworksClientException = new MathWorksClientException(errorResponse.getErrors().get(0).getMessage());
                mathworksClientException.setErrorCode(errorResponse.getErrors().get(0).getCode());
                throw mathworksClientException;
            }
            if (respCode >= 500) {
                errorResponse = (ErrorResponse)this.getErrorResponseHandler().handleResponse(httpResp);
                MathWorksServiceException mathWorksServiceException = new MathWorksServiceException(errorResponse.getErrors().get(0).getMessage());
                mathWorksServiceException.setErrorCode(errorResponse.getErrors().get(0).getCode());
                mathWorksServiceException.setStatusCode(httpResp.getStatusCode());
                throw mathWorksServiceException;
            }
            ServiceResponse response = new ServiceResponse();
            response.setHeaders(httpResp.getHeaders());
            response.setRequestId(httpResp.getRequestId());
            response.setStatusCode(respCode);
            response.setSignature(httpResp.getSignature());
            Object body = this.getResponseHandlerNew().handleResponse(httpResp);
            response.setResponsePayload(body);
            ServiceResponse serviceResponse = response;
            return serviceResponse;
        }
        catch (IOException e) {
            throw new MathWorksClientException("unable to connect to host. " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (request.getRequest() != null) {
                request.getRequest().releaseConnection();
            }
        }
    }

    private void validateRequest(HttpRequest request) throws MathWorksClientException {
        String requestEndpoint = request.getEndpoint();
        if (this.isEmptyString(requestEndpoint)) {
            throw new MathWorksClientException("Bad Request:Service endpoint cannot be empty.");
        }
        String requestClientString = (String)request.getHeaders().get("X_MW_WS_callerId");
        if (this.isEmptyString(requestClientString)) {
            MathWorksClientException exception = new MathWorksClientException("Bad Request:ClientString cannot be empty.");
            exception.setErrorCode(BAD_REQUEST);
            throw exception;
        }
    }

    protected boolean isEmptyString(String str) {
        return str == null || str.isEmpty();
    }
}

