/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.authenticationws.client.rest.http;

import com.mathworks.webservices.authenticationws.client.rest.http.ResponseHandler;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.http.HttpResponse;
import java.util.HashMap;
import java.util.Map;

public class ContentTypeBaseHandler
implements ResponseHandler {
    private Map<String, ResponseHandler> handlers = new HashMap<String, ResponseHandler>();

    public void setResponseHandler(String mediaType, ResponseHandler handler) {
        this.handlers.put(mediaType, handler);
    }

    public void removeResponseHandler(String mediaType) {
        this.handlers.remove(mediaType);
    }

    @Override
    public Object handleResponse(HttpResponse response) {
        ResponseHandler handler = null;
        String contentType = (String)response.getHeaders().get("Content-Type");
        if (contentType != null && !contentType.isEmpty()) {
            handler = this.handlers.get(contentType);
        }
        if (handler == null) {
            handler = this.handlers.get("*/*");
        }
        if (handler == null) {
            throw new MathWorksClientException("No handler set for content type " + contentType);
        }
        return handler.handleResponse(response);
    }
}

