/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.udc;

import com.mathworks.install.udc.UsageDataCollector;
import com.mathworks.install.udc.UsageDataCollectorKey;
import com.mathworks.instutil.InstutilResourceKeys;
import com.mathworks.instutil.Platform;
import com.mathworks.instutil.ProcessExecutorImpl;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;

public class UdcUtil {
    private static final String LSB_RELEASE = "/usr/bin/lsb_release";
    private boolean isOnline = false;
    private boolean isMatlabSelected = false;
    private boolean isMdcsSelected = false;
    private boolean isDduxSelected = true;
    private boolean silent = false;
    private final String sessionKey = UUID.randomUUID().toString();
    private static final UdcUtil INSTANCE = new UdcUtil();
    private boolean shouldShow;
    private boolean isChecked;
    private boolean isSelectable;

    private UdcUtil() {
    }

    public static UdcUtil getInstance() {
        return INSTANCE;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setOnline(boolean bl) {
        this.isOnline = bl;
    }

    public void setMatlabSelected(boolean bl) {
        this.isMatlabSelected = bl;
    }

    public void setMdcsSelected(boolean bl) {
        this.isMdcsSelected = bl;
    }

    public boolean isDduxCheckboxOnUISelected() {
        return this.isDduxSelected;
    }

    public void setDduxSelected(boolean bl) {
        this.isDduxSelected = bl;
    }

    public void setSilent(boolean bl) {
        this.silent = bl;
    }

    public boolean isDduxEnabled() {
        return this.shouldShow && this.isOnline && this.isMatlabSelected && !this.isMdcsSelected && !this.silent;
    }

    public boolean isDduxShown() {
        return this.shouldShow;
    }

    public boolean isEligibleForDdux() {
        return this.isOnline && !this.silent;
    }

    public boolean isMatlabSelected() {
        return this.isMatlabSelected;
    }

    public boolean isMdcsSelected() {
        return this.isMdcsSelected;
    }

    public void setShouldShow(boolean bl) {
        this.shouldShow = bl;
    }

    public void setIsChecked(boolean bl) {
        this.isChecked = bl;
    }

    public void setIsSelectable(boolean bl) {
        this.isSelectable = bl;
    }

    public boolean isValueFromServiceChecked() {
        return this.isChecked;
    }

    public boolean isSelectable() {
        return this.isSelectable;
    }

    public static void collectBasicSessionInfo(UsageDataCollector usageDataCollector) {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_START_TIME, date);
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_RELEASE_FAMILY, InstutilResourceKeys.RELEASE.getString(new Object[0]));
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_RELEASE, InstutilResourceKeys.RELEASE_DESCRIPTION.getString(new Object[0]));
    }

    public static void collectMemoryInfo(UsageDataCollector usageDataCollector) {
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
        long l = operatingSystemMXBean.getFreePhysicalMemorySize();
        long l2 = operatingSystemMXBean.getTotalPhysicalMemorySize();
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_MEMORY_FREE, l);
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_MEMORY_TOTAL, l2);
    }

    public static void collectOsInfo(UsageDataCollector usageDataCollector, ExecutorService executorService) {
        String string = System.getProperty("os.name");
        String string2 = System.getProperty("os.version");
        String string3 = System.getProperty("os.arch");
        if (string.equalsIgnoreCase("linux")) {
            String string4 = "Unknown Linux Distribution";
            File file = new File(LSB_RELEASE);
            if (file.exists() && file.canExecute()) {
                try {
                    String[] stringArray = new String[]{file.toString(), "-ds"};
                    ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                    Map<String, String> map = processBuilder.environment();
                    map.remove("LD_LIBRARY_PATH");
                    List list = ProcessExecutorImpl.executeTaskWithOutput((ProcessBuilder)processBuilder, (ExecutorService)executorService);
                    if (!list.isEmpty()) {
                        string4 = ((String)list.get(0)).replace('\"', ' ').trim();
                    }
                }
                catch (IOException | ExecutionException | TimeoutException exception) {
                    // empty catch block
                }
            }
            usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_LINUX_KERNEL_VERSION, string2);
            string2 = string4;
        }
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_OPERATING_SYSTEM_NAME, string);
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_OPERATING_SYSTEM_VERSION, string2);
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_OPERATING_SYSTEM_ARCH, string3);
    }

    public static void collectInstallTime(UsageDataCollector usageDataCollector, long l, long l2) {
        long l3 = (l2 - l) / 1000L;
        Object object = usageDataCollector.getData(UsageDataCollectorKey.SESSION_DATA_TOTAL_DOWNLOAD_TIME);
        if (object != null) {
            l3 -= ((Long)object).longValue();
        }
        usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_TOTAL_INSTALLATION_TIME, l3);
    }

    public static void collectCpuInfo(String string, Platform platform, ExecutorService executorService, UsageDataCollector usageDataCollector) {
        block36: {
            String string2 = UdcUtil.getExecutableSubPath(platform, "cpuid_info");
            if (platform.isWindows()) {
                string2 = string2.concat(".exe");
            }
            File file = new File(string, string2);
            try {
                if (!file.exists() || !file.canExecute()) break block36;
                String[] stringArray = new String[]{file.toString()};
                List list = ProcessExecutorImpl.executeTaskWithOutput((String[])stringArray, (ExecutorService)executorService);
                for (String string3 : list) {
                    String[] stringArray2 = string3.split(":");
                    if (stringArray2.length != 2) continue;
                    String string4 = stringArray2[0].trim();
                    String string5 = stringArray2[1].trim();
                    switch (string4) {
                        case "processorFamily": {
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_FAMILY, string5);
                            break;
                        }
                        case "processorVendor": {
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_VENDOR, string5);
                            break;
                        }
                        case "processorModel": {
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_MODEL, string5);
                            break;
                        }
                        case "processorStepping": {
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_STEPPING, string5);
                            break;
                        }
                        case "processorInstructionSets": {
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_INSTRUCTION_SETS, string5);
                            break;
                        }
                        case "processorHighestSIMDVersion": {
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_INSTRUCTION_SET_MAX, string5);
                            break;
                        }
                        case "processorPhysicalCores": {
                            int n = 1;
                            try {
                                n = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_PHYSICAL_CORES, n);
                            break;
                        }
                        case "processorLogicalCores": {
                            int n = 1;
                            try {
                                n = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_LOGICAL_CORES, n);
                            break;
                        }
                        case "processorHyperThreading": {
                            boolean bl = false;
                            try {
                                bl = Integer.parseInt(string5) > 0;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_HYPER_THREADING, bl);
                            break;
                        }
                        case "processorHyperVisor": {
                            boolean bl = false;
                            try {
                                bl = Integer.parseInt(string5) > 0;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_PROCESSOR_HYPER_VISOR, bl);
                            break;
                        }
                    }
                }
            }
            catch (Exception exception) {
                String string6 = exception.getMessage();
                usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_PROCESSOR_ERROR, string6);
            }
        }
    }

    public static void collectGpuInfo(String string, Platform platform, ExecutorService executorService, UsageDataCollector usageDataCollector) {
        String string2 = UdcUtil.getExecutableSubPath(platform, "gpu_info");
        if (platform.isWindows()) {
            string2 = string2.concat(".exe");
        }
        File file = new File(string, string2);
        try {
            if (file.exists() && file.canExecute()) {
                String[] stringArray = new String[]{file.toString()};
                List list = ProcessExecutorImpl.executeTaskWithOutput((String[])stringArray, (ExecutorService)executorService);
                usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_GPU_INFO, list);
            }
        }
        catch (Exception exception) {
            String string3 = exception.getMessage();
            usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_GPU_INFO_ERROR, string3);
        }
    }

    public static void callDduxSettingsExecutable(String string, Platform platform) {
        UdcUtil udcUtil = UdcUtil.getInstance();
        if (udcUtil.isMatlabSelected() && !udcUtil.isMdcsSelected()) {
            File file;
            String string2 = UdcUtil.getExecutableSubPath(platform, "ddux_settings");
            if (platform.isWindows()) {
                string2 = string2.concat(".exe");
            }
            if ((file = new File(string, string2)).exists() && file.canExecute()) {
                try {
                    String string3 = file.toString();
                    ArrayList<String> arrayList = new ArrayList<String>(4);
                    arrayList.add(string3);
                    arrayList.add("-m");
                    arrayList.add(string);
                    arrayList.add("-i");
                    arrayList.add(udcUtil.getSessionKey());
                    if (udcUtil.isEligibleForDdux()) {
                        if (udcUtil.isDduxShown()) {
                            arrayList.add("-s");
                            if (udcUtil.isDduxCheckboxOnUISelected()) {
                                arrayList.add("-c");
                            }
                        } else if (udcUtil.isValueFromServiceChecked()) {
                            arrayList.add("-c");
                        }
                    }
                    String[] stringArray = arrayList.toArray(new String[0]);
                    ProcessExecutorImpl processExecutorImpl = new ProcessExecutorImpl();
                    processExecutorImpl.executeWithTimeout(stringArray, 5000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static String getExecutableSubPath(Platform platform, String string) {
        return File.separator + "bin" + File.separator + platform.getArchString() + File.separator + string;
    }

    public static void collectWindowsVersionBuildInfo(String string, ExecutorService executorService, UsageDataCollector usageDataCollector, Platform platform) {
        if (platform.isWindows()) {
            String string2 = File.separator + "bin" + File.separator + platform.getArchString() + File.separator + "Windows_Version_Build_info.exe";
            FileSystem fileSystem = FileSystems.getDefault();
            Path path = fileSystem.getPath(string, string2);
            File file = path.toFile();
            try {
                if (file.exists() && file.canExecute()) {
                    String[] stringArray = new String[]{file.toString()};
                    List list = ProcessExecutorImpl.executeTaskWithOutput((String[])stringArray, (ExecutorService)executorService);
                    usageDataCollector.addData(UsageDataCollectorKey.SESSION_DATA_OPERATING_SYSTEM_VERSION, ((String)list.get(0)).trim());
                }
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                usageDataCollector.addData(UsageDataCollectorKey.USAGE_DATA_OPERATING_SYSTEM_VERSION_ERROR, string3);
            }
        }
    }
}

