/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc.io;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.LocaleSuffix;
import com.mathworks.install.command.doc.io.ContentPath;
import com.mathworks.install.command.doc.io.ContentTreeWalker;
import com.mathworks.install.command.doc.io.DestinationPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.install.command.doc.io.DocFileSystemBuilder;
import com.mathworks.install.command.doc.io.DocInstallerPath;
import com.mathworks.install.command.doc.io.DocSetItemDirectoryObserver;
import com.mathworks.instutil.FileIO;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.FilePermissionsUtil;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.IOObserver;
import com.mathworks.instutil.JNIException;
import com.mathworks.instutil.MachineInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class IoDocFileSystem
implements DocFileSystem {
    private final IO fIo;
    private final Path fContentDocRoot;
    private final Path fDestinationDocRoot;

    public IoDocFileSystem(IO iO, Path path, Path path2) {
        this.fIo = iO;
        this.fContentDocRoot = path;
        this.fDestinationDocRoot = path2;
    }

    public static DocFileSystemBuilder builder(IO iO) {
        return new Builder(iO);
    }

    public static DocFileSystemBuilder builder(String string) throws JNIException {
        return IoDocFileSystem.builder(Paths.get(string, new String[0]));
    }

    public static DocFileSystemBuilder builder(Path path) throws JNIException {
        return IoDocFileSystem.builder(IoDocFileSystem.createIoForBat(path.toFile()));
    }

    private static IO createIoForBat(File file) throws JNIException {
        File file2 = new File(file, "bin");
        String string = MachineInfo.getArch();
        File file3 = new File(file2, string);
        return new FileIO((FilePermissions)new FilePermissionsUtil(file3.toString()));
    }

    private Path getDocRootForLocation(DocInstallerPath.Location location) {
        switch (location) {
            case CONTENT: {
                return this.fContentDocRoot;
            }
            case DESTINATION: {
                return this.fDestinationDocRoot;
            }
        }
        throw new IllegalArgumentException("Location must be either CONTENT or DESTINATION");
    }

    @Override
    public void walkContentTree(DocSetItemDirectoryObserver docSetItemDirectoryObserver, DocDestination docDestination) throws IOException {
        ContentTreeWalker contentTreeWalker = new ContentTreeWalker(docSetItemDirectoryObserver, this, docDestination);
        Files.walkFileTree(this.fContentDocRoot, EnumSet.noneOf(FileVisitOption.class), 3, contentTreeWalker);
    }

    @Override
    public Collection<LocaleSuffix> findDirectoryLocaleSuffixes(DocInstallerPath docInstallerPath) {
        String string = IoDocFileSystem.getLocalizedDirectoryPattern(docInstallerPath);
        File[] fileArray = this.findLocalized(docInstallerPath, string);
        Pattern pattern = Pattern.compile(string);
        ArrayList<LocaleSuffix> arrayList = new ArrayList<LocaleSuffix>();
        for (File file : fileArray) {
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.find()) continue;
            arrayList.add(LocaleSuffix.fromString(matcher.group(1)));
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public boolean isFile(DocInstallerPath docInstallerPath) {
        Path path = this.toPath(docInstallerPath);
        return this.fIo.isFile(path.toFile());
    }

    @Override
    public boolean isDirectory(DocInstallerPath docInstallerPath) {
        Path path = this.toPath(docInstallerPath);
        return this.fIo.isDirectory(path.toFile());
    }

    @Override
    public ContentPath toContentDirectory(Path path) {
        Path path2 = this.fContentDocRoot.relativize(path);
        ArrayList<String> arrayList = new ArrayList<String>(path2.getNameCount());
        for (Path path3 : path2) {
            arrayList.add(path3.toString());
        }
        return ContentPath.getDirectory(arrayList);
    }

    @Override
    public String readFile(ContentPath contentPath) throws IOException {
        Path path = this.toPath(contentPath);
        return this.fIo.readFileToString(path.toFile());
    }

    @Override
    public InputStream getInputStream(ContentPath contentPath) throws IOException {
        Path path = this.toPath(contentPath);
        return new FileInputStream(path.toFile());
    }

    @Override
    public Properties readProperties(ContentPath contentPath) throws IOException {
        try (InputStream inputStream = this.getInputStream(contentPath);){
            Properties properties = new Properties();
            try (Object object = new InputStreamReader(inputStream, "UTF-8");){
                properties.load((Reader)object);
            }
            object = properties;
            return object;
        }
    }

    @Override
    public void copyFile(ContentPath contentPath, DestinationPath destinationPath) throws IOException {
        File file = this.toPath(contentPath).toFile();
        File file2 = this.toPath(destinationPath).toFile();
        this.fIo.copyFile(file, file2, new IOObserver[0]);
    }

    @Override
    public void delete(DestinationPath destinationPath, boolean bl) throws IOException {
        if (destinationPath.getPathType() == DocInstallerPath.PathType.DIRECTORY) {
            this.deleteDirectory(destinationPath, bl);
        } else {
            this.deleteFile(destinationPath, bl);
        }
    }

    private void deleteFile(DestinationPath destinationPath, boolean bl) {
        Path path = this.toPath(destinationPath);
        this.fIo.deleteFile(path.toFile());
        if (bl) {
            File[] fileArray;
            for (File file : fileArray = this.findLocalizedFiles(destinationPath)) {
                this.fIo.deleteFile(file);
            }
        }
    }

    private void deleteDirectory(DestinationPath destinationPath, boolean bl) throws IOException {
        Path path = this.toPath(destinationPath);
        this.fIo.deleteDirectory(path.toFile());
        if (bl) {
            File[] fileArray;
            for (File file : fileArray = this.findLocalizedDirectories(destinationPath)) {
                this.fIo.deleteDirectory(file);
            }
        }
    }

    @Override
    public OutputStream createOutputStream(DestinationPath destinationPath) throws FileNotFoundException {
        Path path = this.toPath(destinationPath);
        return new FileOutputStream(path.toFile());
    }

    @Override
    public void writeFile(byte[] byArray, DestinationPath destinationPath) throws IOException, InterruptedException {
        Path path = this.toPath(destinationPath);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
            this.fIo.createFileFromStream((InputStream)byteArrayInputStream, path.toFile(), System.currentTimeMillis(), 420, new IOObserver[0]);
        }
    }

    @Override
    public void createOutputDirectory() throws IOException {
        Path path = this.getDocRootForLocation(DocInstallerPath.Location.DESTINATION);
        File file = path.toFile();
        if (!this.fIo.isDirectory(file)) {
            file.mkdirs();
        }
    }

    @Override
    public URI getXslTemplateUri() {
        Path path = this.toPath(ContentPath.XSL_TEMPLATE);
        return path.toUri();
    }

    @Override
    public Directory openSearchIndex(DocInstallerPath docInstallerPath) throws IOException {
        Path path = this.toPath(docInstallerPath);
        if (docInstallerPath.getLocation() == DocInstallerPath.Location.CONTENT) {
            return FSDirectory.open((File)path.toFile());
        }
        return FSDirectory.open((File)path.toFile());
    }

    @Override
    public Path getContentDocRoot() {
        return this.fContentDocRoot;
    }

    private File[] findLocalizedFiles(DocInstallerPath docInstallerPath) {
        List<String> list = docInstallerPath.getRelativePath();
        String string = list.get(list.size() - 1);
        int n = string.lastIndexOf(46);
        String string2 = String.format("^%s(%s)%s", Pattern.quote(string.substring(0, n)), "_[a-z]{2}(_[A-Z]{2})?", Pattern.quote(string.substring(n)));
        return this.findLocalized(docInstallerPath, string2);
    }

    private File[] findLocalizedDirectories(DocInstallerPath docInstallerPath) {
        return this.findLocalized(docInstallerPath, IoDocFileSystem.getLocalizedDirectoryPattern(docInstallerPath));
    }

    private static String getLocalizedDirectoryPattern(DocInstallerPath docInstallerPath) {
        List<String> list = docInstallerPath.getRelativePath();
        String string = list.get(list.size() - 1);
        return String.format("^%s(%s)$", Pattern.quote(string), "_[a-z]{2}(_[A-Z]{2})?");
    }

    private File[] findLocalized(DocInstallerPath docInstallerPath, String string) {
        Path path = this.toPath(docInstallerPath);
        Path path2 = path.getParent();
        return this.fIo.listFiles(path2.toFile(), (FilenameFilter)new RegexpFilenameFilter(string));
    }

    private Path toPath(DocInstallerPath docInstallerPath) {
        Path path = this.getDocRootForLocation(docInstallerPath.getLocation());
        for (String string : docInstallerPath.getRelativePath()) {
            path = path.resolve(string);
        }
        return path;
    }

    public int hashCode() {
        return this.fIo.hashCode() + this.fDestinationDocRoot.hashCode() + this.fContentDocRoot.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof IoDocFileSystem) {
            IoDocFileSystem ioDocFileSystem = (IoDocFileSystem)object;
            return ioDocFileSystem.fIo.equals(this.fIo) && ioDocFileSystem.fContentDocRoot.equals(this.fContentDocRoot) && ioDocFileSystem.fDestinationDocRoot.equals(this.fDestinationDocRoot);
        }
        return false;
    }

    private static class RegexpFilenameFilter
    implements FilenameFilter {
        private final String iPattern;

        private RegexpFilenameFilter(String string) {
            this.iPattern = string;
        }

        @Override
        public boolean accept(File file, String string) {
            return string.matches(this.iPattern);
        }
    }

    private static class Builder
    implements DocFileSystemBuilder {
        private final IO iIo;
        private Path iContentDocRoot;
        private Path iDestinationDocRoot;

        private Builder(IO iO) {
            this.iIo = iO;
        }

        @Override
        public Builder contentDocRoot(Path path) {
            this.iContentDocRoot = path;
            return this;
        }

        @Override
        public Builder destinationDocRoot(Path path) {
            this.iDestinationDocRoot = path;
            return this;
        }

        @Override
        public DocFileSystem build() {
            return new IoDocFileSystem(this.iIo, this.iContentDocRoot, this.iDestinationDocRoot);
        }
    }
}

