/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc.io;

import com.mathworks.install.command.doc.LocaleSuffix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public abstract class DocInstallerPath {
    private final PathType fPathType;
    private final Location fLocation;
    private final List<String> fRelativePath;

    protected DocInstallerPath(Location location, PathType pathType, String ... stringArray) {
        this(location, pathType, Arrays.asList(stringArray));
    }

    protected DocInstallerPath(Location location, PathType pathType, List<String> list) {
        this.fLocation = location;
        this.fRelativePath = DocInstallerPath.correctRelativePath(list);
        this.fPathType = pathType;
    }

    private static List<String> correctRelativePath(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.isEmpty() || string.equals(".")) continue;
            arrayList.add(string);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Location getLocation() {
        return this.fLocation;
    }

    final PathType getPathType() {
        return this.fPathType;
    }

    public final List<String> getLocalizedPath(LocaleSuffix localeSuffix) {
        String string = this.getLastPathPart();
        String string2 = this.localizeName(string, localeSuffix);
        return this.replaceLastPathPart(string2);
    }

    private String getLastPathPart() {
        List<String> list = this.getRelativePath();
        if (list.isEmpty()) {
            return "";
        }
        return list.get(list.size() - 1);
    }

    private String localizeName(String string, LocaleSuffix localeSuffix) {
        switch (this.fPathType) {
            case DIRECTORY: {
                return localeSuffix.localizeDirectoryName(string);
            }
        }
        return localeSuffix.localizeFileName(string);
    }

    private List<String> replaceLastPathPart(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(this.getRelativePath());
        if (arrayList.isEmpty()) {
            return arrayList;
        }
        arrayList.set(arrayList.size() - 1, string);
        return arrayList;
    }

    public List<String> getRelativePath() {
        return this.fRelativePath;
    }

    public int hashCode() {
        return this.getLocation().hashCode() + this.getRelativePath().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DocInstallerPath) {
            DocInstallerPath docInstallerPath = (DocInstallerPath)object;
            return docInstallerPath.getLocation() == this.getLocation() && docInstallerPath.getRelativePath().equals(this.getRelativePath());
        }
        return false;
    }

    public String toString() {
        return this.getLocation().toString() + " : " + this.getRelativePathString();
    }

    private String getRelativePathString() {
        if (this.getRelativePath().isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.getRelativePath()) {
            stringBuilder.append('/').append(string);
        }
        return stringBuilder.toString().substring(1);
    }

    public static enum Location {
        CONTENT,
        DESTINATION;

    }

    public static enum PathType {
        FILE,
        DIRECTORY;

    }
}

