/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc.io;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.io.ContentPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.install.command.doc.io.DocSetItemDirectoryObserver;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ContentTreeWalker
extends SimpleFileVisitor<Path> {
    private final DocFileSystem docFileSystem;
    private final DocSetItemDirectoryObserver observer;
    private final Set<ContentPath> excludedPaths;

    public ContentTreeWalker(DocSetItemDirectoryObserver docSetItemDirectoryObserver, DocFileSystem docFileSystem, DocDestination docDestination) {
        this.observer = docSetItemDirectoryObserver;
        this.docFileSystem = docFileSystem;
        this.excludedPaths = ContentTreeWalker.getExcludedPaths(docDestination);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        ContentPath contentPath = this.docFileSystem.toContentDirectory(path);
        if (this.excludedPaths.contains(contentPath)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (this.checkForDocSetItem(contentPath)) {
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    private boolean checkForDocSetItem(ContentPath contentPath) throws IOException {
        ContentPath contentPath2 = contentPath.getDocCenterPropertiesPath();
        if (this.docFileSystem.isFile(contentPath2)) {
            this.observer.foundDocSetPath(contentPath);
            return true;
        }
        return false;
    }

    private static Set<ContentPath> getExcludedPaths(DocDestination docDestination) {
        String[] stringArray = new String[]{"includes", "examples", "toolbox", "techdoc", "pdf_doc", "templates"};
        HashSet<ContentPath> hashSet = new HashSet<ContentPath>();
        for (String string : stringArray) {
            hashSet.add(ContentPath.getDirectory(string));
        }
        if (docDestination == DocDestination.INSTALL) {
            hashSet.add(ContentPath.SUPPORT_PACKAGE_DIR);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof ContentTreeWalker) {
            ContentTreeWalker contentTreeWalker = (ContentTreeWalker)object;
            return contentTreeWalker.observer.equals(this.observer) && contentTreeWalker.docFileSystem.equals(this.docFileSystem) && contentTreeWalker.excludedPaths.equals(this.excludedPaths);
        }
        return false;
    }

    public int hashCode() {
        return this.docFileSystem.hashCode() + this.observer.hashCode() + this.excludedPaths.hashCode();
    }
}

