/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import com.mathworks.install.command.doc.LocaleSuffix;
import com.mathworks.install.command.doc.io.ContentPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.install.command.doc.io.DocSetItemSearchIndexPath;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class StandaloneProductList
implements DocSetItemList {
    private final DocFileSystem fDocFileSystem;
    private final Collection<LocaleSuffix> fLocaleSuffixes = new LinkedHashSet<LocaleSuffix>();
    private final String fDocSetName;
    private InstalledDocSetItem fDocSetItem;

    public StandaloneProductList(DocFileSystem docFileSystem, String string) {
        this.fDocFileSystem = docFileSystem;
        this.fDocSetName = string;
        this.fLocaleSuffixes.add(LocaleSuffix.getDefault());
    }

    @Override
    public void populate(DocDestination docDestination) throws IOException {
        ContentPath contentPath = ContentPath.DOC_ROOT.getDocCenterPropertiesPath();
        Properties properties = this.fDocFileSystem.readProperties(contentPath);
        if (!properties.stringPropertyNames().contains("shortname")) {
            properties.setProperty("shortname", this.fDocSetName);
        }
        boolean bl = this.fDocFileSystem.isFile(ContentPath.DOC_ROOT.getDocLandingPagePath());
        boolean bl2 = this.fDocFileSystem.isFile(ContentPath.DOC_ROOT.getExamplesLandingPagePath());
        this.fDocSetItem = InstalledDocSetItem.buildDocSetItem(ContentPath.DOC_ROOT, properties, bl, bl2);
        this.fLocaleSuffixes.addAll(this.fDocFileSystem.findDirectoryLocaleSuffixes(new DocSetItemSearchIndexPath(this.fDocSetItem)));
    }

    @Override
    public Collection<LocaleSuffix> getLocaleSuffixes() {
        return Collections.unmodifiableCollection(this.fLocaleSuffixes);
    }

    @Override
    public boolean isEmpty() {
        return this.fDocSetItem == null;
    }

    @Override
    public List<InstalledDocSetItem> getInstalledDocSetItems(Set<DocSetItemType> set) {
        if (set.contains((Object)DocSetItemType.PRODUCT) && this.fDocSetItem != null) {
            return Collections.singletonList(this.fDocSetItem);
        }
        return Collections.emptyList();
    }
}

