/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import com.mathworks.install.command.doc.LocaleSuffix;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.install.command.doc.io.DestinationPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.install.command.doc.io.DocSetItemSearchIndexPath;
import java.io.IOException;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

public class SearchIndexCommand
implements SharedDocSubCommand {
    @Override
    public void handleProductsFound(DocFileSystem docFileSystem, DocSetItemList docSetItemList) throws IOException, InterruptedException {
        for (LocaleSuffix localeSuffix : docSetItemList.getLocaleSuffixes()) {
            this.buildSearchIndex(docFileSystem, docSetItemList, localeSuffix);
        }
    }

    private void buildSearchIndex(DocFileSystem docFileSystem, DocSetItemList docSetItemList, LocaleSuffix localeSuffix) throws IOException {
        DestinationPath destinationPath = DestinationPath.SHARED_SEARCH_INDEX;
        destinationPath = destinationPath.localize(localeSuffix);
        docFileSystem.delete(destinationPath, false);
        List<InstalledDocSetItem> list = docSetItemList.getInstalledDocSetItems(EnumSet.allOf(DocSetItemType.class));
        Directory[] directoryArray = this.getSearchIndexesToMerge(docFileSystem, list, localeSuffix);
        if (directoryArray == null || directoryArray.length == 0) {
            return;
        }
        Directory directory = docFileSystem.openSearchIndex(destinationPath);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(Version.LUCENE_46, (Analyzer)new SimpleAnalyzer(Version.LUCENE_46));
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        try (IndexWriter indexWriter = new IndexWriter(directory, indexWriterConfig);){
            indexWriter.addIndexes(directoryArray);
            indexWriter.forceMerge(1);
        }
    }

    @Override
    public void handleNoProducts(DocFileSystem docFileSystem) throws IOException, InterruptedException {
        docFileSystem.delete(DestinationPath.SHARED_SEARCH_INDEX, true);
    }

    private Directory[] getSearchIndexesToMerge(DocFileSystem docFileSystem, Iterable<InstalledDocSetItem> iterable, LocaleSuffix localeSuffix) throws IOException {
        LinkedList<Directory> linkedList = new LinkedList<Directory>();
        for (InstalledDocSetItem installedDocSetItem : iterable) {
            Directory directory;
            DocSetItemSearchIndexPath docSetItemSearchIndexPath = this.findProductIndex(docFileSystem, installedDocSetItem, localeSuffix);
            if (docSetItemSearchIndexPath == null || !DirectoryReader.indexExists((Directory)(directory = docFileSystem.openSearchIndex(docSetItemSearchIndexPath)))) continue;
            linkedList.add(directory);
        }
        return linkedList.toArray(new Directory[linkedList.size()]);
    }

    private DocSetItemSearchIndexPath findProductIndex(DocFileSystem docFileSystem, InstalledDocSetItem installedDocSetItem, LocaleSuffix localeSuffix) {
        DocSetItemSearchIndexPath docSetItemSearchIndexPath = new DocSetItemSearchIndexPath(installedDocSetItem);
        DocSetItemSearchIndexPath docSetItemSearchIndexPath2 = docSetItemSearchIndexPath.localize(localeSuffix);
        if (docFileSystem.isDirectory(docSetItemSearchIndexPath2)) {
            return docSetItemSearchIndexPath2;
        }
        if (!docSetItemSearchIndexPath2.equals(docSetItemSearchIndexPath) && docFileSystem.isDirectory(docSetItemSearchIndexPath)) {
            return docSetItemSearchIndexPath;
        }
        return null;
    }
}

