/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.ProductFamily;
import com.mathworks.install.command.doc.io.ContentPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ProductFamilyProperties {
    private final Map<String, List<ProductFamily>> fProductFamilyMap = new LinkedHashMap<String, List<ProductFamily>>();

    ProductFamilyProperties(DocFileSystem docFileSystem) {
        this(new DefaultProductFamilyFileReader(docFileSystem));
    }

    public ProductFamilyProperties(ProductFamilyLoader productFamilyLoader) {
        this.fProductFamilyMap.putAll(ProductFamilyProperties.populateProductFamilyMap(productFamilyLoader));
    }

    public Map<String, List<ProductFamily>> getProductFamilyMap() {
        return Collections.unmodifiableMap(this.fProductFamilyMap);
    }

    public List<ProductFamily> getProductFamilies(String string) {
        List<ProductFamily> list = this.getProductFamilyMap().get(string);
        if (list != null && !list.isEmpty()) {
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private static Map<String, List<ProductFamily>> populateProductFamilyMap(ProductFamilyLoader productFamilyLoader) {
        try {
            Properties properties = productFamilyLoader.loadProductFamilyProperties();
            LinkedHashMap<String, List<ProductFamily>> linkedHashMap = new LinkedHashMap<String, List<ProductFamily>>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Object object = entry.getKey();
                Object object2 = entry.getValue();
                List<ProductFamily> list = ProductFamilyProperties.getProductFamilyList(object2);
                linkedHashMap.put(object.toString(), list);
            }
            return linkedHashMap;
        }
        catch (IOException iOException) {
            return Collections.emptyMap();
        }
    }

    private static List<ProductFamily> getProductFamilyList(Object object) {
        if (object == null || object.toString().trim().isEmpty()) {
            return Collections.emptyList();
        }
        String string = object.toString();
        LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList(string.trim().split("\\|")));
        LinkedList<ProductFamily> linkedList2 = new LinkedList<ProductFamily>();
        for (String string2 : linkedList) {
            List<ProductFamily> list = ProductFamilyProperties.getFamilyList(string2);
            linkedList2.addAll(list);
        }
        return linkedList2;
    }

    private static List<ProductFamily> getFamilyList(String string) {
        if (string == null || string.trim().isEmpty()) {
            return Collections.emptyList();
        }
        String[] stringArray = string.trim().split("/");
        String string2 = stringArray[0];
        LinkedList<ProductFamily> linkedList = new LinkedList<ProductFamily>();
        if (stringArray.length == 1) {
            ProductFamily productFamily = new ProductFamily(string2);
            linkedList.add(productFamily);
            return linkedList;
        }
        LinkedList<String> linkedList2 = new LinkedList<String>(Arrays.asList(stringArray[1].trim().split(",")));
        for (String string3 : linkedList2) {
            ProductFamily productFamily = new ProductFamily(string2, string3);
            linkedList.add(productFamily);
        }
        return linkedList;
    }

    private static class DefaultProductFamilyFileReader
    implements ProductFamilyLoader {
        private final DocFileSystem iDocFileSystem;

        private DefaultProductFamilyFileReader(DocFileSystem docFileSystem) {
            this.iDocFileSystem = docFileSystem;
        }

        @Override
        public Properties loadProductFamilyProperties() throws IOException {
            return this.getPropertiesFromFile(ContentPath.PRODUCT_FAMILY_PROPERTIES);
        }

        private Properties getPropertiesFromFile(ContentPath contentPath) throws IOException {
            try (InputStream inputStream = this.iDocFileSystem.getInputStream(contentPath);){
                Properties properties = DefaultProductFamilyFileReader.getPropertiesFromInputStream(inputStream);
                return properties;
            }
        }

        private static Properties getPropertiesFromInputStream(InputStream inputStream) throws IOException {
            Properties properties = new Properties();
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");){
                properties.load(inputStreamReader);
            }
            return properties;
        }
    }

    public static interface ProductFamilyLoader {
        public Properties loadProductFamilyProperties() throws IOException;
    }
}

