/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.BuildSharedDocController;
import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetProperties;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.install.command.doc.io.DocFileSystemBuilder;
import com.mathworks.install.command.doc.io.IoDocFileSystem;
import com.mathworks.instutil.JNIException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class MatlabSharedDocBuilder {
    private final String fMatlabRoot;
    private final DocDestination fDocDestination;
    private String fDocSetName = "doccenter";
    private String fHelpDir = null;
    private String fOutputDir = null;
    private String fContentRoot = null;
    private DocSetProperties.DocSetType fType = DocSetProperties.DocSetType.DEFAULT;
    private boolean fWriteEmptyDocSetFile = true;

    public MatlabSharedDocBuilder(String string) {
        this(string, DocDestination.INSTALL);
    }

    public MatlabSharedDocBuilder(String string, String string2) {
        this(string, DocDestination.resolve(string2));
    }

    public MatlabSharedDocBuilder(String string, DocDestination docDestination) {
        this.fMatlabRoot = string;
        this.fDocDestination = docDestination;
    }

    public MatlabSharedDocBuilder setDocSetName(String string) {
        this.fDocSetName = string;
        return this;
    }

    public MatlabSharedDocBuilder setHelpDir(String string) {
        this.fHelpDir = string;
        return this;
    }

    public MatlabSharedDocBuilder setOutputDir(String string) {
        this.fOutputDir = string;
        return this;
    }

    public MatlabSharedDocBuilder setContentRoot(String string) {
        this.fContentRoot = string;
        return this;
    }

    public MatlabSharedDocBuilder setStandalone() {
        return this.setType(DocSetProperties.DocSetType.STANDALONE_PRODUCT);
    }

    public MatlabSharedDocBuilder setNoLandingPage() {
        return this.setType(DocSetProperties.DocSetType.NO_LANDING_PAGE);
    }

    public MatlabSharedDocBuilder setType(DocSetProperties.DocSetType docSetType) {
        this.fType = docSetType;
        return this;
    }

    public MatlabSharedDocBuilder setWriteEmptyDocSetFile(boolean bl) {
        this.fWriteEmptyDocSetFile = bl;
        return this;
    }

    public void buildSharedDocFiles() throws IOException, InterruptedException, JNIException {
        DocFileSystem docFileSystem = this.getDocFileSystem();
        DocSetProperties docSetProperties = this.getDocSetProperties();
        BuildSharedDocController buildSharedDocController = new BuildSharedDocController(docSetProperties, this.fWriteEmptyDocSetFile);
        buildSharedDocController.execute(docFileSystem);
    }

    private DocFileSystem getDocFileSystem() throws JNIException {
        DocFileSystemBuilder docFileSystemBuilder = IoDocFileSystem.builder(this.fMatlabRoot);
        docFileSystemBuilder.contentDocRoot(this.getContentDocRoot());
        docFileSystemBuilder.destinationDocRoot(this.getDestinationDocRoot());
        return docFileSystemBuilder.build();
    }

    private DocSetProperties getDocSetProperties() {
        String string = this.fHelpDir == null ? "" : this.fHelpDir;
        return new DocSetProperties(this.fDocDestination, this.fDocSetName, string, this.fType);
    }

    private Path getContentDocRoot() {
        Path path;
        Path path2 = path = this.fContentRoot == null ? Paths.get(this.fMatlabRoot, "help") : Paths.get(this.fContentRoot, new String[0]);
        if (this.fHelpDir == null) {
            return path;
        }
        return path.resolve(this.fHelpDir);
    }

    private Path getDestinationDocRoot() {
        if (this.fOutputDir == null) {
            return this.getContentDocRoot();
        }
        return Paths.get(this.fOutputDir, new String[0]);
    }
}

