/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import java.util.ArrayList;
import java.util.List;

public class LocaleSuffix {
    public static final String LOCALE_SUFFIX_PATTERN = "_[a-z]{2}(_[A-Z]{2})?";
    private final String fSuffixWithLeadingUnderscore;

    private LocaleSuffix(String string) {
        String string2 = String.format("^%s$", LOCALE_SUFFIX_PATTERN);
        this.fSuffixWithLeadingUnderscore = string.matches(string2) ? string : "";
    }

    public static LocaleSuffix fromString(String string) {
        if (string == null || string.trim().isEmpty()) {
            return LocaleSuffix.getDefault();
        }
        if (string.charAt(0) == '_') {
            return new LocaleSuffix(string);
        }
        return new LocaleSuffix('_' + string);
    }

    public static List<LocaleSuffix> fromStrings(String ... stringArray) {
        ArrayList<LocaleSuffix> arrayList = new ArrayList<LocaleSuffix>(stringArray.length);
        for (String string : stringArray) {
            arrayList.add(LocaleSuffix.fromString(string));
        }
        return arrayList;
    }

    public static LocaleSuffix getDefault() {
        return new LocaleSuffix("");
    }

    public String localizeFileName(String string) {
        if (this.isDefault()) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            return string.substring(0, n) + this.fSuffixWithLeadingUnderscore + string.substring(n);
        }
        return string + this.fSuffixWithLeadingUnderscore;
    }

    public String localizeDirectoryName(String string) {
        if (this.isDefault()) {
            return string;
        }
        return string + this.fSuffixWithLeadingUnderscore;
    }

    public String toXslParameterValue() {
        if (this.isDefault()) {
            return "";
        }
        return this.fSuffixWithLeadingUnderscore.substring(1);
    }

    boolean isDefault() {
        return this.fSuffixWithLeadingUnderscore.isEmpty();
    }

    public int hashCode() {
        return this.fSuffixWithLeadingUnderscore.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof LocaleSuffix) {
            return ((LocaleSuffix)object).fSuffixWithLeadingUnderscore.equals(this.fSuffixWithLeadingUnderscore);
        }
        return false;
    }
}

