/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetItemComparator;
import com.mathworks.install.command.doc.DocSetItemFilter;
import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import com.mathworks.install.command.doc.LocaleSuffix;
import com.mathworks.install.command.doc.ProductFamily;
import com.mathworks.install.command.doc.ProductFamilyProperties;
import com.mathworks.install.command.doc.io.ContentPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.install.command.doc.io.DocSetItemDirectoryObserver;
import com.mathworks.install.command.doc.io.DocSetItemSearchIndexPath;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class InstallerDocSetItemList
implements DocSetItemList,
DocSetItemDirectoryObserver {
    private final DocFileSystem docFileSystem;
    private final Map<DocSetItemType, List<InstalledDocSetItem>> docSetItemMap = new EnumMap<DocSetItemType, List<InstalledDocSetItem>>(DocSetItemType.class);
    private final Collection<LocaleSuffix> localeSuffixes = new LinkedHashSet<LocaleSuffix>();
    private final ProductFamilyProperties productFamilyProperties;
    private final DocSetItemFilter filter;

    public InstallerDocSetItemList(DocFileSystem docFileSystem, ProductFamilyProperties productFamilyProperties, DocSetItemFilter docSetItemFilter) {
        this.docFileSystem = docFileSystem;
        this.productFamilyProperties = productFamilyProperties;
        this.filter = docSetItemFilter;
        this.localeSuffixes.add(LocaleSuffix.getDefault());
    }

    @Override
    public final synchronized void populate(DocDestination docDestination) throws IOException {
        this.prepareItemMap();
        this.docFileSystem.walkContentTree(this, docDestination);
        this.sortDocSetItems();
    }

    public void prepareItemMap() {
        this.docSetItemMap.clear();
        for (DocSetItemType docSetItemType : DocSetItemType.values()) {
            this.docSetItemMap.put(docSetItemType, new LinkedList());
        }
    }

    public void sortDocSetItems() {
        for (List<InstalledDocSetItem> list : this.docSetItemMap.values()) {
            Collections.sort(list, new DocSetItemComparator());
        }
    }

    @Override
    public synchronized Collection<LocaleSuffix> getLocaleSuffixes() {
        return Collections.unmodifiableCollection(this.localeSuffixes);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.docSetItemMap.get((Object)DocSetItemType.PRODUCT).isEmpty() && this.docSetItemMap.get((Object)DocSetItemType.ADDON).isEmpty();
    }

    @Override
    public synchronized List<InstalledDocSetItem> getInstalledDocSetItems(Set<DocSetItemType> set) {
        LinkedList linkedList = new LinkedList();
        for (DocSetItemType docSetItemType : set) {
            linkedList.addAll(this.docSetItemMap.get((Object)docSetItemType));
        }
        return Collections.unmodifiableList(linkedList);
    }

    @Override
    public void foundDocSetPath(ContentPath contentPath) throws IOException {
        boolean bl;
        boolean bl2;
        Properties properties = this.docFileSystem.readProperties(contentPath.getDocCenterPropertiesPath());
        InstalledDocSetItem installedDocSetItem = InstalledDocSetItem.buildDocSetItem(contentPath, properties, bl2 = this.docFileSystem.isFile(contentPath.getDocLandingPagePath()), bl = this.docFileSystem.isFile(contentPath.getExamplesLandingPagePath()));
        if (this.filter.includeDocSetItem(installedDocSetItem.getType(), properties)) {
            DocSetItemSearchIndexPath docSetItemSearchIndexPath = new DocSetItemSearchIndexPath(installedDocSetItem);
            Collection<LocaleSuffix> collection = this.docFileSystem.findDirectoryLocaleSuffixes(docSetItemSearchIndexPath);
            if (installedDocSetItem.getProductFamilies().isEmpty()) {
                List<ProductFamily> list = this.productFamilyProperties.getProductFamilies(installedDocSetItem.getShortName());
                installedDocSetItem.setProductFamilies(list);
            }
            this.addDocSetItem(installedDocSetItem, collection);
        }
    }

    public void addDocSetItem(InstalledDocSetItem installedDocSetItem, Collection<LocaleSuffix> collection) {
        this.localeSuffixes.addAll(collection);
        this.docSetItemMap.get((Object)installedDocSetItem.getType()).add(installedDocSetItem);
    }
}

