/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.BuildSharedDocController;
import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetProperties;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.install.command.doc.io.DocFileSystemBuilder;
import com.mathworks.install.command.doc.io.IoDocFileSystem;
import com.mathworks.instutil.IO;
import java.nio.file.Path;

public enum InstallerDocSet {
    DOCCENTER,
    POLYSPACE;


    BuildSharedDocController getController() {
        DocSetProperties docSetProperties = this.getProperties();
        return new BuildSharedDocController(docSetProperties, false);
    }

    private DocSetProperties getProperties() {
        switch (this) {
            case POLYSPACE: {
                return new DocSetProperties(DocDestination.INSTALL, "polyspace", "", DocSetProperties.DocSetType.NO_LANDING_PAGE);
            }
        }
        return DocSetProperties.defaultProperties(DocDestination.INSTALL);
    }

    DocFileSystemBuilder getDocFileSystemBuilder(IO iO) {
        DocFileSystemBuilder docFileSystemBuilder = IoDocFileSystem.builder(iO);
        return this.getDocFileSystemBuilder(docFileSystemBuilder);
    }

    public DocFileSystemBuilder getDocFileSystemBuilder(DocFileSystemBuilder docFileSystemBuilder) {
        if (this == POLYSPACE) {
            return new PolyspaceDocFileSystemBuilder(docFileSystemBuilder);
        }
        return docFileSystemBuilder;
    }

    private static class PolyspaceDocFileSystemBuilder
    implements DocFileSystemBuilder {
        private final DocFileSystemBuilder iRealBuilder;

        private PolyspaceDocFileSystemBuilder(DocFileSystemBuilder docFileSystemBuilder) {
            this.iRealBuilder = docFileSystemBuilder;
        }

        @Override
        public DocFileSystemBuilder contentDocRoot(Path path) {
            this.iRealBuilder.contentDocRoot(path);
            return this;
        }

        @Override
        public DocFileSystemBuilder destinationDocRoot(Path path) {
            Path path2 = path.resolve("polyspace_shared");
            this.iRealBuilder.destinationDocRoot(path2);
            return this;
        }

        @Override
        public DocFileSystem build() {
            return this.iRealBuilder.build();
        }
    }
}

