/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.ProductFamily;
import com.mathworks.install.command.doc.io.ContentPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class InstalledDocSetItem {
    static final String SHORTNAME_PROP = "shortname";
    private static final String DISPLAYNAME_PROP = "displayname";
    private static final String STATUS_PROP = "status";
    private static final String BASEPRODUCT_SHORTNAME_PROP = "baseshortname";
    private static final String TOOLBOX_DIR_PROP = "toolboxdir";
    private final String shortName;
    private final String displayName;
    private final String helpLoc;
    private final String status;
    private final String baseProductShortName;
    private final List<String> altShortNames = new ArrayList<String>();
    private final DocSetItemType type;
    private final List<ProductFamily> productFamilies = new ArrayList<ProductFamily>();
    private final boolean hasDocLandingPage;
    private final boolean hasExamplesLandingPage;

    private InstalledDocSetItem(ContentPath contentPath, Properties properties, boolean bl, boolean bl2) {
        this.helpLoc = InstalledDocSetItem.toHelpLocation(contentPath);
        this.shortName = InstalledDocSetItem.getValue(properties, SHORTNAME_PROP, InstalledDocSetItem.resolveShortName(contentPath));
        this.displayName = InstalledDocSetItem.getValue(properties, DISPLAYNAME_PROP, this.shortName);
        this.baseProductShortName = InstalledDocSetItem.getValue(properties, BASEPRODUCT_SHORTNAME_PROP, null);
        this.type = this.baseProductShortName == null || this.baseProductShortName.isEmpty() ? DocSetItemType.PRODUCT : DocSetItemType.ADDON;
        this.altShortNames.addAll(InstalledDocSetItem.getAlternateShortNames(properties));
        this.status = InstalledDocSetItem.getValue(properties, STATUS_PROP, "");
        this.hasDocLandingPage = bl;
        this.hasExamplesLandingPage = bl2;
    }

    private static String getValue(Properties properties, String string, String string2) {
        if (properties.containsKey(string)) {
            return properties.getProperty(string);
        }
        return string2;
    }

    private static String resolveShortName(ContentPath contentPath) {
        List<String> list = contentPath.getRelativePath();
        return list.isEmpty() ? "" : list.get(list.size() - 1);
    }

    public static InstalledDocSetItem buildDocSetItem(ContentPath contentPath, Properties properties, boolean bl, boolean bl2) {
        return new InstalledDocSetItem(contentPath, properties, bl, bl2);
    }

    private static String toHelpLocation(ContentPath contentPath) {
        if (contentPath.getRelativePath().isEmpty()) {
            return ".";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : contentPath.getRelativePath()) {
            stringBuilder.append('/').append(string);
        }
        return stringBuilder.toString().substring(1);
    }

    private static Collection<String> getAlternateShortNames(Properties properties) {
        if (properties.containsKey(TOOLBOX_DIR_PROP)) {
            return Collections.singletonList(properties.getProperty(TOOLBOX_DIR_PROP));
        }
        return Collections.emptyList();
    }

    public void setProductFamilies(Collection<ProductFamily> collection) {
        this.productFamilies.addAll(collection);
    }

    public Collection<ProductFamily> getProductFamilies() {
        return Collections.unmodifiableList(this.productFamilies);
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getHelpLoc() {
        return this.helpLoc;
    }

    public String getBaseProductShortName() {
        return this.baseProductShortName;
    }

    public Collection<String> getAltShortNames() {
        return Collections.unmodifiableList(this.altShortNames);
    }

    public DocSetItemType getType() {
        return this.type;
    }

    String getStatus() {
        return this.status;
    }

    boolean hasDocLandingPage() {
        return this.hasDocLandingPage;
    }

    boolean hasExamplesLandingPage() {
        return this.hasExamplesLandingPage;
    }
}

