/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.install.command.doc.io.ContentPath;
import com.mathworks.install.command.doc.io.DestinationPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.EnumSet;
import java.util.List;

public class GenerateJsonCommand
implements SharedDocSubCommand {
    private final JsonType fJsonType;

    public GenerateJsonCommand(JsonType jsonType) {
        this.fJsonType = jsonType;
    }

    @Override
    public void handleProductsFound(DocFileSystem docFileSystem, DocSetItemList docSetItemList) throws IOException, InterruptedException {
        String string = this.getJsonArray(docSetItemList.getInstalledDocSetItems(EnumSet.of(DocSetItemType.PRODUCT)));
        this.writeJsonFile(docFileSystem, string);
    }

    @Override
    public void handleNoProducts(DocFileSystem docFileSystem) throws IOException, InterruptedException {
        this.writeJsonFile(docFileSystem, "[]");
    }

    private String getJsonArray(List<InstalledDocSetItem> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (InstalledDocSetItem installedDocSetItem : list) {
            if (!this.fJsonType.hasLandingPage(installedDocSetItem)) continue;
            String string = this.getJsonEntity(installedDocSetItem);
            stringBuilder.append(string).append(',');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.insert(0, "[");
            stringBuilder.setCharAt(stringBuilder.length() - 1, ']');
            return stringBuilder.toString();
        }
        return "[]";
    }

    private String getJsonEntity(InstalledDocSetItem installedDocSetItem) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = installedDocSetItem.getDisplayName();
        String string2 = installedDocSetItem.getShortName();
        String string3 = installedDocSetItem.getHelpLoc();
        String string4 = this.fJsonType.getLandingPageFilename();
        stringBuilder.append(String.format("{\"displayname\":\"%s\",", string));
        stringBuilder.append(String.format("\"helplocation\":\"%s/%s\",", string3, string4));
        stringBuilder.append(String.format("\"shortname\":\"%s\"}", string2));
        return stringBuilder.toString();
    }

    private void writeJsonFile(DocFileSystem docFileSystem, String string) throws InterruptedException, IOException {
        DestinationPath destinationPath = this.fJsonType.getDestinationPath();
        if (destinationPath != null) {
            docFileSystem.delete(destinationPath, false);
            try (OutputStream outputStream = docFileSystem.createOutputStream(destinationPath);){
                PrintStream printStream = new PrintStream(outputStream);
                printStream.print(string);
            }
            catch (IOException iOException) {
                docFileSystem.delete(destinationPath, false);
                throw iOException;
            }
        }
    }

    public static enum JsonType {
        DOC(ContentPath.DOC_LANDING_PAGE_FILENAME, DestinationPath.DOC_JSON),
        EXAMPLES(ContentPath.EXAMPLES_LANDING_PAGE_FILENAME, DestinationPath.EXAMPLES_JSON);

        private final String iLandingPageFilename;
        private final DestinationPath iDestinationPath;

        private JsonType(String string2, DestinationPath destinationPath) {
            this.iLandingPageFilename = string2;
            this.iDestinationPath = destinationPath;
        }

        private String getLandingPageFilename() {
            return this.iLandingPageFilename;
        }

        private boolean hasLandingPage(InstalledDocSetItem installedDocSetItem) {
            switch (this) {
                case DOC: {
                    return installedDocSetItem.hasDocLandingPage();
                }
                case EXAMPLES: {
                    return installedDocSetItem.hasExamplesLandingPage();
                }
            }
            return false;
        }

        private DestinationPath getDestinationPath() {
            return this.iDestinationPath;
        }
    }
}

