/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetDocumentBuilder;
import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetProperties;
import com.mathworks.install.command.doc.EmptyDocSetItemList;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.install.command.doc.io.DestinationPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import java.io.IOException;
import java.io.OutputStream;
import org.jdom.Document;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class GenerateDocSetCommand
implements SharedDocSubCommand {
    private final DocSetProperties docSetProperties;
    private final boolean writeEmptyFile;

    public GenerateDocSetCommand(DocSetProperties docSetProperties, boolean bl) {
        this.docSetProperties = docSetProperties;
        this.writeEmptyFile = bl;
    }

    @Override
    public void handleProductsFound(DocFileSystem docFileSystem, DocSetItemList docSetItemList) throws InterruptedException, IOException {
        this.buildDocSet(docFileSystem, docSetItemList);
    }

    @Override
    public void handleNoProducts(DocFileSystem docFileSystem) throws IOException, InterruptedException {
        if (this.writeEmptyFile) {
            this.buildDocSet(docFileSystem, new EmptyDocSetItemList());
        } else {
            docFileSystem.delete(DestinationPath.DOC_SET_XML, false);
        }
    }

    private void buildDocSet(DocFileSystem docFileSystem, DocSetItemList docSetItemList) throws InterruptedException, IOException {
        docFileSystem.delete(DestinationPath.DOC_SET_XML, false);
        DocSetDocumentBuilder docSetDocumentBuilder = new DocSetDocumentBuilder(docSetItemList, this.docSetProperties);
        Document document = docSetDocumentBuilder.getDocument();
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getPrettyFormat());
        try (OutputStream outputStream = docFileSystem.createOutputStream(DestinationPath.DOC_SET_XML);){
            xMLOutputter.output(document, outputStream);
        }
        catch (IOException iOException) {
            docFileSystem.delete(DestinationPath.DOC_SET_XML, false);
            throw iOException;
        }
    }
}

