/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;

public class DocSetProperties {
    private static final String DEFAULT_DOCSET_NAME = "doccenter";
    private final DocDestination fDestination;
    private final String fDocSetName;
    private final String fPathFromDocRoot;
    private final DocSetType fType;

    public DocSetProperties(DocDestination docDestination, String string, String string2, DocSetType docSetType) {
        this.fDestination = docDestination == null ? DocDestination.INSTALL : docDestination;
        this.fDocSetName = string == null ? DEFAULT_DOCSET_NAME : string;
        this.fPathFromDocRoot = string2 == null ? "" : string2;
        this.fType = docSetType;
    }

    public DocDestination getDestination() {
        return this.fDestination;
    }

    String getDocSetName() {
        return this.fDocSetName;
    }

    public String getPathFromDocRoot() {
        return this.fPathFromDocRoot;
    }

    boolean isStandaloneProduct() {
        return this.fType == DocSetType.STANDALONE_PRODUCT;
    }

    public boolean needsLandingPageBuilt() {
        return this.fType == DocSetType.DEFAULT;
    }

    public static DocSetProperties defaultProperties() {
        return DocSetProperties.defaultProperties(DocDestination.INSTALL);
    }

    public static DocSetProperties defaultProperties(DocDestination docDestination) {
        return new DocSetProperties(docDestination, DEFAULT_DOCSET_NAME, "", DocSetType.DEFAULT);
    }

    public int hashCode() {
        return this.getDocSetName().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof DocSetProperties) {
            DocSetProperties docSetProperties = (DocSetProperties)object;
            return docSetProperties.getDestination() == this.getDestination() && docSetProperties.getDocSetName().equals(this.getDocSetName()) && docSetProperties.getPathFromDocRoot().equals(this.getPathFromDocRoot()) && docSetProperties.fType == this.fType;
        }
        return false;
    }

    public static enum DocSetType {
        DEFAULT,
        STANDALONE_PRODUCT,
        NO_LANDING_PAGE;

    }
}

