/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetItemType;
import com.mathworks.install.command.doc.DocSetProperties;
import com.mathworks.install.command.doc.InstalledDocSetItem;
import com.mathworks.install.command.doc.ProductFamily;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;

public class DocSetDocumentBuilder {
    private final Document document;

    public DocSetDocumentBuilder(DocSetItemList docSetItemList, DocSetProperties docSetProperties) {
        this.document = DocSetDocumentBuilder.buildDocSetXmlDocument(docSetItemList, docSetProperties);
    }

    private static Document buildDocSetXmlDocument(DocSetItemList docSetItemList, DocSetProperties docSetProperties) {
        Element element = new Element("documentation-set");
        Element element2 = new Element("format");
        element2.setText("helpcenter");
        element.addContent((Content)element2);
        String string = docSetProperties.getPathFromDocRoot();
        if (string != null && !string.isEmpty()) {
            Element element3 = new Element("help-dir");
            element3.setText(string);
            element.addContent((Content)element3);
        }
        for (Element element4 : DocSetItemType.values()) {
            List<InstalledDocSetItem> list = docSetItemList.getInstalledDocSetItems(EnumSet.of(element4));
            if (element4 != DocSetItemType.PRODUCT && (list == null || list.isEmpty())) continue;
            String string2 = element4.name().toLowerCase(Locale.ENGLISH);
            Element element5 = new Element(string2 + "-list");
            for (InstalledDocSetItem installedDocSetItem : list) {
                Element element6 = DocSetDocumentBuilder.buildElement(installedDocSetItem, string2);
                element5.addContent((Content)element6);
            }
            element.addContent((Content)element5);
        }
        return new Document(element);
    }

    private static Element buildElement(InstalledDocSetItem installedDocSetItem, String string) {
        Element element;
        Object object;
        Object object2;
        Element element2;
        Element element3 = new Element(string);
        Element element4 = new Element("display-name");
        element4.setText(installedDocSetItem.getDisplayName());
        element3.addContent((Content)element4);
        Element element5 = new Element("help-location");
        element5.setText(installedDocSetItem.getHelpLoc());
        element3.addContent((Content)element5);
        Element element6 = new Element("short-name");
        element6.setText(installedDocSetItem.getShortName());
        element3.addContent((Content)element6);
        String string2 = installedDocSetItem.getBaseProductShortName();
        if (string2 != null && !string2.isEmpty()) {
            element2 = new Element("base-short-name");
            element2.setText(string2);
            element3.addContent((Content)element2);
        }
        if ((element2 = installedDocSetItem.getAltShortNames()) != null && !element2.isEmpty()) {
            object2 = element2.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                element = new Element("alt-short-name");
                element.setText((String)object);
                element3.addContent((Content)element);
            }
        }
        if (!(object2 = installedDocSetItem.getProductFamilies()).isEmpty()) {
            object = new Element("product-family-list");
            element = object2.iterator();
            while (element.hasNext()) {
                ProductFamily productFamily = (ProductFamily)element.next();
                Element element7 = DocSetDocumentBuilder.getProductFamilyElement(productFamily);
                object.addContent((Content)element7);
            }
            element3.addContent((Content)object);
        }
        return element3;
    }

    private static Element getProductFamilyElement(ProductFamily productFamily) {
        Element element = new Element("product-family");
        String string = productFamily.getFamily();
        Element element2 = new Element("family");
        element2.setText(string);
        element.addContent((Content)element2);
        String string2 = productFamily.getGroup();
        if (!string2.trim().isEmpty()) {
            Element element3 = new Element("group");
            element3.setText(string2);
            element.addContent((Content)element3);
        }
        return element;
    }

    public Document getDocument() {
        return this.document;
    }
}

