/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocLandingPageBuilder;
import com.mathworks.install.command.doc.DocSetDocumentBuilder;
import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetProperties;
import com.mathworks.install.command.doc.LocaleSuffix;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.install.command.doc.io.DestinationPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import java.io.IOException;
import java.util.ArrayList;
import org.jdom.Document;

public class DocLandingPageCommand
implements SharedDocSubCommand {
    private final DocSetProperties docSetProperties;

    public DocLandingPageCommand(DocSetProperties docSetProperties) {
        this.docSetProperties = docSetProperties;
    }

    @Override
    public void handleProductsFound(DocFileSystem docFileSystem, DocSetItemList docSetItemList) throws IOException, InterruptedException {
        DocLandingPageBuilder docLandingPageBuilder = this.getLandingPageBuilder(docFileSystem, docSetItemList);
        ArrayList<LocaleSuffix> arrayList = new ArrayList<LocaleSuffix>(docSetItemList.getLocaleSuffixes());
        for (LocaleSuffix localeSuffix : arrayList) {
            this.createPage(docFileSystem, docLandingPageBuilder, DestinationPath.LANDING_PAGE, localeSuffix);
            if (this.docSetProperties.getDestination() != DocDestination.WEB) continue;
            this.createPage(docFileSystem, docLandingPageBuilder, DestinationPath.FILE_NOT_FOUND, localeSuffix);
        }
    }

    @Override
    public void handleNoProducts(DocFileSystem docFileSystem) throws IOException, InterruptedException {
        docFileSystem.delete(DestinationPath.LANDING_PAGE, true);
        docFileSystem.delete(DestinationPath.FILE_NOT_FOUND, true);
    }

    private DocLandingPageBuilder getLandingPageBuilder(DocFileSystem docFileSystem, DocSetItemList docSetItemList) {
        DocDestination docDestination = this.docSetProperties.getDestination();
        DocSetDocumentBuilder docSetDocumentBuilder = new DocSetDocumentBuilder(docSetItemList, this.docSetProperties);
        Document document = docSetDocumentBuilder.getDocument();
        return new DocLandingPageBuilder(docFileSystem, docDestination, document);
    }

    private void createPage(DocFileSystem docFileSystem, DocLandingPageBuilder docLandingPageBuilder, DestinationPath destinationPath, LocaleSuffix localeSuffix) throws IOException, InterruptedException {
        byte[] byArray = docLandingPageBuilder.buildPage(destinationPath, localeSuffix);
        if (byArray.length > 0) {
            DestinationPath destinationPath2 = DocLandingPageCommand.getLocalizedPath(destinationPath, localeSuffix);
            docFileSystem.writeFile(byArray, destinationPath2);
        }
    }

    private static DestinationPath getLocalizedPath(DestinationPath destinationPath, LocaleSuffix localeSuffix) {
        return destinationPath.localize(localeSuffix);
    }
}

