/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.LocaleSuffix;
import com.mathworks.install.command.doc.ReleaseNameParser;
import com.mathworks.install.command.doc.io.ContentPath;
import com.mathworks.install.command.doc.io.DestinationPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.instutil.InstutilResourceKeys;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.transform.JDOMSource;

public class DocLandingPageBuilder {
    private final DocFileSystem fDocFileSystem;
    private final DocDestination fDestination;
    private final Document fDocSetDom;

    public DocLandingPageBuilder(DocFileSystem docFileSystem, DocDestination docDestination, Document document) {
        this.fDocFileSystem = docFileSystem;
        this.fDestination = docDestination;
        this.fDocSetDom = document;
    }

    public byte[] buildPage(DestinationPath destinationPath, LocaleSuffix localeSuffix) throws IOException {
        ContentPath contentPath = ContentPath.XSL_TEMPLATE;
        if (!this.fDocFileSystem.isFile(contentPath)) {
            return new byte[0];
        }
        try {
            return this.doXslTransform(destinationPath, localeSuffix);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException("Unable to create documentation-center.html page", exception);
        }
    }

    private byte[] doXslTransform(DestinationPath destinationPath, LocaleSuffix localeSuffix) throws IOException, TransformerException {
        Map<String, String> map = this.createXslParameters(destinationPath, localeSuffix);
        try (InputStream inputStream = this.fDocFileSystem.getInputStream(ContentPath.XSL_TEMPLATE);){
            byte[] byArray = this.doXslTransform(inputStream, this.fDocFileSystem.getXslTemplateUri().toString(), map);
            return byArray;
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    private byte[] doXslTransform(InputStream inputStream, String string, Map<String, String> map) throws IOException, TransformerException {
        StreamSource streamSource = new StreamSource(inputStream);
        streamSource.setSystemId(string);
        try {
            try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
                Object object2;
                Transformer transformer = TransformerFactory.newInstance().newTransformer(streamSource);
                for (Object object2 : map.entrySet()) {
                    transformer.setParameter(object2.getKey(), object2.getValue());
                }
                JDOMSource jDOMSource = new JDOMSource(this.fDocSetDom);
                object2 = new StreamResult(byteArrayOutputStream);
                object2.setSystemId(string);
                transformer.transform((Source)jDOMSource, (Result)object2);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            inputStream.close();
        }
    }

    private Map<String, String> createXslParameters(DestinationPath destinationPath, LocaleSuffix localeSuffix) throws IOException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        if (!localeSuffix.isDefault()) {
            linkedHashMap.put("locale", localeSuffix.toXslParameterValue());
        }
        linkedHashMap.put("destination", this.fDestination.toString().toLowerCase(Locale.ENGLISH));
        linkedHashMap.put("docRoot", this.fDocFileSystem.getContentDocRoot().toAbsolutePath().toString());
        String string = this.getDocRelease();
        linkedHashMap.put("releaseversion", string);
        ContentPath contentPath = ContentPath.RELEASE_INFO_FILE;
        if (this.fDocFileSystem.isFile(contentPath)) {
            String string2 = this.fDocFileSystem.readFile(contentPath);
            linkedHashMap.put("phaseoftherelease", string2);
        }
        if (destinationPath.equals(DestinationPath.FILE_NOT_FOUND)) {
            linkedHashMap.put("generate_index_not_found_page", "yes");
        }
        return linkedHashMap;
    }

    protected String getDocRelease() {
        String string = InstutilResourceKeys.RELEASE.getBundleString();
        ReleaseNameParser releaseNameParser = new ReleaseNameParser(string);
        return releaseNameParser.parseReleaseName();
    }
}

