/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocSetItemFilter;
import com.mathworks.install.command.doc.DocSetItemType;
import java.util.EnumSet;
import java.util.Properties;
import java.util.Set;

public class DestinationFilter
implements DocSetItemFilter {
    private final DocDestination fDocDestination;

    public DestinationFilter(DocDestination docDestination) {
        this.fDocDestination = docDestination;
    }

    @Override
    public boolean includeDocSetItem(DocSetItemType docSetItemType, Properties properties) {
        if (this.fDocDestination == DocDestination.INSTALL && docSetItemType == DocSetItemType.ADDON) {
            return false;
        }
        Set<DocDestination> set = DestinationFilter.resolveDestinations(properties);
        return set.contains((Object)this.fDocDestination);
    }

    private static Set<DocDestination> resolveDestinations(Properties properties) {
        String string = DestinationFilter.getStatusProperty(properties);
        if (string.isEmpty()) {
            return EnumSet.allOf(DocDestination.class);
        }
        if (string.equalsIgnoreCase("web_only")) {
            return EnumSet.of(DocDestination.WEB);
        }
        if (string.equalsIgnoreCase("install_only")) {
            return EnumSet.of(DocDestination.INSTALL);
        }
        return EnumSet.noneOf(DocDestination.class);
    }

    private static String getStatusProperty(Properties properties) {
        if (properties.containsKey("status")) {
            return properties.getProperty("status").trim();
        }
        return "";
    }
}

