/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.command.doc.DefaultDocSetItemFilter;
import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.DocLandingPageCommand;
import com.mathworks.install.command.doc.DocSetItemList;
import com.mathworks.install.command.doc.DocSetProperties;
import com.mathworks.install.command.doc.GenerateDocSetCommand;
import com.mathworks.install.command.doc.GenerateJsonCommand;
import com.mathworks.install.command.doc.InstallerDocSetItemList;
import com.mathworks.install.command.doc.MatlabSharedDocBuilder;
import com.mathworks.install.command.doc.ProductFamilyProperties;
import com.mathworks.install.command.doc.SearchIndexCommand;
import com.mathworks.install.command.doc.SharedDocSubCommand;
import com.mathworks.install.command.doc.StandaloneProductList;
import com.mathworks.install.command.doc.io.ContentPath;
import com.mathworks.install.command.doc.io.DocFileSystem;
import com.mathworks.instutil.JNIException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BuildSharedDocController {
    private final DocSetProperties fDocSetProperties;
    private final boolean fWriteEmptyFile;

    public BuildSharedDocController(DocSetProperties docSetProperties, boolean bl) {
        this.fDocSetProperties = docSetProperties;
        this.fWriteEmptyFile = bl;
    }

    public final void execute(DocFileSystem docFileSystem) throws IOException, InterruptedException {
        if (!docFileSystem.isDirectory(ContentPath.DOC_ROOT)) {
            return;
        }
        DocSetItemList docSetItemList = this.getDocSetItemList(docFileSystem, this.fDocSetProperties.isStandaloneProduct());
        docSetItemList.populate(this.fDocSetProperties.getDestination());
        if (this.fWriteEmptyFile || !docSetItemList.isEmpty()) {
            docFileSystem.createOutputDirectory();
        }
        List<SharedDocSubCommand> list = this.getSubCommands();
        if (docSetItemList.isEmpty()) {
            for (SharedDocSubCommand sharedDocSubCommand : list) {
                sharedDocSubCommand.handleNoProducts(docFileSystem);
            }
        } else {
            for (SharedDocSubCommand sharedDocSubCommand : list) {
                sharedDocSubCommand.handleProductsFound(docFileSystem, docSetItemList);
            }
        }
    }

    private List<SharedDocSubCommand> getSubCommands() {
        ArrayList<SharedDocSubCommand> arrayList = new ArrayList<SharedDocSubCommand>();
        arrayList.add(new SearchIndexCommand());
        if (this.fDocSetProperties.needsLandingPageBuilt()) {
            arrayList.add(new DocLandingPageCommand(this.fDocSetProperties));
            if (this.fDocSetProperties.getDestination() == DocDestination.WEB) {
                arrayList.add(new GenerateJsonCommand(GenerateJsonCommand.JsonType.DOC));
                arrayList.add(new GenerateJsonCommand(GenerateJsonCommand.JsonType.EXAMPLES));
            }
        }
        arrayList.add(new GenerateDocSetCommand(this.fDocSetProperties, this.fWriteEmptyFile));
        return Collections.unmodifiableList(arrayList);
    }

    private DocSetItemList getDocSetItemList(DocFileSystem docFileSystem, boolean bl) {
        if (bl) {
            return new StandaloneProductList(docFileSystem, this.fDocSetProperties.getDocSetName());
        }
        ProductFamilyProperties productFamilyProperties = new ProductFamilyProperties(docFileSystem);
        DefaultDocSetItemFilter defaultDocSetItemFilter = new DefaultDocSetItemFilter(this.fDocSetProperties);
        return new InstallerDocSetItemList(docFileSystem, productFamilyProperties, defaultDocSetItemFilter);
    }

    public static void main(String[] stringArray) throws IOException, JNIException, InterruptedException {
        String string = stringArray[0];
        String string2 = stringArray.length > 1 ? stringArray[1] : stringArray[0];
        String string3 = string + File.separatorChar + "help";
        BuildSharedDocController.buildSharedDocFiles(string2, string3, DocDestination.INSTALL);
    }

    static void buildSharedDocFiles(String string, String string2, DocDestination docDestination) throws IOException, InterruptedException, JNIException {
        MatlabSharedDocBuilder matlabSharedDocBuilder = new MatlabSharedDocBuilder(string, docDestination);
        matlabSharedDocBuilder.setContentRoot(string2);
        matlabSharedDocBuilder.buildSharedDocFiles();
        MatlabSharedDocBuilder matlabSharedDocBuilder2 = new MatlabSharedDocBuilder(string, docDestination);
        matlabSharedDocBuilder2.setType(DocSetProperties.DocSetType.NO_LANDING_PAGE);
        matlabSharedDocBuilder2.setContentRoot(string2);
        matlabSharedDocBuilder2.setOutputDir(string2 + File.separatorChar + "polyspace_shared");
        matlabSharedDocBuilder2.setDocSetName("polyspace");
        matlabSharedDocBuilder2.setWriteEmptyDocSetFile(false);
        matlabSharedDocBuilder2.buildSharedDocFiles();
    }

    @Deprecated
    public static DocDestination resolveDestination(String string) {
        return DocDestination.resolve(string);
    }
}

