/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command.doc;

import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.doc.BuildSharedDocController;
import com.mathworks.install.command.doc.DocDestination;
import com.mathworks.install.command.doc.InstallerDocSet;
import com.mathworks.install.command.doc.io.DocFileSystemBuilder;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.JNIException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class BuildSharedDocCommand
implements Command {
    private final Map<BuildSharedDocController, DocFileSystemBuilder> fControllers;

    public BuildSharedDocCommand(IO iO) {
        this(BuildSharedDocCommand.getDefaultControllerMap(iO));
    }

    private static Map<BuildSharedDocController, DocFileSystemBuilder> getDefaultControllerMap(IO iO) {
        HashMap<BuildSharedDocController, DocFileSystemBuilder> hashMap = new HashMap<BuildSharedDocController, DocFileSystemBuilder>();
        for (InstallerDocSet installerDocSet : InstallerDocSet.values()) {
            hashMap.put(installerDocSet.getController(), installerDocSet.getDocFileSystemBuilder(iO));
        }
        return hashMap;
    }

    public BuildSharedDocCommand(Map<BuildSharedDocController, DocFileSystemBuilder> map) {
        this.fControllers = new LinkedHashMap<BuildSharedDocController, DocFileSystemBuilder>(map);
    }

    @Override
    public void execute(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        Path path = file.toPath().resolve("help");
        for (Map.Entry<BuildSharedDocController, DocFileSystemBuilder> entry : this.fControllers.entrySet()) {
            DocFileSystemBuilder docFileSystemBuilder = entry.getValue();
            docFileSystemBuilder.contentDocRoot(path).destinationDocRoot(path);
            BuildSharedDocController buildSharedDocController = entry.getKey();
            buildSharedDocController.execute(docFileSystemBuilder.build());
        }
    }

    @Override
    public void undo(String string, File file, InstallFlowControlHandler installFlowControlHandler) throws IOException, InterruptedException {
        this.execute(string, file, installFlowControlHandler);
    }

    public static void main(String[] stringArray) throws IOException, JNIException, InterruptedException {
        BuildSharedDocController.main(stringArray);
    }

    @Deprecated
    public static DocDestination resolveDestination(String string) {
        return DocDestination.resolve(string);
    }

    public static void buildSharedDocFiles(String string, DocDestination docDestination) throws IOException, InterruptedException, JNIException {
        String string2 = string + File.separatorChar + "help";
        BuildSharedDocController.buildSharedDocFiles(string, string2, docDestination);
    }
}

