/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlabserver.connector.api;

import com.mathworks.matlabserver.connector.api.ConnectorLifecycleHelper;
import java.lang.reflect.Method;
import java.util.Date;

public abstract class Connector {
    private static ClassLoader classLoader = null;
    private static Connector impl = null;

    public static synchronized void init(Connector impl) {
        Connector.impl = impl;
    }

    private static Connector getImpl() {
        Connector.init();
        Class<Connector> clazz = Connector.class;
        synchronized (Connector.class) {
            if (impl != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return impl;
            }
            throw new IllegalStateException("Error initializing Connector implementation");
        }
    }

    public static int getPort() {
        Connector c = Connector.getImpl();
        if (c.doIsRunning()) {
            return c.doGetPort();
        }
        return 0;
    }

    public abstract int doGetPort();

    public static int getSecurePort() {
        Connector c = Connector.getImpl();
        if (c.doIsRunning()) {
            return c.doGetSecurePort();
        }
        return 0;
    }

    protected abstract int doGetSecurePort();

    public static boolean isRunning() {
        return Connector.getImpl().doIsRunning();
    }

    protected abstract boolean doIsRunning();

    public static String getCertificateLocation() {
        return Connector.getImpl().doGetCertificateLocation();
    }

    protected abstract String doGetCertificateLocation();

    public static String getUrl(String webPath) {
        return Connector.getImpl().doGetUrl(webPath);
    }

    protected abstract String doGetUrl(String var1);

    public static String getHttpUrl(String webPath) {
        return Connector.getImpl().doGetHttpUrl(webPath);
    }

    protected abstract String doGetHttpUrl(String var1);

    public static String getHttpsUrl(String webPath) {
        return Connector.getImpl().doGetHttpsUrl(webPath);
    }

    protected abstract String doGetHttpsUrl(String var1);

    protected static String getUrl(String webPath, Boolean forceHttp) {
        return Connector.getImpl().doGetUrl(webPath, forceHttp);
    }

    protected abstract String doGetUrl(String var1, boolean var2);

    public static String getVersion() {
        return Connector.getImpl().doGetVersion();
    }

    protected abstract String doGetVersion();

    public static void ensureServiceOn() throws Exception {
        Connector.getImpl().doEnsureServiceOn();
    }

    protected abstract void doEnsureServiceOn() throws Exception;

    public static boolean shutdown() throws Exception {
        return Connector.getImpl().doShutdown();
    }

    protected abstract boolean doShutdown() throws Exception;

    public static void addWebAddOnsPath(String webPath, String filePath) throws Exception {
        Connector.getImpl().doAddWebAddOnsPath(webPath, filePath);
    }

    protected abstract void doAddWebAddOnsPath(String var1, String var2) throws Exception;

    public static String addStaticContentOnPath(String route, String path) throws Exception {
        boolean shouldPersist = false;
        boolean localizeContent = false;
        return Connector.addStaticContentOnPath(route, path, shouldPersist, localizeContent);
    }

    public static String addStaticContentOnPath(String route, String path, boolean shouldPersist) throws Exception {
        boolean localizeContent = false;
        return Connector.addStaticContentOnPath(route, path, shouldPersist, localizeContent);
    }

    public static String addStaticContentOnPath(String route, String path, boolean shouldPersist, boolean localizeContent) throws Exception {
        return Connector.getImpl().doAddStaticContentOnPath(route, path, shouldPersist, localizeContent);
    }

    protected abstract String doAddStaticContentOnPath(String var1, String var2, boolean var3, boolean var4) throws Exception;

    public static String getStaticContentOnPath(String path) throws Exception {
        return Connector.getImpl().doGetStaticContentOnPath(path);
    }

    protected String doGetStaticContentOnPath(String path) throws Exception {
        throw new RuntimeException();
    }

    public static String removeStaticContentOnPath(String route) throws Exception {
        return Connector.getImpl().doRemoveStaticContentOnPath(route);
    }

    protected String doRemoveStaticContentOnPath(String route) throws Exception {
        throw new RuntimeException();
    }

    public static void setStartingSince(Date time) {
        Connector.getImpl().doSetStartingSince(time);
    }

    protected abstract void doSetStartingSince(Date var1);

    public static void setCachedState(boolean isRunning, int httpPort, int httpsPort) {
        Connector.getImpl().doSetCachedState(isRunning, httpPort, httpsPort);
    }

    protected abstract void doSetCachedState(boolean var1, int var2, int var3);

    public static ConnectorLifecycleHelper getLifecycleHelper() {
        return Connector.getImpl().doGetLifecycleHelper();
    }

    protected abstract ConnectorLifecycleHelper doGetLifecycleHelper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader init() {
        Class<Connector> clazz = Connector.class;
        synchronized (Connector.class) {
            if (classLoader != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return classLoader;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            try {
                Class<?> clazz2 = Connector.class.getClassLoader().loadClass("com.mathworks.connector.standalone_host.StandaloneHost");
                Method initMethod = clazz2.getMethod("init", new Class[0]);
                initMethod.invoke(null, new Object[0]);
                Class<Connector> clazz3 = Connector.class;
                synchronized (Connector.class) {
                    Method getLoader = clazz2.getMethod("getDynamicClassLoader", new Class[0]);
                    classLoader = (ClassLoader)getLoader.invoke(null, new Object[0]);
                    // ** MonitorExit[var2_4] (shouldn't be in output)
                    return classLoader;
                }
            }
            catch (Exception e) {
                System.out.println("Unable to initialize connector: " + e.getMessage());
                return null;
            }
        }
    }
}

