/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices;

import com.mathworks.internal.activationws.client.ArrayOfKeyPair;
import com.mathworks.internal.activationws.client.ArrayOfString;
import com.mathworks.internal.activationws.client.KeyPair;
import com.mathworks.internal.activationws.client.LockingType;
import com.mathworks.internal.activationws.client.LockingTypes;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import com.mathworks.mlwebservices.DerivedProperty;
import com.mathworks.mlwebservices.LicenseManagementType;
import com.mathworks.mlwebservices.LockingTypeConstants;
import java.util.ArrayList;
import java.util.Arrays;

public class InstallerEntitlement {
    private MWAEntitlement mwaEntitlement;
    private LockingType selectedLockingType;
    private static final String LOGIN_NAMED_USER_AVAILABLE = "LoginNamedUserAvailable";
    private static final String ACTIVATABLE = "Activatable";

    InstallerEntitlement(MWAEntitlement mWAEntitlement) {
        LockingType[] lockingTypeArray;
        this.mwaEntitlement = mWAEntitlement;
        LockingTypes lockingTypes = mWAEntitlement.getLockingTypes();
        this.selectedLockingType = lockingTypes != null && lockingTypes.getLockingType() != null ? ((lockingTypeArray = lockingTypes.getLockingType()).length != 1 ? this.createEmptyLockingTypeObject() : lockingTypeArray[0]) : this.createEmptyLockingTypeObject();
    }

    public LockingTypeConstants getSelectedLockingType() {
        if (this.isLockingType(LockingTypeConstants.COMPUTER_BASED)) {
            return LockingTypeConstants.COMPUTER_BASED;
        }
        if (this.isLockingType(LockingTypeConstants.USER_BASED)) {
            return LockingTypeConstants.USER_BASED;
        }
        return LockingTypeConstants.UNSPECIFIED;
    }

    public void setSelectedLockingType(LockingTypeConstants lockingTypeConstants) {
        LockingTypes lockingTypes = this.mwaEntitlement.getLockingTypes();
        for (LockingType lockingType : lockingTypes.getLockingType()) {
            if (!lockingType.getName().equals(lockingTypeConstants.getString())) continue;
            this.selectedLockingType = lockingType;
            return;
        }
    }

    public String getFIK() {
        return this.mwaEntitlement.getFIK();
    }

    public String getId() {
        return this.mwaEntitlement.getId();
    }

    public String getConfirmationPanelText() {
        return this.selectedLockingType.getDisplayLabel();
    }

    public String getActivationKey() {
        return this.mwaEntitlement.getActivationKey();
    }

    private ArrayOfString getPermissions() {
        return this.mwaEntitlement.getPermissions();
    }

    public ArrayOfKeyPair getDerivedProperties() {
        return this.mwaEntitlement.getDerivedProperties();
    }

    public String getLicenseNumber() {
        return this.mwaEntitlement.getLicenseNumber();
    }

    public String getLicenseNumberToDisplay() {
        if (this.isTSUREntitlement()) {
            return this.mwaEntitlement.getId();
        }
        return this.mwaEntitlement.getLicenseNumber();
    }

    public String getExpirationDate() {
        return this.mwaEntitlement.getExpirationDate();
    }

    public String getUserDefinedLabel() {
        return this.mwaEntitlement.getUserDefinedLabel();
    }

    public String getLicenseOption() {
        return this.mwaEntitlement.getLicenseOption();
    }

    public String getDisplayLabelForEntitlement() {
        return this.mwaEntitlement.getDisplayLabel();
    }

    public boolean isTSUREntitlement() {
        return "288".equalsIgnoreCase(this.mwaEntitlement.getEntitlementTypeId());
    }

    public boolean isNamedUserLicense() {
        return this.isLockingType(LockingTypeConstants.USER_BASED);
    }

    public boolean isComputerBasedLicense() {
        return this.isLockingType(LockingTypeConstants.COMPUTER_BASED);
    }

    public boolean isFileBasedLicensing() {
        return this.containsPermissionInLockingType(LicenseManagementType.FILE_BASED.getString());
    }

    public boolean isLNUOnly() {
        return this.containsPermission(LOGIN_NAMED_USER_AVAILABLE) && !this.containsPermission(ACTIVATABLE);
    }

    public boolean isOnlineActivatableLicense() {
        return this.containsPermissionInLockingType(LicenseManagementType.ONLINE_BASED.getString()) && this.containsPermissionInLockingType(LicenseManagementType.FILE_BASED.getString());
    }

    public boolean isOnlineOnly() {
        return this.containsPermissionInLockingType(LicenseManagementType.ONLINE_BASED.getString()) && !this.containsPermissionInLockingType(LicenseManagementType.FILE_BASED.getString());
    }

    public boolean isUNSETEntitlement() {
        return this.selectedLockingType.getName().equals(LockingTypeConstants.UNSPECIFIED.getString());
    }

    public void setActivationKey(String string) {
        this.mwaEntitlement.setActivationKey(string);
    }

    public void setId(String string) {
        this.mwaEntitlement.setId(string);
    }

    public void setLicenseNumber(String string) {
        this.mwaEntitlement.setLicenseNumber(string);
    }

    public void setUserDefinedLabel(String string) {
        this.mwaEntitlement.setUserDefinedLabel(string);
    }

    public void setLicenseOption(String string) {
        this.mwaEntitlement.setLicenseOption(string);
    }

    public boolean checkIfUsernameRequired() {
        return this.containsPermissionInLockingType("username");
    }

    public boolean isAdmin() {
        return this.containsPermission("ActivateForOthers");
    }

    public boolean isA2AK() {
        return this.containsPermission("ActivationKeyAvailable");
    }

    public boolean isGuiltScreenRequired() {
        return this.containsPermission("DisplayStudentReminder");
    }

    public boolean isNetworkPropertyPresent() {
        return this.containsDerivedPermission(DerivedProperty.IS_NETWORK.getKey());
    }

    private boolean isLockingType(LockingTypeConstants lockingTypeConstants) {
        return this.selectedLockingType.getName().equals(lockingTypeConstants.getString());
    }

    private LockingType createEmptyLockingTypeObject() {
        LockingType lockingType = new LockingType();
        lockingType.setName(LockingTypeConstants.UNSPECIFIED.getString());
        lockingType.setProperties(new ArrayOfString());
        return lockingType;
    }

    private boolean containsDerivedPermission(String string) {
        KeyPair[] keyPairArray;
        boolean bl = false;
        ArrayOfKeyPair arrayOfKeyPair = this.getDerivedProperties();
        if (arrayOfKeyPair != null && (keyPairArray = arrayOfKeyPair.getItem()) != null) {
            for (KeyPair keyPair : keyPairArray) {
                if (!keyPair.getKey().equalsIgnoreCase(string) || !Boolean.valueOf(keyPair.getValue()).booleanValue()) continue;
                bl = true;
            }
        }
        return bl;
    }

    private boolean containsPermission(String string) {
        String[] stringArray;
        boolean bl = false;
        ArrayOfString arrayOfString = this.getPermissions();
        if (arrayOfString != null && (stringArray = arrayOfString.getItem()) != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.addAll(Arrays.asList(stringArray));
            if (arrayList.contains(string)) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean containsPermissionInLockingType(String string) {
        LockingTypes lockingTypes = this.mwaEntitlement.getLockingTypes();
        if (lockingTypes != null && lockingTypes.getLockingType() != null) {
            for (LockingType lockingType : lockingTypes.getLockingType()) {
                if (!lockingType.getName().equals(this.selectedLockingType.getName())) continue;
                ArrayOfString arrayOfString = lockingType.getProperties();
                String[] stringArray = arrayOfString.getItem();
                if (arrayOfString == null || stringArray == null) continue;
                for (String string2 : stringArray) {
                    if (!string2.equals(string)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

