/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwebservices;

import com.mathworks.internal.activationws.client.ArrayOfString;
import com.mathworks.internal.activationws.client.MWAEntitlement;
import java.util.ArrayList;
import java.util.Arrays;

public final class EntitlementUtility {
    private static final String LOGIN_NAMED_USER_AVAILABLE = "LoginNamedUserAvailable";
    private static final String ACTIVATABLE = "Activatable";
    private static final String JIT_ADMIN = "JitAdmin";
    private static final String JIT_LEU = "JitLeu";

    private EntitlementUtility() {
    }

    public static boolean isDownloadOnlyPermissionAvailable(MWAEntitlement[] mWAEntitlementArray) {
        return EntitlementUtility.containsPermissionsInMWAEntitlements(mWAEntitlementArray, "DownloadOnlyAvailable");
    }

    private static boolean containsPermissionsInMWAEntitlements(MWAEntitlement[] mWAEntitlementArray, String string) {
        if (mWAEntitlementArray == null) {
            return false;
        }
        boolean bl = false;
        for (MWAEntitlement mWAEntitlement : mWAEntitlementArray) {
            ArrayOfString arrayOfString = mWAEntitlement.getPermissions();
            if (arrayOfString == null) continue;
            String[] stringArray = arrayOfString.getItem();
            if (stringArray != null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray));
                if (!arrayList.contains(string)) continue;
                bl = true;
                break;
            }
            bl = false;
        }
        return bl;
    }

    public static boolean isLNUOnly(MWAEntitlement[] mWAEntitlementArray) {
        return EntitlementUtility.containsPermissionsInMWAEntitlements(mWAEntitlementArray, LOGIN_NAMED_USER_AVAILABLE) && !EntitlementUtility.containsPermissionsInMWAEntitlements(mWAEntitlementArray, ACTIVATABLE);
    }

    public static boolean isJITEntitlement(MWAEntitlement mWAEntitlement) {
        return mWAEntitlement.getJitEnabled();
    }

    public static boolean isJITAdmin(MWAEntitlement mWAEntitlement) {
        return EntitlementUtility.containsPermissionsInMWAEntitlements(new MWAEntitlement[]{mWAEntitlement}, JIT_ADMIN);
    }

    public static boolean isJITLeu(MWAEntitlement mWAEntitlement) {
        return EntitlementUtility.containsPermissionsInMWAEntitlements(new MWAEntitlement[]{mWAEntitlement}, JIT_LEU);
    }
}

