/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.udc.client.installer;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class DateFormatter {
    private static final ThreadLocal<SimpleDateFormat> GMT_OFFSET_FORMATTER;
    private static final ThreadLocal<SimpleDateFormat> UTC_FORMATTER;
    private static final String[][] UNSUPPORTED_TIMEZONES;
    private static final List<ParseStrategy> PARSE_STRATEGIES;

    public static String printDate(Date date) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return DatatypeConverter.printDateTime((Calendar)cal);
    }

    public static Date parseDate(String value) {
        Date date = null;
        for (ParseStrategy strategy : PARSE_STRATEGIES) {
            try {
                date = strategy.tryParse(value);
                if (date == null) continue;
                break;
            }
            catch (Exception e) {
            }
        }
        return date;
    }

    static {
        UTC_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy");
            }
        };
        GMT_OFFSET_FORMATTER = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return new SimpleDateFormat("EEE MMM dd HH:mm:ss 'GMT'XXX yyyy");
            }
        };
        UNSUPPORTED_TIMEZONES = new String[][]{{" ACT ", " GMT-05:00 "}, {" WIB ", " GMT+07:00 "}, {" WITA ", " GMT+08:00 "}, {" PETT ", " GMT+12:00 "}};
        PARSE_STRATEGIES = Arrays.asList(new WellFormattedXMLStrategy(), new SimpleDateFormatStrategy(GMT_OFFSET_FORMATTER), new SimpleDateFormatStrategy(UTC_FORMATTER), new UnsupportedTimezoneStrategy(), new UnknownTimezoneAsUTCStrategy());
    }

    private static class UnknownTimezoneAsUTCStrategy
    implements ParseStrategy {
        private UnknownTimezoneAsUTCStrategy() {
        }

        @Override
        public Date tryParse(String value) throws Exception {
            String[] parts = value.split(" ");
            parts[4] = "+0000";
            StringBuilder buf = new StringBuilder();
            for (String part : parts) {
                buf.append(part).append(" ");
            }
            return ((SimpleDateFormat)UTC_FORMATTER.get()).parse(buf.toString().trim());
        }
    }

    private static class SimpleDateFormatStrategy
    implements ParseStrategy {
        private final ThreadLocal<SimpleDateFormat> formatter;

        SimpleDateFormatStrategy(ThreadLocal<SimpleDateFormat> formatter) {
            this.formatter = formatter;
        }

        @Override
        public Date tryParse(String value) throws Exception {
            return this.formatter.get().parse(value);
        }
    }

    private static class UnsupportedTimezoneStrategy
    implements ParseStrategy {
        private UnsupportedTimezoneStrategy() {
        }

        @Override
        public Date tryParse(String value) throws Exception {
            for (String[] entry : UNSUPPORTED_TIMEZONES) {
                String tzName = entry[0];
                String gmtOffset = entry[1];
                if (!value.contains(tzName)) continue;
                value = value.replaceFirst(tzName, gmtOffset);
                return ((SimpleDateFormat)GMT_OFFSET_FORMATTER.get()).parse(value);
            }
            return null;
        }
    }

    private static class WellFormattedXMLStrategy
    implements ParseStrategy {
        private WellFormattedXMLStrategy() {
        }

        @Override
        public Date tryParse(String value) throws Exception {
            return DatatypeConverter.parseDateTime((String)value).getTime();
        }
    }

    private static interface ParseStrategy {
        public Date tryParse(String var1) throws Exception;
    }
}

