/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.dws.client.rest;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksServiceResponse;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.http.EntityEnclosingRequest;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.RequestContent;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.raw.RawByteResponseHandler;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import com.mathworks.webservices.dws.client.rest.DWSRestClient;
import com.mathworks.webservices.dws.client.rest.model.ComponentDataRequest;
import com.mathworks.webservices.dws.client.rest.model.ComponentDataResponse;
import com.mathworks.webservices.dws.client.rest.model.InstallerDataRequest;
import com.mathworks.webservices.dws.client.rest.model.InstallerDataResponse;
import com.mathworks.webservices.dws.client.rest.model.LanguageCodesForProfileResponse;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDataRequest;
import com.mathworks.webservices.dws.client.rest.model.ReleaseDataResponse;
import com.mathworks.webservices.dws.client.rest.model.UpdateReleaseDataResponse;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;

public class DWSRestClientImpl
extends MathWorksWebServiceClient
implements DWSRestClient {
    private Marshaller marshaller = null;
    private JAXBContext jaxbContext = null;
    private String full_endpoint = null;

    private String getEndpoint() {
        if (this.endpoint == null) {
            throw new RuntimeException("Endpoint can not be null");
        }
        if (this.full_endpoint == null) {
            this.full_endpoint = this.endpoint + "/service/v5/dws";
        }
        return this.full_endpoint;
    }

    public DWSRestClientImpl(ClientConfiguration config) {
        super(config, (ResponseHandler)new JaxbResponseHandler("com.mathworks.webservices.dws.client.rest.model"));
    }

    private void initializeMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ReleaseDataRequest.class, InstallerDataRequest.class, ComponentDataRequest.class});
            this.marshaller = this.jaxbContext.createMarshaller();
        }
    }

    public MathWorksServiceResponse ping(String locale, String clientString) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest request = new HttpRequest(HttpMethodName.GET, this.getEndpoint(), "/ping");
        request.setLocale(locale);
        request.setClientString(clientString);
        return this.executeRequest(request, (ResponseHandler)new RawByteResponseHandler());
    }

    public ReleaseDataResponse getReleaseData(String locale, String clientString, String token, ReleaseDataRequest releaseDataRequest) throws MathWorksServiceException, MathWorksClientException {
        try {
            this.initializeMarshaller();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.marshaller.marshal((Object)releaseDataRequest, (OutputStream)byteArrayOutputStream);
            return (ReleaseDataResponse)this.executeRequest((HttpRequest)this.createPostRequest("/releasedata", byteArrayOutputStream, token, locale, clientString));
        }
        catch (JAXBException exception) {
            throw new MathWorksClientException(exception.getMessage());
        }
    }

    public InstallerDataResponse getInstallers(String locale, String clientString, String token, InstallerDataRequest installerDataRequest) throws MathWorksServiceException, MathWorksClientException {
        try {
            this.initializeMarshaller();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.marshaller.marshal((Object)installerDataRequest, (OutputStream)byteArrayOutputStream);
            return (InstallerDataResponse)this.executeRequest((HttpRequest)this.createPostRequest("/installers", byteArrayOutputStream, token, locale, clientString));
        }
        catch (JAXBException exception) {
            throw new MathWorksClientException(exception.getMessage());
        }
    }

    public ComponentDataResponse getComponents(String locale, String clientString, String token, ComponentDataRequest componentDataRequest) throws MathWorksServiceException, MathWorksClientException {
        try {
            this.initializeMarshaller();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.marshaller.marshal((Object)componentDataRequest, (OutputStream)byteArrayOutputStream);
            return (ComponentDataResponse)this.executeRequest((HttpRequest)this.createPostRequest("/components", byteArrayOutputStream, token, locale, clientString));
        }
        catch (JAXBException exception) {
            throw new MathWorksClientException(exception.getMessage());
        }
    }

    public UpdateReleaseDataResponse getAvailableUpdates(String locale, String clientString, String release) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest request = this.createGetRequest("/updates", locale, clientString);
        request.addParameter("release", release);
        return (UpdateReleaseDataResponse)this.executeRequest(request);
    }

    public UpdateReleaseDataResponse getAvailableUpdatesForEntitlementID(String locale, String clientString, String release, String entitlementID) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest request = this.createGetRequest("/updates/release", locale, clientString);
        request.addParameter("release", release);
        request.addParameter("entitlementID", entitlementID);
        return (UpdateReleaseDataResponse)this.executeRequest(request);
    }

    public LanguageCodesForProfileResponse getLanguageCodesForProfile(String locale, String clientString, String token) throws MathWorksServiceException, MathWorksClientException {
        HttpRequest request = this.createGetRequest("/languagecodes", locale, clientString);
        request.addHeader("x-mw-authentication", token);
        return (LanguageCodesForProfileResponse)this.executeRequest(request);
    }

    private HttpRequest createGetRequest(String url, String locale, String clientString) {
        HttpRequest request = new HttpRequest(HttpMethodName.GET, this.getEndpoint(), url);
        request.addHeader("Accept-Language", locale);
        request.addHeader("x-mw-clientstring", clientString);
        request.setLocale(locale);
        request.setClientString(clientString);
        return request;
    }

    private EntityEnclosingRequest createPostRequest(String url, ByteArrayOutputStream byteArrayOutputStream, String token, String locale, String clientString) {
        EntityEnclosingRequest request = new EntityEnclosingRequest(HttpMethodName.POST, this.getEndpoint(), url);
        RequestContent requestContent = new RequestContent(byteArrayOutputStream.toByteArray(), "application/xml");
        request.setRequestContent(requestContent);
        request.addHeader("x-mw-authentication", token);
        request.addHeader("Accept-Language", locale);
        request.addHeader("x-mw-clientstring", clientString);
        request.setLocale(locale);
        request.setClientString(clientString);
        return request;
    }
}

