"""
Modulo creato da Andrea Bertolini. Settembre 2022.
"""


# QUESTO MODULO CONTIENE L'ALGORITMO E IL
# CODICE ASSOCIATO PER MAPF SU UNA GRIGLIA CON STRUTTURA DI FLUSSO
# PRECEDENTEMENTE FORNITA, CON AGENTI
# CHE IN MANIERA ONLINE VANNO DA ORIGINE A DESTINAZIONE,
# UN ESEMPIO DI RUN E' IL SEGUENTE:
# import PROVA_FILE_GRID_GEN_ONLINE_NOCONFLICT_PERM_TRAFFIC_COUPLEDROWS
# obj = PROVA_FILE_GRID_GEN_ONLINE_NOCONFLICT_PERM_TRAFFIC_COUPLEDROWS.MAPF_FILE(grid_file= 'Boston_0_256.map', scenarios_file= 'Boston_0_256-random-1.scen', num_agents_starting= 10, max_new_agents= 0)
# obj.solve_MAPF(0)  # ATTENZIONE CHE METTERE 1 COMPORTEREBBE UN RALLENTAMENTO ECCESSIVO
# C'E' DISAPPEAR AT TARGET


# ATTENZIONE: PER APPROCCIO ONLINE CI SONO ALCUNE PARTI DI CODICE DA ESCLUDERE/COMMENTARE


# IN QUESTO MODULO IMPONIAMO UNA STRUTTURA DI TIPO FLUSSO
# NELLA RETE, OVVERO FACCIAMO SI' CHE LE TILES PERMETTANO IL MOTO LUNGO
# VERSI RISTRETTI. PIU' DI PRECISO, SUPPONIAMO CHE LUNGO "L'ASSE DELLE
# ASCISSE" SI ALTERNINO DIREZIONI DA SINISTRA A DESTRA E DA DESTRA A SINISTRA.
# (lo imponiamo SIA nella costruzione della griglia quando leggiamo dal
# file, SIA nel metodo di estrazione dei vicini di un nodo)
# QUESTO PERMETTE DI RIDURRE LA POSSIBILITA' DI CONFLITTI.
# DAL MOMENTO CHE QUESTA IMPOSIZIONE POTREBBE COMPORTARE PROBLEMI IN
# ZONE RISTRETTE DELLA RETE, IMPONIAMO CHE TUTTO INTORNO AD OSTACOLI FISSI NON CI
# SIANO VINCOLI DI DIREZIONI E VERSI.
# CIO' NON ESCLUDE COMPLETAMENTE LA POSSIBILITA' DI CONFLITTI TRA AGENTI, DI
# CONSEGUENZA E' NECESSARIO GESTIRE OPPORTUNAMENTE QUESTE SITUAZIONI E NEL SEGUENTE
# CODICE LO FACCIAMO.
# C'E' DISAPPEAR AT TARGET

# import modules
import matplotlib.pyplot as plt
import numpy as np
import random
import heapq
import time
import pandas as pd
from matplotlib import colors
from random import shuffle

random.seed(10)

import PROVA_FILE_GRID_GEN_ONLINE_NOCONFLICT_PERM_TRAFFIC_COUPLEDROWS

EMPTY_CELL = 0
OBSTACLE_CELL = 1
START_CELL = 2  # la facciamo rossa
GOAL_CELL = 3  # la facciamo verde
AROUND_OBSTACLE_CELL = 4
CELL_TO_LEFT = 5
CELL_TO_RIGHT = 6
MOVE_CELL = 7

# grid_file = 'Boston_0_256.map'
# scenarios_file = 'Boston_0_256-even-1.scen'
# scenarios_file = 'Boston_0_256-random-1.scen'
# grid_file = 'den312d.map'
# scenarios_file = 'den312d-even-1.scen'
# scenarios_file = 'den312d-random-1.scen'



# create discrete colormap
cmap = colors.ListedColormap(['white', 'black', 'red', 'green', 'yellow', 'magenta', 'cyan', 'blue'])
bounds = [EMPTY_CELL, OBSTACLE_CELL, START_CELL, GOAL_CELL, AROUND_OBSTACLE_CELL, CELL_TO_LEFT, CELL_TO_RIGHT, MOVE_CELL, MOVE_CELL + 1]
# bounds defines the edges of bins, and data falling within a bin is mapped to the color with the same index
# quindi dovrebbe essere giusto che bounds ha un elemento in più rispetto a cmap
norm = colors.BoundaryNorm(bounds, cmap.N)



def repeat_alg_offline(griglia, scenari, maxim):
    object = []

    considered_file = []
    number_of_agents = []
    avoided_conflicts = []
    search_method_calls = []
    somma_tot_timesteps = []
    sum_of_costs = []
    makespan_for_cost = []
    makespan_for_timestep = []
    total_cpu_time = []
    perc_agent_at_solution_before_5 = []
    perc_agent_at_solution_before_10 = []

    for i in range(0, maxim+1):
        object.append(PROVA_FILE_GRID_GEN_ONLINE_NOCONFLICT_PERM_TRAFFIC_COUPLEDROWS.MAPF_FILE(grid_file= griglia,
                                                                         scenarios_file= scenari,
                                                                         num_agents_starting= i, max_new_agents= 0))
        object[i].solve_MAPF(0)
        #print("Num agenti: ", i, " timesteps totali (sum timesteps) per soluzione: ", object[i].somma_totale_timesteps_tutti)
        #print("Num agenti: ", i, " tempo per soluzione: ", object[i].tempo_totale)
        considered_file.append(griglia)
        number_of_agents.append(i)
        avoided_conflicts.append(object[i].tot_possible_conflicts)
        search_method_calls.append(object[i].tot_search_method_calls)
        somma_tot_timesteps.append(object[i].somma_totale_timesteps_tutti)
        sum_of_costs.append(object[i].somma_totale_costi_tutti)
        makespan_for_cost.append(object[i].makespan_costo)
        makespan_for_timestep.append(object[i].makespan_timesteps)
        total_cpu_time.append(object[i].tempo_totale)
        if i == 0:
            perc_agent_at_solution_before_5.append(0)
            perc_agent_at_solution_before_10.append(0)
        else:  # almeno un agente (cosicchè non dividiamo per 0 sotto)
            perc_agent_at_solution_before_5.append(object[i].numero_totale_agenti_arrivati_5SECS_OFFLINE / i * 100)
            perc_agent_at_solution_before_10.append(object[i].numero_totale_agenti_arrivati_10SECS_OFFLINE / i * 100)


    df_summary = pd.DataFrame(list(zip(considered_file, number_of_agents,
                                       avoided_conflicts, search_method_calls,
                                       somma_tot_timesteps, sum_of_costs,
                                       makespan_for_timestep, makespan_for_cost,
                                       total_cpu_time,
                                       perc_agent_at_solution_before_5,
                                       perc_agent_at_solution_before_10)),
                              columns = ['Considered Grid', 'Num Agents', 'Avoided Conflicts',
                                         'Search Methods Calls', 'Sum Of Timesteps',
                                         'Sum Of Costs', 'Makespan Timesteps',
                                         'Makespan Costs', 'Total CPU Time',
                                         'Percentage_arrived_before_5secs', 'Percentage_arrived_before_10secs'])
    df_summary.to_csv('file_2_800_traffic_perc_seed_10_COUPLEDROWS.csv')
    return df_summary






# manhattan distance
def heuristic(a, b):
    (x1, y1) = a  # GridLocation
    (x2, y2) = b  # GridLocation
    return abs(x1 - x2) + abs(y1 - y2)


def a_star_search(graph, start, goal):
    """
    Funzione che implementa la ricerca A* per lo shortest path
    :param graph: oggetto su cui si effettua la ricerca
    :param start: posizione di partenza
    :param goal: posizione di arrivo
    :return: si ritornano dei dizionari che sono
            came_from (descrive in sostanza il
             percorso all'indietro) e cost_so_far (dice il
             costo dello shortest path dalla partenza fino
             ad un nodo specifico)
    """

    frontier = PriorityQueue()  # gli items in questa priority queue sono liste
    frontier.put(start, 0)
    # all'inizio la frontiera è fatta dal solo punto
    # di partenza (che è una lista)
    came_from = {}  # LE CHIAVI DEVONO ESSERE TUPLE E I VALORI ANCHE
    # con il comando sopra vogliamo tenere conto delle
    # posizioni precedenti a quelle raggiunte (che sono le
    # chiavi del dizionario).
    cost_so_far = {}
    # THE ABOVE VARIABLE IS USED TO TAKE THE MOVEMENT
    # COSTS INTO ACCOUNT WHEN DECIDING HOW TO EVALUATE
    # LOCATIONS
    # inizializzazione
    came_from[tuple(start)] = None
    cost_so_far[tuple(start)] = 0  # in quanto dizionario, cost_so_far deve
    # avere almeno delle tuple come chiavi

    while not frontier.empty():
        # prendiamo una cella e la rimuoviamo dalla frontiera
        current = frontier.get()  # current dovrebbe essere una lista

        if current == goal:
            break  # ci fermiamo se siamo arrivati alla fine

        for next in graph.neighbors(current):  # next dovrebbe essere una lista
            # CALCOLIAMO IL NUOVO COSTO
            new_cost = cost_so_far[tuple(current)] + 1  # in implementazione alternativa
            # potremmo voler mettere pesi
            # diversi
            if tuple(next) not in cost_so_far or new_cost < cost_so_far[tuple(next)]:
                # mentre con new cost abbiamo solo calcolato qual è
                # il costo nuovo movendosi in un vicino, ora decidiamo
                # se metterlo in cost so far e sostanzialmente lo mettiamo
                # se non abbiamo ancora una chiave next, oppure se
                # questo nuovo costo è migliore per il nodo next
                cost_so_far[tuple(next)] = new_cost
                priority = new_cost + heuristic(next, goal)
                # qui entra in gioco l'euristica e si ha la vera
                # differenza fondamentale con lo algoritmo di
                # DIJKSTRA, infatti in DIJKSTRA la frontiera si
                # espande in tutte le direzioni. Questa è una scelta
                # ragionevole se stiamo cercando di trovare un cammino
                # verso tutte le altre o quasi tutte le posizioni.
                # Tuttavia, generalmente vogliamo trovare un cammino
                # verso una sola locazione. Quindi in sostanza vogliamo
                # far espandere la frontiera verso il goal più che verso
                # le altre direzioni. Per farlo ci serviamo del concetto
                # di funzione euristica, che ci dice quanto siamo vicini
                # al goal.
                frontier.put(next, priority)
                # ricorda che una priority queue associa ad ogni
                # item un numero chiamato priority. Quando deve
                # essere ritornato un item, prende quello
                # con priority minore
                came_from[tuple(next)] = tuple(current)  # perchè, in base alla
                # condizione nell'if, se non avevamo ancora
                # visitato quel nodo (next) allora dobbiamo
                # specificare da dove arriva, mentre se
                # lo avevamo visitato e abbiamo trovato un cammino
                # dalla partenza fino a lui che costa meno di quello
                # che avevamo, modifichiamo il suo came_from.

    return came_from, cost_so_far


class PriorityQueue:
    """
    CLASS FOR PRIORITY QUEUE. A PRIORITY QUEUE ASSOCIATES WITH EACH
    ITEM A NUMBER CALLED A PRIORITY. WHEN RETURNING AN ITEM, IT PICKS
    THE ONE WITH LOWEST NUMBER.
    """

    def __init__(self):
        """
        Method for Initialization
        """
        self.elements = []  # List[Tuple]
        # THE ELEMENTS OF THIS PRIORITY QUEUE ARE STORED
        # INSIDE A LIST WHERE EACH ITEM IS A TUPLE CORRESPONDING
        # TO A NODE

    def empty(self):
        """
        Method for the class PriorityQueue telling whether the
        priority queue is empty or not
        :return: boolean value 1 if the priority queue is empty
                boolean value 0 if the priority queue is not empty
        """
        return not self.elements

    def put(self, item, priority):
        """
        Method for the class PriorityQueue used to insert
        a new element in the priority queue
        :param item: item to be added in the priority queue
        :param priority: priority value (type float) of the item to be inserted
        """
        # FOR THIS PURPOSE, THE PACKAGE HEAPQ IS USED
        heapq.heappush(self.elements, (priority, item))

    def get(self):
        """
        Method for the class PriorityQueue used to extract the
        item with lowest priority
        :return: item with lowest priority
        """
        return heapq.heappop(self.elements)[1]


# attenzione 65x81 vuol dire 65 colonne e 81 righe
class MAPF_FILE:
    """
    CLASS FOR MAPF STARTING FROM GRID AND SCENARIOS FILES.
    """

    def __init__(self, grid_file, scenarios_file, num_agents_starting, max_new_agents):
        """
        Method for Initialization
        :param grid_file: file contenente la struttura della griglia
        :param scenarios_file: file contenente le posizione di partenza ed arrivo degli
                                agenti da inserire nella griglia
        """
        # ATTRIBUTO grid_file (Attributo di Istanza)
        self.grid_file = grid_file

        # ATTRIBUTO scenarios_file (Attributo di Istanza)
        self.scenarios_file = scenarios_file

        # ATTRIBUTO griglia (Attributo di Istanza)
        self.griglia = Grid(self.grid_file)

        # ATTRIBUTO altezza_griglia (Attributo di Istanza)
        self.altezza_griglia = self.griglia.righe_totali  # numero righe

        # ATTRIBUTO larghezza_griglia (Attributo di Istanza)
        self.larghezza_griglia = self.griglia.colonne_totali  # numero colonne

        # ATTRIBUTO dizionario_agenti (Attributo di Istanza)
        self.dizionario_agenti = {}  # la chiave sarà l'ID dell'agente, mentre
        # il valore sarà l'oggetto agente

        # ATTRIBUTO list_agents_start (Attributo di Istanza)
        self.list_agents_start = []

        # Attributo list_agents_goal (Attributo di Istanza)
        self.list_agents_goal = []

        # Attributo numero_agenti_considerati (Attributo di Istanza)
        self.num_agents_starting = num_agents_starting

        # ATTRIBUTO max_new_agents (Attributo di Istanza)
        self.max_new_agents = max_new_agents

        # ATTRIBUTO n_TOTAL_agents (Attributo di Istanza)
        self.n_TOTAL_agents = 0

        # ATTRIBUTO list_agents_position (Attributo di Istanza)
        self.dict_agents_position = {}  # la chiave sarà l'ID dell'agente, mentre
        # il valore sarà la posizione attuale

        # ATTRIBUTO tot_conflicts (Attributo di Istanza)
        self.tot_possible_conflicts = 0  # utile per fare il confronto

        # ATTRIBUTO tot_search_method_calls (Attributo di Istanza)
        self.tot_search_method_calls = 0

        # ATTRIBUTO somma_totale_timesteps_tutti (Attributo di Istanza)
        self.somma_totale_timesteps_tutti = 0

        # ATTRIBUTO somma_totale_costi_tutti (Attributo di Istanza)
        self.somma_totale_costi_tutti = 0

        # ATTRIBUTO tempo_totale (Attributo di Istanza)
        self.tempo_totale = 0

        # ATTRIBUTO makespan_costo (Attributo di Istanza)
        self.makespan_costo = 0  # costo massimo richiesto da un agente per arrivare
        # a destinazione

        # ATTRIBUTO makespan_timesteps (Attributo di Istanza)
        self.makespan_timesteps = 0  # massimo numero di timesteps richiesti dal sistema
        # per concludere

        # ATTRIBUTO numero_totale_agenti_arrivati_5SECS_OFFLINE (Attributo di Istanza)
        self.numero_totale_agenti_arrivati_5SECS_OFFLINE = 0

        # ATTRIBUTO numero_totale_agenti_arrivati_10SECS_OFFLINE (Attributo di Istanza)
        self.numero_totale_agenti_arrivati_10SECS_OFFLINE = 0

        # ATTENZIONE: Questi ultimi due attributi sono da usare solo per il caso offline
        # Più nello specifico, sono da usare solo quando si chiama
        # la funzione repeat_alg_offline.

        # COSTRUZIONE AGENTI CART
        self.build_agents_MAPF(self.scenarios_file, self.num_agents_starting, time_counter=0)


    def build_agents_MAPF(self, file_agenti, num_agenti_cart, time_counter):
        """
        Metodo della classe MAPF per costruire
        gli agenti cart
        :param file_agenti: file contenente gli agenti da costruire
        :param num_agenti_cart: numero di agenti da costruire
        :param time_counter: timestep in cui vengono inseriti i nuovi agenti
        """

        g = open(file_agenti, 'r')
        _ = g.readline()  # la prima riga non contiene informazioni interessanti

        for ppp in range(0, self.n_TOTAL_agents):
            content = g.readline()  # così non devo ricontare gli stessi agenti ogni volta
            if not content:  # è finito il file --> ricominciamo a leggerlo
                g.close()
                print("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")
                g = open(file_agenti, 'r')
                _ = g.readline()  # la prima riga non contiene informazioni interessanti
                content = g.readline()  # in un certo senso recuperiamo quella riga che era diventata vuota

        for qqq in range(0, num_agenti_cart):  # 950 = numero massimo di agenti nel file
            linea = g.readline()
            if not linea:  # è finito il file --> ricominciamo a leggerlo
                g.close()
                print("AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")
                g = open(file_agenti, 'r')
                _ = g.readline()  # la prima riga non contiene informazioni interessanti
                linea = g.readline()  # in un certo senso recuperiamo quella riga che era diventata vuota

            linea = linea.rsplit()
            origin_y = int(linea[4])  # colonne
            origin_x = int(linea[5])  # righe
            goal_y = int(linea[6])  # colonne
            goal_x = int(linea[7])  # righe
            numero = float(linea[8])

            # COSTRUZIONE AGENTI CART
            self.dizionario_agenti[(self.n_TOTAL_agents)] = Mobile_Agent(id=self.n_TOTAL_agents,
                                                                         origin=[origin_x, origin_y],
                                                                         starting_time=time_counter,
                                                                         goal=[goal_x, goal_y], arrived=0)
            # nella linea di codice precedente abbiamo posto come chiave l'id dell'agente mobile
            # e come valore l'oggetto Mobile_Agent associato
            if self.griglia.dict_tiles[(origin_x, origin_y)].occupied == 0:
                # non c'è problema nell'aggiungere l'agente
                self.dizionario_agenti[(self.n_TOTAL_agents)].in_system = 1

                # non dobbiamo modificare qui dentro lo starting_time, perchè
                # lo facciamo quando risolviamo il problema

                self.griglia.dict_tiles[(origin_x, origin_y)].occupied = 1
                self.griglia.dict_tiles[(origin_x, origin_y)].agent_on_tile = self.n_TOTAL_agents
                # con la riga sopra abbiamo associato alla tile l'id dell'agente mobile che si trova su di essa
                self.list_agents_start.append([origin_x, origin_y])
                self.list_agents_goal.append([goal_x, goal_y])
                # forse la seguente linea di codice non serve
                self.dict_agents_position[(self.n_TOTAL_agents)] = [origin_x, origin_y]

                # il seguente comando ci potrebbe servire
                # per il plot
                self.griglia.matrix[origin_x, origin_y] = START_CELL
                self.griglia.dict_tiles[(origin_x, origin_y)].original_color = START_CELL
                if self.griglia.dict_tiles[(goal_x, goal_y)].occupied == 0:
                    # attenzione che questo va a modificare la griglia
                    self.griglia.matrix[goal_x, goal_y] = GOAL_CELL
                    # in caso contrario vuol dire che c'è un agente in quella posizione
                    # e visto che questo agente prima o poi lascerà la posizione, possiamo
                    # imporre che il nuovo colore originale sia proprio quello di una cella goal
                    # che specifichiamo alla riga qui sotto
                self.griglia.dict_tiles[(goal_x, goal_y)].original_color = GOAL_CELL

            else:
                # dobbiamo attendere che la cella di partenza si liberi
                self.dizionario_agenti[(self.n_TOTAL_agents)].in_system = 0

            self.n_TOTAL_agents = self.n_TOTAL_agents + 1  # incrementiamo il numero totale di agenti nel sistema
            # alla fine numero_agenti_considerati dovrebbe essere uguale a n_TOTAL_agents

        g.close()

    def solve_MAPF(self, plot):
        """
        Metodo della classe MAPF utilizzato per
        risolvere il problema di planning
        :param plot: booleano per indicare se si
                    vuole considerare una
                    rappresentazione grafica (1)
                    oppure no (0)
        :return: se plot = 1 restituisce la sequenza di plot.
        """
        start_time_python = time.time()  # tempo di inizio esecuzione risoluzione
        # ORA INIZIA L'ALGORITMO
        if plot == 1:
            fig = plt.figure()
            ax = plt.axes()
            # we build our window
            ax.imshow(self.griglia.matrix, cmap=cmap, norm=norm)
            # ax.imshow(self.griglia.matrix, cmap=cmap)
            # with this command we display data as an image, i.e.,
            # on a 2D regular raster.
            # let's draw gridlines
            ax.grid(which='major', axis='both', linestyle='-', color='k', linewidth=1)
            ax.set_xticks(np.arange(0.5, self.larghezza_griglia, 1))
            ax.set_yticks(np.arange(0.5, self.altezza_griglia, 1))
            plt.tick_params(axis='both', which='both', bottom=False,
                            left=False, labelbottom=False,
                            labelleft=False)
            # fig.set_size_inches((8.5, 11), forward=False)
            stringa_titolo = 'plot_noconflict_perm_traffic_2_coupledrows_{}.png'
            stringa_titolo_completo = stringa_titolo.format(-1)
            plt.savefig(stringa_titolo_completo)
            plt.pause(1)

        numero_totale_agenti_arrivati_5SECS_OFFLINE = 0
        numero_totale_agenti_arrivati_10SECS_OFFLINE = 0
        CHECK_ON_TIME_AND_PERCENTAGE_5SECS_OFFLINE = 0
        CHECK_ON_TIME_AND_PERCENTAGE_10SECS_OFFLINE = 0
        CONTATORE = 0
        conteggio_nuovi = 0  # ci serve per dare un limite agli arrivi di nuovi agenti
        timesteps_lordi_max = -1
        while CONTATORE != (self.num_agents_starting + self.max_new_agents):
            timesteps_lordi_max = timesteps_lordi_max + 1
            CONTATORE = 0
            if conteggio_nuovi != self.max_new_agents:
                if random.randint(0, 1) == 1:  # se si entra in questo if, allora la variabile
                    # self.n_TOTAL_agents aumenta di 1
                    # build new agent
                    conteggio_nuovi = conteggio_nuovi + 1
                    self.build_agents_MAPF(self.scenarios_file, 1, time_counter=timesteps_lordi_max)  # costruiamo un nuovo agente

            # il seguente ciclo for ci serve per capire se
            # possiamo aggiungere degli agenti che stanno attendendo
            # nel sistema
            for ddd in range(0, len(self.dizionario_agenti)):
                if self.dizionario_agenti[(ddd)].in_system == 0:
                    # vuol dire che l'agente ddd è in attesa di entrare nel sistema
                    # N.B. nota che un generico agente NON PUO' scontrarsi con agenti
                    # non nel sistema, dunque quando ci sono conflitti NON dobbiamo
                    # chiederci se i secondi agenti coinvolti sono nel sistema
                    lista_origine = self.dizionario_agenti[(ddd)].origin.copy()
                    if self.griglia.dict_tiles[tuple(lista_origine)].occupied == 0:
                        self.dizionario_agenti[(ddd)].in_system = 1

                        self.dizionario_agenti[(ddd)].starting_time = timesteps_lordi_max

                        self.griglia.dict_tiles[tuple(lista_origine)].occupied = 1
                        self.griglia.dict_tiles[tuple(lista_origine)].agent_on_tile = ddd
                        # con la riga sopra abbiamo associato alla tile l'id dell'agente mobile che si trova su di essa
                        self.list_agents_start.append(lista_origine)
                        lista_goal = self.dizionario_agenti[(ddd)].goal.copy()
                        self.list_agents_goal.append(lista_goal)
                        # forse la seguente linea di codice non serve
                        self.dict_agents_position[(ddd)] = lista_origine.copy()

                        # il seguente comando ci potrebbe servire
                        # per il plot
                        self.griglia.matrix[lista_origine[0], lista_origine[1]] = START_CELL
                        self.griglia.dict_tiles[tuple(lista_origine)].original_color = START_CELL
                        if self.griglia.dict_tiles[tuple(lista_goal)].occupied == 0:
                            # attenzione che questo va a modificare la griglia
                            self.griglia.matrix[lista_goal[0], lista_goal[1]] = GOAL_CELL
                            # in caso contrario vuol dire che c'è un agente in quella posizione
                            # e visto che questo agente prima o poi lascerà la posizione, possiamo
                            # imporre che il nuovo colore originale sia proprio quello di una cella goal
                            # che specifichiamo alla riga qui sotto
                        self.griglia.dict_tiles[tuple(lista_goal)].original_color = GOAL_CELL

            for s in range(0, len(self.dizionario_agenti)):
                self.dizionario_agenti[(s)].considerato = 0
            # a questo punto utilizziamo shuffle per permutare il vettore degli indici
            # degli agenti, di modo che questi non vengano sempre processati nello stesso ordine
            elenco_indici = list(range(0, self.n_TOTAL_agents))
            valore_ripetizione = random.randint(1,10)  # abbiamo scelto di pescare da un insieme di 10
            for repeat_shuffle in range(0, valore_ripetizione):
                shuffle(elenco_indici)  # ricorda che grazie a random.seed dovremmo avere sempre stessi shuffle
            elenco_indici_bis = elenco_indici.copy()
            for s in elenco_indici_bis:
                if self.dizionario_agenti[(s)].in_system == 1:
                    # chiaramente deve essere nel sistema un agente per essere processato
                    if self.dizionario_agenti[(s)].arrived == 0:  # AGENTE NON ARRIVATO A DESTINAZIONE
                        if self.dizionario_agenti[(s)].position == self.dizionario_agenti[(s)].goal:
                            # DI FATTO SI ENTRERA' IN QUESTO IF SOLO SE UN AGENTE FIN DALLA ORIGINE
                            # DEI TEMPI SI TROVA NELLA PROPRIA DESTINAZIONE
                            self.dizionario_agenti[(s)].arrived = 1
                            self.dizionario_agenti[(s)].considerato = 1
                            self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                     self.dizionario_agenti[(s)].position[
                                                         1])].occupied = 0  # DISAPPEAR AT TARGET
                            self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                     self.dizionario_agenti[(s)].position[1])].agent_on_tile = None
                            # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                            self.griglia.matrix[
                                self.dizionario_agenti[(s)].position[0], self.dizionario_agenti[(s)].position[1]] = \
                                self.griglia.dict_tiles[
                                    (self.dizionario_agenti[(s)].position[0],
                                     self.dizionario_agenti[(s)].position[1])].original_color
                            # ovvero la cella diventa del colore che era prima (disappear at target)
                            # qui sopra non metto copy perchè original color è un numero

                        else:  # AGENTE DEVE SEGUIRE LO SHORTEST PATH PER ARRIVARE A DESTINAZIONE
                            if self.dizionario_agenti[(s)].considerato == 0:  # lo facciamo per poter plottare bene
                                # NOTA CHE SE FOSSE CONSIDERATO = 1, NON DOVREMMO AGGIORNARE NULLA
                                # PERCHE' SEMPLICEMENTE VORREBBE DIRE CHE ABBIAMO GIA' ANALIZZATO QUELL'AGENTE,
                                # QUINDI IN DEFINITIVA NON METTIAMO ELSE
                                self.tot_search_method_calls = self.tot_search_method_calls + 1
                                came_from_bis, cost_so_far_bis = a_star_search(self.griglia,
                                                                       self.dizionario_agenti[(s)].position,
                                                                       self.dizionario_agenti[(s)].goal)
                                came_from = came_from_bis.copy()
                                cost_so_far = cost_so_far_bis.copy()
                                # the code to reconstruct the path is simple:
                                # follow the arrows backwards from the goal to
                                # the start. A path is a sequence of edges,
                                # but often it's easier to store the nodes.
                                cammino = []
                                corrente = self.dizionario_agenti[(s)].goal.copy()  # lista fatta di due elementi, x e y
                                while corrente != self.dizionario_agenti[(s)].position:
                                    cammino.append(corrente)
                                    corrente = came_from[tuple(corrente)]  # corrente a primo membro è una tupla
                                    # per costruzione di came_from (dizionario)
                                    # ricorda came_from[next] = current
                                    corrente = list(corrente)  # ritrasformo in lista

                                # nota che cammino non ha la posizione attuale
                                cammino.reverse()

                                self.dizionario_agenti[(s)].path = cammino.copy()

                                xxx = cammino[0][0]
                                yyy = cammino[0][1]
                                if self.griglia.dict_tiles[(xxx, yyy)].occupied == 0:
                                    self.dizionario_agenti[(s)].considerato = 1
                                    # teoricamente tutte queste chiamate non corrispondono ad ostacoli
                                    self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                             self.dizionario_agenti[(s)].position[1])].occupied = 0
                                    self.griglia.dict_tiles[
                                        (self.dizionario_agenti[(s)].position[0],
                                         self.dizionario_agenti[(s)].position[1])].agent_on_tile = None
                                    # il seguente if è solo per una questione di comprensione visiva: in questo modo rimane
                                    # il quadratino colorato come la partenza per la partenza
                                    # if self.list_agents[s].position != self.list_agents[s].origin:
                                    #   self.griglia.matrix[self.list_agents[s].position[0], self.list_agents[s].position[1]] = VISITED_CELL
                                    self.griglia.matrix[
                                        self.dizionario_agenti[(s)].position[0], self.dizionario_agenti[(s)].position[1]] = \
                                        self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                                 self.dizionario_agenti[(s)].position[1])].original_color
                                    # con il precedente comando abbiamo risettato il colore della tile a quello che c'era
                                    # prima dell'arrivo dello skid

                                    # modifichiamo il costo del cammino finora intrapreso (e lo facciamo
                                    # adesso, prima che cambiamo definitivamente la posizione
                                    # dell'agente)
                                    self.dizionario_agenti[(s)].costo_agente = self.dizionario_agenti[
                                                                                   (s)].costo_agente + 1
                                    self.dizionario_agenti[(s)].timestep_agente = self.dizionario_agenti[
                                                                                      (s)].timestep_agente + 1
                                    # dovrebbero essere identici questi due attributi di classe, almeno
                                    # finchè consideriamo costo 1 fisso per ogni cella


                                    self.dizionario_agenti[(s)].position = [xxx, yyy]
                                    # aggiorniamo la posizione dell'agente
                                    # qui sopra non usiamo copy perchè la lista a secondo membro è
                                    # fatta da interi



                                    if self.dizionario_agenti[(s)].position == self.dizionario_agenti[(s)].goal:
                                        self.dizionario_agenti[(s)].arrived = 1
                                        self.griglia.dict_tiles[
                                            (self.dizionario_agenti[(s)].position[0],
                                             self.dizionario_agenti[(s)].position[
                                                 1])].occupied = 0  # DISAPPEAR AT TARGET
                                        self.griglia.dict_tiles[
                                            (self.dizionario_agenti[(s)].position[0],
                                             self.dizionario_agenti[(s)].position[
                                                 1])].agent_on_tile = None
                                        # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                        self.griglia.matrix[
                                            self.dizionario_agenti[(s)].position[0],
                                            self.dizionario_agenti[(s)].position[1]] = \
                                            self.griglia.dict_tiles[
                                                (self.dizionario_agenti[(s)].position[0],
                                                 self.dizionario_agenti[(s)].position[
                                                     1])].original_color
                                        # ovvero la cella diventa del colore che era prima (disappear at target)
                                        # qui sopra non metto copy perchè original color è un numero
                                    else:
                                        self.griglia.dict_tiles[(xxx, yyy)].occupied = 1
                                        self.griglia.dict_tiles[(xxx, yyy)].agent_on_tile = self.dizionario_agenti[
                                            (s)].id
                                        self.griglia.matrix[xxx, yyy] = MOVE_CELL



                                    tempo_python = time.time()
                                    tempo_intermedio = tempo_python - start_time_python
                                    print("Posizione agente ", self.dizionario_agenti[(s)].id, " al tempo ",
                                          tempo_intermedio, " : ", self.dizionario_agenti[(s)].position)



                                else:  # la tile dove dovrebbe andare è occupata
                                    self.tot_possible_conflicts = self.tot_possible_conflicts + 1

                                    self.dizionario_agenti[(s)].considerato = 1
                                    id_agente_altro = self.griglia.dict_tiles[(xxx, yyy)].agent_on_tile
                                    # non c'è copy perchè a secondo membro abbiamo un indice

                                    if self.dizionario_agenti[(id_agente_altro)].considerato == 0:
                                        # IN QUESTO CASO INVECE CI VORRA' ELSE PERCHE' E' L'ALTRO AGENTE
                                        # CHE E' STATO PROCESSATO, NON L'AGENTE S, QUINDI DOBBIAMO AGGIORNARE
                                        # LE INFORMAZIONI DELL'AGENTE S
                                        self.dizionario_agenti[(id_agente_altro)].considerato = 1

                                        # in maniera casuale (potrebbe entrare in azione la teoria
                                        # dei giochi) uno dei due agenti coinvolti si sposta su un'altra tile
                                        numero_casuale = random.randint(0, 1)
                                        if numero_casuale == 0:
                                            # si sposta il primo agente
                                            pos_iniz_agente_ostacolato_bis = self.dizionario_agenti[(s)].position
                                            pos_iniz_agente_ostacolato = pos_iniz_agente_ostacolato_bis.copy()
                                            celle_vicine = self.griglia.neighbors(
                                                self.dizionario_agenti[(s)].position).copy()
                                            # quello che sta dentro la parentesi qua sopra è una lista
                                            # Ricorda che per come è definita neighbors, non è possibile
                                            # che tra i vicini si inseriscano anche degli ostacoli
                                            lista_possibili_nuove_posizioni = []
                                            for oggetto in celle_vicine:
                                                if self.griglia.dict_tiles[tuple(oggetto)].occupied == 0:
                                                    # la cella che è in posizione "oggetto" non è occupata
                                                    lista_possibili_nuove_posizioni.append(oggetto)
                                            if lista_possibili_nuove_posizioni != []:
                                                numero_casuale_vicini = random.randint(0, len(lista_possibili_nuove_posizioni) - 1)
                                                # stiamo estraendo a caso uno dei vicini non occupati
                                                # al fine di spostare l'agente su di esso.

                                                self.griglia.dict_tiles[
                                                    (self.dizionario_agenti[(s)].position[0],
                                                     self.dizionario_agenti[(s)].position[1])].occupied = 0
                                                self.griglia.dict_tiles[
                                                    (self.dizionario_agenti[(s)].position[0],
                                                     self.dizionario_agenti[(s)].position[1])].agent_on_tile = None
                                                self.griglia.matrix[self.dizionario_agenti[(s)].position[0],
                                                                    self.dizionario_agenti[(s)].position[1]] = \
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(s)].position[0],
                                                         self.dizionario_agenti[(s)].position[1])].original_color
                                                # con il precedente comando abbiamo risettato il colore della tile a quello che c'era
                                                # prima dell'arrivo dello skid
                                                # non mettiamo copy perchè original color è un numero


                                                # Abbiamo levato l'agente dalla posizione precedente, ora lo mettiamo in quella nuova
                                                self.dizionario_agenti[(s)].position = \
                                                    lista_possibili_nuove_posizioni[numero_casuale_vicini].copy()
                                                # abbiamo appena aggiornato la posizione dell'agente


                                                if self.dizionario_agenti[(s)].position == self.dizionario_agenti[(s)].goal:
                                                    self.dizionario_agenti[(s)].arrived = 1
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(s)].position[0],
                                                         self.dizionario_agenti[(s)].position[
                                                             1])].occupied = 0  # DISAPPEAR AT TARGET
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(s)].position[0],
                                                         self.dizionario_agenti[(s)].position[
                                                             1])].agent_on_tile = None
                                                    # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(s)].position[0],
                                                        self.dizionario_agenti[(s)].position[1]] = \
                                                        self.griglia.dict_tiles[
                                                            (self.dizionario_agenti[(s)].position[0],
                                                             self.dizionario_agenti[(s)].position[
                                                                 1])].original_color
                                                    # ovvero la cella diventa del colore che era prima (disappear at target)
                                                    # qui sopra non metto copy perchè original color è un numero
                                                else:
                                                    self.griglia.dict_tiles[
                                                        tuple(self.dizionario_agenti[(s)].position)].occupied = 1
                                                    self.griglia.dict_tiles[
                                                        tuple(self.dizionario_agenti[(s)].position)].agent_on_tile = \
                                                        self.dizionario_agenti[(s)].id
                                                    self.griglia.matrix[self.dizionario_agenti[(s)].position[0],
                                                                        self.dizionario_agenti[(s)].position[
                                                                            1]] = MOVE_CELL


                                                tempo_python = time.time()
                                                tempo_intermedio = tempo_python - start_time_python
                                                print("Posizione agente ", self.dizionario_agenti[(s)].id, " al tempo ",
                                                        tempo_intermedio, " : ", self.dizionario_agenti[(s)].position)



                                                # aggiorniamo il costo del cammino finora intrapreso
                                                self.dizionario_agenti[(s)].costo_agente = \
                                                    self.dizionario_agenti[(s)].costo_agente + 1
                                                self.dizionario_agenti[(s)].timestep_agente = \
                                                    self.dizionario_agenti[(s)].timestep_agente + 1
                                                # in questo script, essendoci valori pari a 1 per tutte le celle, questi
                                                # due attributi devono essere uguali




                                                # ORA FACCIAMO SPOSTARE L'ALTRO AGENTE
                                                # id_agente_altro = self.griglia.dict_tiles[(xxx, yyy)].agent_on_tile

                                                self.griglia.dict_tiles[(xxx, yyy)].occupied = 0
                                                self.griglia.dict_tiles[(xxx, yyy)].agent_on_tile = None
                                                self.griglia.matrix[
                                                    self.dizionario_agenti[(id_agente_altro)].position[0],
                                                    self.dizionario_agenti[(id_agente_altro)].position[1]] = \
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                         self.dizionario_agenti[(id_agente_altro)].position[1])].original_color
                                                # con il precedente comando abbiamo risettato il colore della tile a quello che c'era
                                                # prima dell'arrivo dello skid

                                                # Abbiamo levato l'agente dalla posizione precedente, ora lo mettiamo in quella nuova
                                                self.dizionario_agenti[
                                                    (id_agente_altro)].position = pos_iniz_agente_ostacolato.copy()
                                                # abbiamo appena aggiornato la posizione dell'agente


                                                if self.dizionario_agenti[(id_agente_altro)].position == self.dizionario_agenti[
                                                    (id_agente_altro)].goal:
                                                    self.dizionario_agenti[(id_agente_altro)].arrived = 1
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                         self.dizionario_agenti[(id_agente_altro)].position[
                                                             1])].occupied = 0  # DISAPPEAR AT TARGET
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                         self.dizionario_agenti[(id_agente_altro)].position[
                                                             1])].agent_on_tile = None
                                                    # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(id_agente_altro)].position[0],
                                                        self.dizionario_agenti[(id_agente_altro)].position[1]] = \
                                                        self.griglia.dict_tiles[
                                                            (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                             self.dizionario_agenti[(id_agente_altro)].position[
                                                                 1])].original_color
                                                    # ovvero la cella diventa del colore che era prima (disappear at target)
                                                    # qui sopra non metto copy perchè original color è un numero
                                                else:
                                                    self.griglia.dict_tiles[tuple(self.dizionario_agenti[(
                                                        id_agente_altro)].position)].occupied = 1
                                                    self.griglia.dict_tiles[tuple(self.dizionario_agenti[(
                                                        id_agente_altro)].position)].agent_on_tile = \
                                                        self.dizionario_agenti[(id_agente_altro)].id
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(id_agente_altro)].position[0],
                                                        self.dizionario_agenti[(id_agente_altro)].position[
                                                            1]] = MOVE_CELL




                                                tempo_python = time.time()
                                                tempo_intermedio = tempo_python - start_time_python
                                                print("Posizione agente ",
                                                      self.dizionario_agenti[(id_agente_altro)].id, " al tempo ",
                                                      tempo_intermedio, " : ", self.dizionario_agenti[(id_agente_altro)].position)



                                                # aggiorniamo il costo del cammino intrapreso finora
                                                self.dizionario_agenti[(id_agente_altro)].costo_agente = \
                                                    self.dizionario_agenti[(id_agente_altro)].costo_agente + 1
                                                self.dizionario_agenti[(id_agente_altro)].timestep_agente = \
                                                    self.dizionario_agenti[(id_agente_altro)].timestep_agente + 1
                                                # essendo la griglia con costi sempre pari a 1, in questo script
                                                # questi due attributi di istanza devono essere uguali


                                            else:  # lista_possibili_nuove_posizioni = []
                                                print('Agente ', self.dizionario_agenti[(s)].id,
                                                      ' è bloccato, quindi per evitare di scontrarsi con altri resta fermo')

                                                # self.tot_possible_conflicts = self.tot_possible_conflicts + 1
                                                # NON AGGIUNGIAMO UN POSSIBILE CONFLITTO AL NUMERO TOTALE
                                                # PERCHE' SE LO FACESSIMO RAPPRESENTEREBBE UN CONFLITTO POSSIBILE
                                                # DEL PRIMO AGENTE CON ALTRI SUOI VICINI (ESCLUSO IL SECONDO AGENTE),
                                                # MA NON SAPPIAMO ESATTAMENTE SE I VICINI DEL PRIMO AGENTE SIANO
                                                # ANCH'ESSI AGENTI OPPURE SIANO OSTACOLI FISICI. NEL CASO
                                                # SIANO OSTACOLI FISICI, NON HA SENSO PARLARE DI COLLISIONI PER COME
                                                # LE STIAMO INTENDENDO (PERCHE' NOI INTENDIAMO COLLISIONI AGENTE-AGENTE)

                                                # in teoria non si entra mai in questo if
                                                if self.dizionario_agenti[(s)].position == \
                                                        self.dizionario_agenti[(s)].goal:
                                                    self.dizionario_agenti[(s)].arrived = 1
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(s)].position[0],
                                                         self.dizionario_agenti[(s)].position[
                                                             1])].occupied = 0  # DISAPPEAR AT TARGET
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(s)].position[0],
                                                         self.dizionario_agenti[(s)].position[
                                                             1])].agent_on_tile = None
                                                    # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(s)].position[0],
                                                        self.dizionario_agenti[(s)].position[1]] = \
                                                        self.griglia.dict_tiles[
                                                            (self.dizionario_agenti[(s)].position[0],
                                                             self.dizionario_agenti[(s)].position[
                                                                 1])].original_color
                                                    # ovvero la cella diventa del colore che era prima (disappear at target)
                                                    # qui sopra non metto copy perchè original color è un numero


                                                # aggiorniamo il costo per l'agente
                                                self.dizionario_agenti[(s)].costo_agente = self.dizionario_agenti[(s)].costo_agente + 1
                                                self.dizionario_agenti[(s)].timestep_agente = self.dizionario_agenti[(s)].timestep_agente + 1





                                                # ORA AGGIORNIAMO IL SECONDO AGENTE
                                                # SUPPONIAMO PER SEMPLICITA' CHE ANCH'ESSO A QUESTO PUNTO RIMANGA FERMO
                                                # (NONOSTANTE MAGARI POSSA MUOVERSI IN ALTRE DIREZIONI PER SVIARE
                                                # DALL'AVERE DAVANTI A SE' UN AGENTE BLOCCATO)
                                                # id_agente_altro = self.griglia.dict_tiles[(xxx, yyy)].agent_on_tile
                                                print('Agente ', self.dizionario_agenti[(id_agente_altro)].id,
                                                      ' è in attesa di muoversi (è vicino ad un agente bloccato)')


                                                if self.dizionario_agenti[(id_agente_altro)].position == \
                                                        self.dizionario_agenti[(id_agente_altro)].goal:
                                                    self.dizionario_agenti[(id_agente_altro)].arrived = 1
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                         self.dizionario_agenti[(id_agente_altro)].position[
                                                             1])].occupied = 0  # DISAPPEAR AT TARGET
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                         self.dizionario_agenti[(id_agente_altro)].position[
                                                             1])].agent_on_tile = None
                                                    # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(id_agente_altro)].position[0],
                                                        self.dizionario_agenti[(id_agente_altro)].position[1]] = \
                                                        self.griglia.dict_tiles[
                                                            (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                             self.dizionario_agenti[(id_agente_altro)].position[
                                                                 1])].original_color
                                                    # ovvero la cella diventa del colore che era prima (disappear at target)
                                                    # qui sopra non metto copy perchè original color è un numero



                                                # aggiorniamo il costo per l'agente
                                                self.dizionario_agenti[(id_agente_altro)].costo_agente = \
                                                    self.dizionario_agenti[
                                                        (id_agente_altro)].costo_agente + 1
                                                self.dizionario_agenti[(id_agente_altro)].timestep_agente = \
                                                    self.dizionario_agenti[(
                                                        id_agente_altro)].timestep_agente + 1


                                        else:
                                            # si sposta il secondo agente
                                            celle_vicine = self.griglia.neighbors([xxx, yyy]).copy()
                                            # quello che sta dentro la parentesi qua sopra è una lista
                                            lista_possibili_nuove_posizioni = []
                                            for oggetto in celle_vicine:
                                                if self.griglia.dict_tiles[tuple(oggetto)].occupied == 0:
                                                    # la cella che è in posizione "oggetto" non è occupata
                                                    lista_possibili_nuove_posizioni.append(oggetto)
                                            if lista_possibili_nuove_posizioni != []:  # nota che nel caso così
                                                # non fosse allora a questo step non avviene un cambio
                                                # di posizione da parte degli agenti coinvolti, nel
                                                # caso uno di questi si trovi impossibilitato a
                                                # muoversi.
                                                numero_casuale_vicini = random.randint(0, len(lista_possibili_nuove_posizioni) - 1)
                                                # stiamo estraendo a caso uno dei vicini non occupati
                                                # al fine di spostare l'agente su di esso.

                                                self.griglia.dict_tiles[(xxx, yyy)].occupied = 0
                                                self.griglia.dict_tiles[(xxx, yyy)].agent_on_tile = None
                                                self.griglia.matrix[xxx, yyy] = \
                                                    self.griglia.dict_tiles[(xxx, yyy)].original_color
                                                # con il precedente comando abbiamo risettato il colore della tile a quello che c'era
                                                # prima dell'arrivo dello skid

                                                # Abbiamo levato l'agente dalla posizione precedente, ora lo mettiamo in quella nuova
                                                self.dizionario_agenti[(id_agente_altro)].position = \
                                                lista_possibili_nuove_posizioni[numero_casuale_vicini].copy()
                                                # abbiamo appena aggiornato la posizione dell'agente


                                                if self.dizionario_agenti[(id_agente_altro)].position == \
                                                        self.dizionario_agenti[(id_agente_altro)].goal:
                                                    self.dizionario_agenti[(id_agente_altro)].arrived = 1
                                                    self.griglia.dict_tiles[(self.dizionario_agenti[(id_agente_altro)].position[0],
                                                                             self.dizionario_agenti[(id_agente_altro)].position[
                                                                                 1])].occupied = 0  # DISAPPEAR AT TARGET
                                                    self.griglia.dict_tiles[(self.dizionario_agenti[(id_agente_altro)].position[0],
                                                                             self.dizionario_agenti[(id_agente_altro)].position[
                                                                                 1])].agent_on_tile = None
                                                    # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(id_agente_altro)].position[0],
                                                        self.dizionario_agenti[(id_agente_altro)].position[1]] = \
                                                        self.griglia.dict_tiles[
                                                            (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                             self.dizionario_agenti[(id_agente_altro)].position[1])].original_color
                                                    # ovvero la cella diventa del colore che era prima (disappear at target)
                                                    # qui sopra non metto copy perchè original color è un numero
                                                else:
                                                    self.griglia.dict_tiles[tuple(self.dizionario_agenti[(
                                                        id_agente_altro)].position)].occupied = 1
                                                    self.griglia.dict_tiles[tuple(self.dizionario_agenti[(
                                                        id_agente_altro)].position)].agent_on_tile = \
                                                        self.dizionario_agenti[(id_agente_altro)].id
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(id_agente_altro)].position[0],
                                                        self.dizionario_agenti[(id_agente_altro)].position[
                                                            1]] = MOVE_CELL



                                                tempo_python = time.time()
                                                tempo_intermedio = tempo_python - start_time_python
                                                print("Posizione agente ", self.dizionario_agenti[(id_agente_altro)].id, " al tempo ",
                                                      tempo_intermedio, " : ", self.dizionario_agenti[(id_agente_altro)].position)


                                                # aggiorniamo il costo del cammino intrapreso finora
                                                self.dizionario_agenti[(id_agente_altro)].costo_agente = \
                                                    self.dizionario_agenti[(id_agente_altro)].costo_agente + 1
                                                self.dizionario_agenti[(id_agente_altro)].timestep_agente = \
                                                    self.dizionario_agenti[(id_agente_altro)].timestep_agente + 1
                                                # in questo script questi due attributi devono essere uguali


                                                # ORA FACCIAMO SPOSTARE L'ALTRO AGENTE
                                                self.griglia.dict_tiles[
                                                    (self.dizionario_agenti[(s)].position[0],
                                                     self.dizionario_agenti[(s)].position[1])].occupied = 0
                                                self.griglia.dict_tiles[
                                                    (self.dizionario_agenti[(s)].position[0],
                                                     self.dizionario_agenti[(s)].position[1])].agent_on_tile = None

                                                self.griglia.matrix[self.dizionario_agenti[(s)].position[0],
                                                                    self.dizionario_agenti[(s)].position[1]] = \
                                                    self.griglia.dict_tiles[
                                                        (self.dizionario_agenti[(s)].position[0],
                                                         self.dizionario_agenti[(s)].position[1])].original_color
                                                # con il precedente comando abbiamo risettato il colore della tile a quello che c'era
                                                # prima dell'arrivo dello skid


                                                # aggiorniamo il costo del cammino intrapreso finora
                                                self.dizionario_agenti[(s)].costo_agente = \
                                                    self.dizionario_agenti[(s)].costo_agente + 1
                                                self.dizionario_agenti[(s)].timestep_agente = \
                                                    self.dizionario_agenti[(s)].timestep_agente + 1
                                                # in questo script questi due attributi devono essere uguali

                                                # Abbiamo levato l'agente dalla posizione precedente, ora lo mettiamo in quella nuova
                                                self.dizionario_agenti[(s)].position = [xxx, yyy]
                                                # abbiamo appena aggiornato la posizione dell'agente




                                                if self.dizionario_agenti[(s)].position == \
                                                        self.dizionario_agenti[(s)].goal:
                                                    self.dizionario_agenti[(s)].arrived = 1
                                                    self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                                             self.dizionario_agenti[(s)].position[
                                                                                 1])].occupied = 0  # DISAPPEAR AT TARGET
                                                    self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                                             self.dizionario_agenti[(s)].position[
                                                                                 1])].agent_on_tile = None
                                                    # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(s)].position[0],
                                                        self.dizionario_agenti[(s)].position[1]] = \
                                                        self.griglia.dict_tiles[
                                                            (self.dizionario_agenti[(s)].position[0],
                                                             self.dizionario_agenti[(s)].position[1])].original_color
                                                    # ovvero la cella diventa del colore che era prima (disappear at target)
                                                    # qui sopra non metto copy perchè original color è un numero
                                                else:
                                                    self.griglia.dict_tiles[(xxx, yyy)].occupied = 1
                                                    self.griglia.dict_tiles[(xxx, yyy)].agent_on_tile = \
                                                        self.dizionario_agenti[(s)].id
                                                    self.griglia.matrix[xxx, yyy] = MOVE_CELL



                                                tempo_python = time.time()
                                                tempo_intermedio = tempo_python - start_time_python
                                                print("Posizione agente ", self.dizionario_agenti[(s)].id, " al tempo ",
                                                      tempo_intermedio, " : ", self.dizionario_agenti[(s)].position)



                                            else:  # lista_possibili_nuove_posizioni = []
                                                print('Agente ', self.dizionario_agenti[(id_agente_altro)].id,
                                                      ' è bloccato, quindi per evitare di scontrarsi con altri resta fermo')

                                                # self.tot_possible_conflicts = self.tot_possible_conflicts + 1
                                                # NON AGGIUNGIAMO UN POSSIBILE CONFLITTO AL NUMERO TOTALE
                                                # PERCHE' SE LO FACESSIMO RAPPRESENTEREBBE UN CONFLITTO POSSIBILE
                                                # DEL SECONDO AGENTE CON ALTRI SUOI VICINI (ESCLUSO IL PRIMO AGENTE),
                                                # MA NON SAPPIAMO ESATTAMENTE SE I VICINI DEL SECONDO AGENTE SIANO
                                                # ANCH'ESSI AGENTI OPPURE SIANO OSTACOLI FISICI. NEL CASO
                                                # SIANO OSTACOLI FISICI, NON HA SENSO PARLARE DI COLLISIONI PER COME
                                                # LE STIAMO INTENDENDO (PERCHE' NOI INTENDIAMO COLLISIONI AGENTE-AGENTE)


                                                if self.dizionario_agenti[(id_agente_altro)].position == \
                                                        self.dizionario_agenti[(id_agente_altro)].goal:
                                                    self.dizionario_agenti[(id_agente_altro)].arrived = 1
                                                    self.griglia.dict_tiles[(self.dizionario_agenti[(id_agente_altro)].position[0],
                                                                             self.dizionario_agenti[(id_agente_altro)].position[
                                                                                 1])].occupied = 0  # DISAPPEAR AT TARGET
                                                    self.griglia.dict_tiles[(self.dizionario_agenti[(id_agente_altro)].position[0],
                                                                             self.dizionario_agenti[(id_agente_altro)].position[
                                                                                 1])].agent_on_tile = None
                                                    # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(id_agente_altro)].position[0],
                                                        self.dizionario_agenti[(id_agente_altro)].position[1]] = \
                                                        self.griglia.dict_tiles[
                                                            (self.dizionario_agenti[(id_agente_altro)].position[0],
                                                             self.dizionario_agenti[(id_agente_altro)].position[1])].original_color
                                                    # ovvero la cella diventa del colore che era prima (disappear at target)
                                                    # qui sopra non metto copy perchè original color è un numero


                                                # aggiorniamo il costo per l'agente
                                                self.dizionario_agenti[(id_agente_altro)].costo_agente = \
                                                    self.dizionario_agenti[(id_agente_altro)].costo_agente + 1
                                                self.dizionario_agenti[(id_agente_altro)].timestep_agente = \
                                                    self.dizionario_agenti[(id_agente_altro)].timestep_agente + 1




                                                # ORA AGGIORNIAMO IL PRIMO AGENTE
                                                # SUPPONIAMO PER SEMPLICITA' CHE ANCH'ESSO A QUESTO PUNTO RIMANGA FERMO
                                                # (NONOSTANTE MAGARI POSSA MUOVERSI IN ALTRE DIREZIONI PER SVIARE
                                                # DALL'AVERE DAVANTI A SE' UN AGENTE BLOCCATO)
                                                print('Agente ', self.dizionario_agenti[(s)].id,
                                                      ' è in attesa di muoversi (è vicino ad un agente bloccato)')


                                                if self.dizionario_agenti[(s)].position == \
                                                        self.dizionario_agenti[(s)].goal:
                                                    self.dizionario_agenti[(s)].arrived = 1
                                                    self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                                             self.dizionario_agenti[(s)].position[
                                                                                 1])].occupied = 0  # DISAPPEAR AT TARGET
                                                    self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                                             self.dizionario_agenti[(s)].position[
                                                                                 1])].agent_on_tile = None
                                                    # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                                    self.griglia.matrix[
                                                        self.dizionario_agenti[(s)].position[0],
                                                        self.dizionario_agenti[(s)].position[1]] = \
                                                        self.griglia.dict_tiles[
                                                            (self.dizionario_agenti[(s)].position[0],
                                                             self.dizionario_agenti[(s)].position[1])].original_color
                                                    # ovvero la cella diventa del colore che era prima (disappear at target)
                                                    # qui sopra non metto copy perchè original color è un numero


                                                # aggiorniamo il costo per l'agente s
                                                self.dizionario_agenti[(s)].costo_agente = \
                                                    self.dizionario_agenti[(s)].costo_agente + 1
                                                self.dizionario_agenti[(s)].timestep_agente = \
                                                    self.dizionario_agenti[(s)].timestep_agente + 1



                                    else:  # self.dizionario_agenti[(id_agente_altro)].considerato = 1
                                        # AGGIORNIAMO LA STORIA DELL'AGENTE S. E' L'UNICA COSA CHE POSSIAMO FARE
                                        # VISTO CHE VORREMMO GESTIRE IL POSSIBILE CONFLITTO MA UNO DEI DUE AGENTI
                                        # COINVOLTI E' GIA' STATO CONSIDERATO
                                        print("Agente ", self.dizionario_agenti[(s)].id,
                                            " è in attesa di muoversi (un agente con cui è in possibile "
                                              "conflitto è già stato processato)")


                                        if self.dizionario_agenti[(s)].position == \
                                                self.dizionario_agenti[(s)].goal:
                                            self.dizionario_agenti[(s)].arrived = 1
                                            self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                                     self.dizionario_agenti[(s)].position[
                                                                         1])].occupied = 0  # DISAPPEAR AT TARGET
                                            self.griglia.dict_tiles[(self.dizionario_agenti[(s)].position[0],
                                                                     self.dizionario_agenti[(s)].position[
                                                                         1])].agent_on_tile = None
                                            # con la riga sopra abbiamo associato None all'agente mobile sopra la tile
                                            self.griglia.matrix[
                                                self.dizionario_agenti[(s)].position[0],
                                                self.dizionario_agenti[(s)].position[1]] = \
                                                self.griglia.dict_tiles[
                                                    (self.dizionario_agenti[(s)].position[0],
                                                     self.dizionario_agenti[(s)].position[1])].original_color
                                            # ovvero la cella diventa del colore che era prima (disappear at target)
                                            # qui sopra non metto copy perchè original color è un numero

                                        # aggiorniamo il costo per l'agente s
                                        self.dizionario_agenti[(s)].costo_agente = self.dizionario_agenti[(s)].costo_agente + 1
                                        self.dizionario_agenti[(s)].timestep_agente = self.dizionario_agenti[(s)].timestep_agente + 1

                            # N.B.: dal momento che stiamo considerando disappear at target,
                            # non dovremo aggiornare il peso quando l'agente è già arrivato
                            # a destinazione, ma ci basta aggiornarlo solo finchè deve raggiungere
                            # l'obiettivo.

                if self.dizionario_agenti[(s)].arrived == 1:
                    CONTATORE = CONTATORE + 1

            # print(CONTATORE)

            if plot == 1:
                # we build our window
                ax = plt.axes()
                ax.imshow(self.griglia.matrix, cmap=cmap, norm=norm)
                # ax.imshow(self.griglia.matrix, cmap=cmap)
                # with this command we display data as an image, i.e.,
                # on a 2D regular raster.
                # let's draw gridlines
                ax.grid(which='major', axis='both', linestyle='-', color='k', linewidth=1)
                ax.set_xticks(np.arange(0.5, self.larghezza_griglia, 1))
                ax.set_yticks(np.arange(0.5, self.altezza_griglia, 1))
                plt.tick_params(axis='both', which='both', bottom=False,
                                left=False, labelbottom=False,
                                labelleft=False)
                # fig.set_size_inches((8.5, 11), forward=False)
                # plt.savefig(saveImageName + ".png", dpi=500)
                stringa_titolo_completo = stringa_titolo.format(timesteps_lordi_max)
                plt.savefig(stringa_titolo_completo)
                plt.pause(1)

            # MEGLIO CONSIDERARE I SEGUENTI DUE BLOCCHI IF SOLO NEL CASO DI APPROCCIO OFFLINE
            # CHECK SU PERCENTUALE AGENTI ARRIVATI A DESTINAZIONE (ENTRO 5 SECONDI)
            if CHECK_ON_TIME_AND_PERCENTAGE_5SECS_OFFLINE == 0:
                tempo_attuale_5SECS_OFFLINE = time.time()
                tempo_passato_5SECS_OFFLINE = tempo_attuale_5SECS_OFFLINE - start_time_python
                if tempo_passato_5SECS_OFFLINE > 5:
                    CHECK_ON_TIME_AND_PERCENTAGE_5SECS_OFFLINE = 1
                    numero_totale_agenti_arrivati_5SECS_OFFLINE = 0
                    for s in elenco_indici_bis:
                        if self.dizionario_agenti[(s)].arrived == 1:  # AGENTE ARRIVATO A DESTINAZIONE
                            numero_totale_agenti_arrivati_5SECS_OFFLINE = numero_totale_agenti_arrivati_5SECS_OFFLINE + 1

                # print(numero_totale_agenti_arrivati_10SECS_OFFLINE)
                # print(CONTATORE)

            # CHECK SU PERCENTUALE AGENTI ARRIVATI A DESTINAZIONE (ENTRO 10 SECONDI)
            if CHECK_ON_TIME_AND_PERCENTAGE_10SECS_OFFLINE == 0:
                tempo_attuale_10SECS_OFFLINE = time.time()
                # print(start_time_python)
                # print(tempo_attuale_10SECS_OFFLINE)
                tempo_passato_10SECS_OFFLINE = tempo_attuale_10SECS_OFFLINE - start_time_python
                if tempo_passato_10SECS_OFFLINE > 10:
                    CHECK_ON_TIME_AND_PERCENTAGE_10SECS_OFFLINE = 1
                    numero_totale_agenti_arrivati_10SECS_OFFLINE = 0
                    for s in elenco_indici_bis:
                        if self.dizionario_agenti[(s)].arrived == 1:  # AGENTE ARRIVATO A DESTINAZIONE
                            # print('arrivato')
                            numero_totale_agenti_arrivati_10SECS_OFFLINE = numero_totale_agenti_arrivati_10SECS_OFFLINE + 1

                # print(numero_totale_agenti_arrivati_10SECS_OFFLINE)
                # print(CONTATORE)

        if CHECK_ON_TIME_AND_PERCENTAGE_5SECS_OFFLINE == 0:  # tutti sono arrivati prima di 5 secondi
            CHECK_ON_TIME_AND_PERCENTAGE_5SECS_OFFLINE = 1
            numero_totale_agenti_arrivati_5SECS_OFFLINE = self.n_TOTAL_agents
        if CHECK_ON_TIME_AND_PERCENTAGE_10SECS_OFFLINE == 0:  # tutti sono arrivati prima di 10 secondi
            CHECK_ON_TIME_AND_PERCENTAGE_10SECS_OFFLINE = 1
            numero_totale_agenti_arrivati_10SECS_OFFLINE = self.n_TOTAL_agents

        stop_time_python = time.time()
        stop_tempo_intermedio = stop_time_python - start_time_python
        print("tutti gli agenti sono arrivati: tempo ", stop_tempo_intermedio)  # corrisponde in sostanza
        # al total travel time del sistema implementato in python, mentre il total travel time
        # in termini di timesteps potrebbe essere ambiguo dal momento che
        # stiamo ragionando in maniera online
        print("totale possibili conflitti (risolti): ", self.tot_possible_conflicts)
        max_costo = 0
        max_costo_id = None
        max_timestep = 0
        max_timestep_id = None
        somma_totale_timesteps_tutti = 0
        somma_totale_costo_tutti = 0
        partenza_max_t = 0
        for sss in range(0, len(self.dizionario_agenti)):
            agente_considerato = self.dizionario_agenti[(sss)]
            print("timesteps per agente ", agente_considerato.id, " : ", agente_considerato.timestep_agente,
                  " partito al timestep: ", agente_considerato.starting_time)
            somma_totale_timesteps_tutti = somma_totale_timesteps_tutti + agente_considerato.timestep_agente
            if agente_considerato.timestep_agente > max_timestep:
                max_timestep = agente_considerato.timestep_agente
                max_timestep_id = agente_considerato.id
                partenza_max_t = agente_considerato.starting_time
            print("costo per agente ", agente_considerato.id, " : ", agente_considerato.costo_agente)
            somma_totale_costo_tutti = somma_totale_costo_tutti + agente_considerato.costo_agente
            if agente_considerato.costo_agente > max_costo:
                max_costo = agente_considerato.costo_agente
                max_costo_id = agente_considerato.id
        print("max timestep: agente ", max_timestep_id, " (al netto di quando è partito): ", max_timestep,
              " partito al timestep: ", partenza_max_t)
        print("max costo: agente ", max_costo_id, " : ", max_costo)
        print("timesteps massimi (lordi) per portare tutti gli agenti a destinazione: ", timesteps_lordi_max)
        print("somma timesteps (sum of costs): ", somma_totale_timesteps_tutti)
        print("sum of costs: ", somma_totale_costo_tutti)
        print("numero di chiamate della funzione di ricerca di cammino minimo: ", self.tot_search_method_calls)
        self.somma_totale_timesteps_tutti = somma_totale_timesteps_tutti
        self.somma_totale_costi_tutti = somma_totale_costo_tutti
        self.tempo_totale = stop_tempo_intermedio
        self.makespan_costo = max_costo
        self.makespan_timesteps = timesteps_lordi_max

        self.numero_totale_agenti_arrivati_5SECS_OFFLINE = numero_totale_agenti_arrivati_5SECS_OFFLINE
        self.numero_totale_agenti_arrivati_10SECS_OFFLINE = numero_totale_agenti_arrivati_10SECS_OFFLINE


class Grid:
    """
    Classe per la griglia.
    """

    def __init__(self, file_griglia):
        """
        Method for Initialization.
        :param file_griglia: file containing grid information
        """
        # ATTRIBUTO file_griglia (Attributo di Istanza)
        self.file_griglia = file_griglia

        # ATTRIBUTO dict_tiles (Attributo di Istanza)
        self.dict_tiles = {}  # INSERIREMO GLI OGGETTI TILES

        # ATTRIBUTO Obstacles (Attributo di Istanza)
        self.Obstacles = []  # lista di coppie x,y

        f = open(self.file_griglia, 'r')
        # ATTRIBUTO righe_totali (Attributo di Istanza)
        _ = f.readline()  # la prima riga non ci interessa, dovrebbe essere 'type octile\n'
        file_line = f.readline()  # generalmente questa seconda riga contiene la altezza della griglia
        file_line = file_line.rsplit()  # con questo comando diventa lista di stringhe
        self.righe_totali = int(file_line[1])
        # ATTRIBUTO colonne_totali (Attributo di Istanza)
        file_line_2 = f.readline()  # generalmente questa seconda riga contiene la larghezza della griglia
        file_line_2 = file_line_2.rsplit()  # con questo comando diventa lista di stringhe
        self.colonne_totali = int(file_line_2[1])
        _ = f.readline()  # non ci interessa, dovrebbe essere 'map\n'

        # ATTRIBUTO matrix (Attributo di Istanza)
        self.matrix = np.zeros(self.righe_totali * self.colonne_totali).reshape(self.righe_totali, self.colonne_totali)
        # since they are zeros, they are considered initially as empty cells

        # da adesso leggo
        # (COSTRUZIONE AGENTI TILES: per ora nella griglia si sta solo considerando
        # la presenza di ostacoli fissi, quindi le tiles sono definite per tutte
        # le altre celle)
        counter = -1
        for aaa in range(0, self.righe_totali):  # conteggio sulle righe
            linea = f.readline()
            linea = linea.rsplit()
            linea_lista = list(linea[0])  # controlla che list non sia stato
            # salvato come un oggetto
            # la dimensione dovrebbe essere 256, oppure 81, ...
            for bbb in range(0, self.colonne_totali):  # conteggio sulle colonne
                if linea_lista[bbb] == '.':  # spazio vuoto
                    counter = counter + 1
                    self.dict_tiles[(aaa, bbb)] = Tile(id=counter, position=[aaa, bbb], occupied=0)
                    # ricorda che la chiave deve essere non lista (quindi ad esempio tupla)
                else:
                    self.Obstacles.append([aaa, bbb])
                    self.matrix[aaa, bbb] = OBSTACLE_CELL
                    # dunque a seconda che il valore in ogni cella della
                    # matrice sia 1 oppure 0 capiamo se ci sono
                    # ostacoli fissi oppure no (ricorda che
                    # non stiamo considerando gli altri agenti)
                    self.dict_tiles[(aaa, bbb)] = None  # nel nostro caso vuol dire che
                    # in corrispondenza di quella tile ci
                    # sono degli ostacoli fissi
        f.close()  # chiusura file

        # Completiamo adesso l'attributo directions di Tiles (per il
        # discorso delle restrizioni su direzioni e versi possibili)
        destra = []
        sinistra = []
        for ggg in range(0, self.righe_totali):
            # se riga pari andiamo verso destra
            if (ggg % 4 == 0 or ggg % 4 == 1):
                destra.append(ggg)
            else:
                sinistra.append(ggg)
        for ccc in range(0, self.righe_totali):
            for ddd in range(0, self.colonne_totali):
                # doppio ciclo for per considerare tutte le tiles
                if self.dict_tiles[(ccc, ddd)] is not None:
                    # la cella che stiamo considerando non è un ostacolo
                    obstacle_in_neighborhood = 0  # QUESTO FLAG CI SERVE PER DECIDERE
                                                  # SE IMPORRE IL FLUSSO O NO SULLA CELLA
                    if (ccc + 1 >= 0) and (ccc + 1 <= self.righe_totali - 1):
                        self.dict_tiles[(ccc, ddd)].directions.append('S')
                        if self.dict_tiles[(ccc + 1, ddd)] is None:
                            # vuol dire che la cella in posizione [ccc+1,ddd] è un ostacolo
                            obstacle_in_neighborhood = 1
                            self.matrix[ccc, ddd] = AROUND_OBSTACLE_CELL
                            self.dict_tiles[(ccc, ddd)].original_color = AROUND_OBSTACLE_CELL
                            # dal momento che non possiamo schiantarci contro un ostacolo
                            # dobbiamo rimuovere la direzione che porta ad esso
                            # in questo caso la direzione da rimuovere è 'S'
                            self.dict_tiles[(ccc,ddd)].directions.remove('S')
                            # (ricorda che sostanzialmente tutta questa costruzione per le
                            # direzioni va a confluire nel calcolo dei vicini per lo
                            # algoritmo A*, e poi solo più nella gestione di conflitti
                            # tra due agenti)

                    if (ccc - 1 >= 0) and (ccc - 1 <= self.righe_totali - 1):
                        self.dict_tiles[(ccc, ddd)].directions.append('N')
                        if self.dict_tiles[(ccc - 1, ddd)] is None:
                            # vuol dire che la cella in posizione [ccc-1,ddd] è un ostacolo
                            obstacle_in_neighborhood = 1
                            self.matrix[ccc, ddd] = AROUND_OBSTACLE_CELL
                            self.dict_tiles[(ccc, ddd)].original_color = AROUND_OBSTACLE_CELL
                            # dal momento che non possiamo schiantarci contro un ostacolo
                            # dobbiamo rimuovere la direzione che porta ad esso
                            # in questo caso la direzione da rimuovere è 'N'
                            self.dict_tiles[(ccc, ddd)].directions.remove('N')
                            # (ricorda che sostanzialmente tutta questa costruzione per le
                            # direzioni va a confluire nel calcolo dei vicini per lo
                            # algoritmo A*, e poi solo più nella gestione di conflitti
                            # tra due agenti)

                    if (ddd + 1 >= 0) and (ddd + 1 <= self.colonne_totali - 1):
                        self.dict_tiles[(ccc, ddd)].directions.append('E')
                        if self.dict_tiles[(ccc, ddd + 1)] is None:
                            # vuol dire che la cella in posizione [ccc,ddd+1] è un ostacolo
                            obstacle_in_neighborhood = 1
                            self.matrix[ccc, ddd] = AROUND_OBSTACLE_CELL
                            self.dict_tiles[(ccc, ddd)].original_color = AROUND_OBSTACLE_CELL
                            # dal momento che non possiamo schiantarci contro un ostacolo
                            # dobbiamo rimuovere la direzione che porta ad esso
                            # in questo caso la direzione da rimuovere è 'E'
                            self.dict_tiles[(ccc, ddd)].directions.remove('E')
                            # (ricorda che sostanzialmente tutta questa costruzione per le
                            # direzioni va a confluire nel calcolo dei vicini per lo
                            # algoritmo A*, e poi solo più nella gestione di conflitti
                            # tra due agenti)

                    if (ddd - 1 >= 0) and (ddd - 1 <= self.colonne_totali - 1):
                        self.dict_tiles[(ccc, ddd)].directions.append('W')
                        if self.dict_tiles[(ccc, ddd - 1)] is None:
                            # vuol dire che la cella in posizione [ccc,ddd-1] è un ostacolo
                            obstacle_in_neighborhood = 1
                            self.matrix[ccc, ddd] = AROUND_OBSTACLE_CELL
                            self.dict_tiles[(ccc, ddd)].original_color = AROUND_OBSTACLE_CELL
                            # dal momento che non possiamo schiantarci contro un ostacolo
                            # dobbiamo rimuovere la direzione che porta ad esso
                            # in questo caso la direzione da rimuovere è 'W'
                            self.dict_tiles[(ccc, ddd)].directions.remove('W')
                            # (ricorda che sostanzialmente tutta questa costruzione per le
                            # direzioni va a confluire nel calcolo dei vicini per lo
                            # algoritmo A*, e poi solo più nella gestione di conflitti
                            # tra due agenti)

                    if obstacle_in_neighborhood == 0:  # andiamo a vedere se in direzioni
                        # diagonali ci sono ostacoli; in tal caso imponiamo tutte le
                        # possibili direzioni

                        # N.B.: potremmo pensare che la prossima sequenza di
                        # if, elif, elif, elif, else sia da sostituire con
                        # if, if, if, if, else, e ciò avrebbe senso, ma in
                        # realtà il contenuto dei diversi if, elif è lo stesso
                        # e quindi a noi basta entrare anche solo in uno
                        # di essi. Il fatto che all'interno questi if, elif siano
                        # tutti uguali ci fa capire che ci basta entrare una
                        # volta, non tutte le volte possibili
                        if (ccc - 1 >= 0) and (ccc - 1 <= self.righe_totali - 1) and \
                                (ddd - 1 >= 0) and (ddd - 1 <= self.colonne_totali - 1) and self.dict_tiles[(ccc - 1, ddd - 1)] is None:
                            # vuol dire che la cella in posizione [ccc-1,ddd-1] è un ostacolo
                            obstacle_in_neighborhood = 1
                            self.matrix[ccc, ddd] = AROUND_OBSTACLE_CELL
                            self.dict_tiles[(ccc, ddd)].original_color = AROUND_OBSTACLE_CELL
                        elif (ccc - 1 >= 0) and (ccc - 1 <= self.righe_totali - 1) and \
                                (ddd + 1 >= 0) and (ddd + 1 <= self.colonne_totali - 1) and self.dict_tiles[(ccc - 1, ddd + 1)] is None:
                            # vuol dire che la cella in posizione [ccc-1,ddd+1] è un ostacolo
                            obstacle_in_neighborhood = 1
                            self.matrix[ccc, ddd] = AROUND_OBSTACLE_CELL
                            self.dict_tiles[(ccc, ddd)].original_color = AROUND_OBSTACLE_CELL
                        elif (ccc + 1 >= 0) and (ccc + 1 <= self.righe_totali - 1) and \
                                (ddd - 1 >= 0) and (ddd - 1 <= self.colonne_totali - 1) and self.dict_tiles[(ccc + 1, ddd - 1)] is None:
                            # vuol dire che la cella in posizione [ccc+1,ddd-1] è un ostacolo
                            obstacle_in_neighborhood = 1
                            self.matrix[ccc, ddd] = AROUND_OBSTACLE_CELL
                            self.dict_tiles[(ccc, ddd)].original_color = AROUND_OBSTACLE_CELL
                        elif (ccc + 1 >= 0) and (ccc + 1 <= self.righe_totali - 1) and \
                                (ddd + 1 >= 0) and (ddd + 1 <= self.colonne_totali - 1) and self.dict_tiles[(ccc + 1, ddd + 1)] is None:
                            # vuol dire che la cella in posizione [ccc+1,ddd+1] è un ostacolo
                            obstacle_in_neighborhood = 1
                            self.matrix[ccc, ddd] = AROUND_OBSTACLE_CELL
                            self.dict_tiles[(ccc, ddd)].original_color = AROUND_OBSTACLE_CELL
                        else:  # non ci sono ostacoli nel quadrato intorno (o nella porzione di quadrato
                               # se siamo al bordo della griglia)
                               # l'unica mossa che si può fare è quella orizzontale o verso destra
                               # o verso sinistra


                            if ccc in destra:
                                if 'W' in self.dict_tiles[(ccc, ddd)].directions:
                                    self.dict_tiles[(ccc, ddd)].directions.remove('W')

                                self.matrix[ccc, ddd] = CELL_TO_RIGHT
                                self.dict_tiles[(ccc, ddd)].original_color = CELL_TO_RIGHT

                            else:  # coppia di righe che va verso sinistra
                                if 'E' in self.dict_tiles[(ccc, ddd)].directions:
                                    self.dict_tiles[(ccc, ddd)].directions.remove('E')

                                self.matrix[ccc, ddd] = CELL_TO_LEFT
                                self.dict_tiles[(ccc, ddd)].original_color = CELL_TO_LEFT



    def neighbors(self, cell):
        """
        Method of class taking the cell position
        in the grid as input and giving as output a
        single or a list of neighbors
        :param cell: cell position in the grid (list)
        :return: list of neighbors (list of lists)
        """
        [xx, yy] = cell
        neighbors_list = []  # sarà una lista di liste, dove ogni lista interna corrisponde
        # ad una coppia x,y

        # ricorda che questo ci serve allo interno
        # dello algoritmo A*, che per ora usiamo
        # non considerando gli altri agenti

        # ricorda che la prima cella IN ALTO a sinistra
        # è indicizzata con [0,0]
        if 'N' in self.dict_tiles[(xx, yy)].directions:
            neighbors_list.append([xx - 1, yy])
            # ricorda che xx indica le righe della griglia
        if 'S' in self.dict_tiles[(xx, yy)].directions:
            neighbors_list.append([xx + 1, yy])
            # ricorda che xx indica le righe della griglia
        if 'E' in self.dict_tiles[(xx, yy)].directions:
            neighbors_list.append([xx, yy + 1])
            # ricorda che yy indica le colonne della griglia
        if 'W' in self.dict_tiles[(xx, yy)].directions:
            neighbors_list.append([xx, yy - 1])
            # ricorda che yy indica le colonne della griglia

        return neighbors_list


class Tile:
    """
    Classe rappresentante gli agenti tiles.
    """

    def __init__(self, id, position, occupied):
        """
        Metodo di inizializzazione
        :param id: id della tile (serve per identificarla
                    nella lista)
        :param position: posizione della tile
                    (lista di coordinate x e y)
        :param occupied: flag per indicare se la tile è
                    libera od occupata
        """

        # ATTRIBUTO id (Attributo di Istanza)
        self.id = id  # numero intero

        # ATTRIBUTO position (Attributo di Istanza)
        self.position = position  # lista

        # ATTRIBUTO GOAL (Attributo di Istanza)
        self.occupied = occupied  # booleano 0/1

        # ATTRIBUTO agent_on_tile (Attributo di Istanza)
        self.agent_on_tile = None

        # ATTRIBUTO directions (Attributo di Istanza)
        self.directions = []  # conterrà le stringhe 'N' , 'E', 'S', 'W'

        # ATTRIBUTO original_color (Attributo di Istanza)
        self.original_color = EMPTY_CELL

        # ATTRIBUTO history (Attributo di Istanza)
        #self.history = {'t-3': (0, None), 't-2': (0, None), 't-1': (0, None)}
        # questo attributo (dizionario) contiene le informazioni
        # sui 3 precedenti istanti di tempo: se la cella era occupata
        # e l'id dell'agente che eventualmente la occupava
        # (in particolare i valori sono tuple con due elementi, il
        # primo è 0 oppure 1 per indicare rispettivamente se la cella
        # non era occupata oppure era occupata, mentre il secondo
        # indica l'id dell'agente che eventualmente la occupava, dunque
        # se il primo elemento della tupla è 0 sarà None).
        # N.B.:
        # Dal momento che ci possono essere tiles che contengono
        # ostacoli fissi, cioè tiles che sono ostacoli fissi
        # all'attributo history assegniamo sempre occupato e come
        # id mettiamo None. IN REALTA' QUESTO N.B. NON ENTRA IN
        # GIOCO DAL MOMENTO CHE NON COSTRUIAMO TILES PER GLI OSTACOLI
        # FISSI, MA SEMPLICEMENTE PONIAMO None IL VALORE ASSOCIATO
        # A QUELLA POSIZIONE NEL DIZIONARIO DICT_TILES.


class Mobile_Agent:
    """
    Classe rappresentante gli agenti mobili (skids).
    """

    def __init__(self, id, origin, starting_time, goal, arrived):
        """
        Metodo di inizializzazione
        :param id: id agente
        :param origin: posizione origine dell'agente
                    (lista di coordinate x e y)
        :param starting_time: tempo di inserimento dello
                    agente nel sistema
        :param goal: posizione obiettivo dell'agente
                    (lista di coordinate x e y)
        :param arrived: flag 0/1 per dire se l'agente
                    è arrivato a destinazione
        """

        # ATTRIBUTO ORIGIN (Attributo di Istanza)
        self.id = id

        # ATTRIBUTO ORIGIN (Attributo di Istanza)
        self.origin = origin

        # ATTRIBUTO starting_time (Attributo di Istanza)
        self.starting_time = starting_time

        # ATTRIBUTO GOAL (Attributo di Istanza)
        self.goal = goal

        # ATTRIBUTO POSITION (Attributo di Istanza)
        self.position = origin

        # ATTRIBUTO ARRIVED (Attributo di Istanza)
        self.arrived = arrived  # booleano 0/1

        # ATTRIBUTO PATH (Attributo di Istanza)
        self.path = []  # dalla posizione attuale al goal

        # ATTRIBUTO costo_agente (Attributo di Istanza)
        self.costo_agente = 0  # inizialmente assegniamo valore nullo

        # ATTRIBUTO timestep_agente (Attributo di Istanza)
        self.timestep_agente = 0  # inizialmente assegniamo valore nullo

        # ATTRIBUTO considerato (Attributo di Istanza)
        self.considerato = 0  # ci serve solo per una questione di plottare correttamente

        # ATTRIBUTO in_system (Attributo di Istanza)
        self.in_system = 0  # ci serve per capire se l'agente che abbiamo
        # costruito può essere processato oppure se si trova su una cella attualmente
        # occupata e quindi dobbiamo aspettare prima di poterlo considerare
        # nel sistema a tutti gli effetti
