"""
Modulo creato da Andrea Bertolini. Settembre 2022.
"""


# import modules
import matplotlib.pyplot as plt
import numpy as np
import random
import heapq
import time
import pandas as pd
from matplotlib import colors

random.seed(10)

EMPTY_CELL = 0
OBSTACLE_CELL = 1
START_CELL = 2
GOAL_CELL = 3
MOVE_CELL = 4

# create discrete colormap
cmap = colors.ListedColormap(['white', 'black', 'red', 'green', 'blue'])
bounds = [EMPTY_CELL, OBSTACLE_CELL, START_CELL, GOAL_CELL, MOVE_CELL, MOVE_CELL + 1]
# bounds defines the edges of bins, and data falling within a bin is mapped to the color with the same index
# quindi dovrebbe essere giusto che bounds ha un elemento in più rispetto a cmap
norm = colors.BoundaryNorm(bounds, cmap.N)


def multi_agent_heuristic(vector1, vector2):
    """
    Funzione utilizzata per estrarre una stima della distanza
    necessaria per andare da un nodo del grafo composto alla
    destinazione
    :param vector1: lista di tuple (che indicano le posizioni degli agenti)
    :param vector2: lista di tuple (che indicano le posizioni degli agenti)
    :return: max_estimate
    """

    # A* maintains an open list of vertices v_k to explore. These are
    # sorted based on the sum of the cost of the cheapest path from v_l to v_k
    # and a heuristic cost, which is a lower bound on the
    # cost of any path from v_k to v_f
    (xx1, yy1) = vector1[0]  # Grid Location
    (xx2, yy2) = vector2[0]  # Grid Location
    min_estimate = abs(xx1 - xx2) + abs(yy1 - yy2)
    #SUM = 0
    for index in range(0, len(vector1)):
        (x1, y1) = vector1[index]  # Grid Location
        (x2, y2) = vector2[index]  # Grid Location
        # we compute the Manhattan distance for
        # the single agent (the single position)
        estimate = abs(x1 - x2) + abs(y1 - y2)
        #SUM = SUM + estimate
        if estimate < min_estimate:
            min_estimate = estimate

    #return SUM
    return min_estimate




class PriorityQueue:
    """CLASS FOR PRIORITY QUEUE. A PRIORITY QUEUE ASSOCIATED WITH EACH
    ITEM A NUMBER CALLED PRIORITY. WHEN RETURNING AN ITEM, IT PICKS
    THE ONE WITH LOWEST NUMBER.
    """
    def __init__(self):
        """
        Method for Initialization
        """
        self.elements = []  # List[Tuple]
        # THE ELEMENTS OF THIS PRIORITY QUEUE ARE STORED
        # INSIDE A LIST WHERE EACH ITEM IS A TUPLE OF
        # A PRIORITY AND A LIST CORRESPONDING TO A SET OF NODES (list of tuples)

    def empty(self):
        """
        Method for the class PriorityQueue telling whether the
        priority queue is empty or not
        :return: boolean value 1 if the priority queue is empty
                boolean value 0 if the priority queue is not empty
        """
        return not self.elements


    def put(self, item, priority):
        """
        Method for the class PriorityQueue used to insert
        a new element in the priority queue
        :param item: item to be added in the priority queue
        :param priority: priority value (type float) of the item to be inserted
        """
        # FOR THIS PURPOSE, THE PACKAGE HEAPQ IS USED
        heapq.heappush(self.elements, (priority, item))


    def get(self):
        """
        Method for the class PriorityQueue used to extract the
        item with lowest priority
        :return: item with lowest priority
        """
        return heapq.heappop(self.elements)[1]





# attenzione 65x81 vuol dire 65 colonne e 81 righe
class MAPF_FILE:
    """
    CLASS FOR MAPF STARTING FROM GRID AND SCENARIOS FILES.
    """

    def __init__(self, grid_file, scenarios_file, num_agents_starting):
        """
        Method for Initialization
        :param grid_file: file contenente la struttura della griglia
        :param scenarios_file: file contenente le posizione di partenza ed arrivo degli
                                agenti da inserire nella griglia
        """
        # ATTRIBUTO grid_file (Attributo di Istanza)
        self.grid_file = grid_file

        # ATTRIBUTO scenarios_file (Attributo di Istanza)
        self.scenarios_file = scenarios_file

        # ATTRIBUTO griglia (Attributo di Istanza)
        self.griglia = Grid(self.grid_file)

        # ATTRIBUTO altezza_griglia (Attributo di Istanza)
        self.altezza_griglia = self.griglia.righe_totali  # numero righe

        # ATTRIBUTO larghezza_griglia (Attributo di Istanza)
        self.larghezza_griglia = self.griglia.colonne_totali  # numero colonne

        # ATTRIBUTO dizionario_agenti (Attributo di Istanza)
        self.dizionario_agenti = {}  # la chiave sarà l'ID dell'agente, mentre
        # il valore sarà l'oggetto agente

        # Attributo numero_agenti_considerati (Attributo di Istanza)
        self.num_agents_starting = num_agents_starting  # STIAMO RAGIONANDO NEL CASO OFFLINE, QUINDI
        # QUESTO ATTRIBUTO E' PROPRIO UGUALE AL NUMERO TOTALE DI AGENTI

        # ATTRIBUTO n_TOTAL_agents (Attributo di Istanza)
        self.n_TOTAL_agents = 0

        # ATTRIBUTO list_agents_position (Attributo di Istanza)
        self.dict_agents_position = {}  # la chiave sarà l'ID dell'agente, mentre
        # il valore sarà la posizione attuale

        # ATTRIBUTO somma_totale_timesteps_tutti (Attributo di Istanza)
        self.somma_totale_timesteps_tutti = 0

        # ATTRIBUTO somma_totale_costi_tutti (Attributo di Istanza)
        self.somma_totale_costi_tutti = 0

        # ATTRIBUTO tempo_totale (Attributo di Istanza)
        self.tempo_totale = 0

        # ATTRIBUTO makespan_costo (Attributo di Istanza)
        self.makespan_costo = 0  # costo massimo richiesto da un agente per arrivare
        # a destinazione

        # ATTRIBUTO makespan_timesteps (Attributo di Istanza)
        self.makespan_timesteps = 0  # massimo numero di timesteps richiesti dal sistema
        # per concludere

        # ATTRIBUTO composition_start (Attributo di Istanza)
        self.composition_start = []

        # ATTRIBUTO composition_goal (Attributo di Istanza)
        self.composition_goal = []

        # ATTRIBUTO path (Attributo di Istanza)
        self.path = []

        # COSTRUZIONE AGENTI CART
        self.build_agents_MAPF(self.scenarios_file, self.num_agents_starting)



    def build_agents_MAPF(self, file_agenti, num_agenti_cart):
        """
        Metodo della classe MAPF per costruire
        gli agenti cart
        :param file_agenti: file contenente gli agenti da costruire
        :param num_agenti_cart: numero di agenti da costruire
        """

        g = open(file_agenti, 'r')
        _ = g.readline()  # la prima riga non contiene informazioni interessanti

        # cerchiamo di evitare di dover mettere il seguente comando,
        # detto altrimenti:
        # CONSIDERIAMO MENO DI CIRCA 1000 AGENTI
        #for ppp in range(0, self.n_TOTAL_agents):
        #    content = g.readline()  # così non devo ricontare gli stessi agenti ogni volta
        #    if not content:  # è finito il file --> ricominciamo a leggerlo
        #        g.close()
        #        print(
        #            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")
        #        g = open(file_agenti, 'r')
        #        _ = g.readline()  # la prima riga non contiene informazioni interessanti
        #        content = g.readline()  # in un certo senso recuperiamo quella riga che era diventata vuota


        for qqq in range(0, num_agenti_cart):  # 950 = numero massimo di agenti nel file
            linea = g.readline()
            # cerchiamo di evitare di dover mettere il seguente comando,
            # detto altrimenti:
            # CONSIDERIAMO MENO DI CIRCA 1000 AGENTI
            #if not linea:  # è finito il file --> ricominciamo a leggerlo
            #    g.close()
            #    print(
            #        "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")
            #    g = open(file_agenti, 'r')
            #    _ = g.readline()  # la prima riga non contiene informazioni interessanti
            #    linea = g.readline()  # in un certo senso recuperiamo quella riga che era diventata vuota

            linea = linea.rsplit()
            origin_y = int(linea[4])  # colonne
            origin_x = int(linea[5])  # righe
            goal_y = int(linea[6])  # colonne
            goal_x = int(linea[7])  # righe
            numero = float(linea[8])

            # COSTRUZIONE AGENTI CART
            self.dizionario_agenti[(self.n_TOTAL_agents)] = Mobile_Agent(id=self.n_TOTAL_agents,
                                                                         origin=[origin_x, origin_y],
                                                                         goal=[goal_x, goal_y], arrived=0)
            # nella linea di codice precedente abbiamo posto come chiave l'id dell'agente mobile
            # e come valore l'oggetto Mobile_Agent associato

            self.composition_start.append((origin_x, origin_y))
            self.composition_goal.append((goal_x, goal_y))

            self.griglia.dict_tiles[(origin_x, origin_y)].occupied = 1
            # il seguente comando ci potrebbe servire
            # per il plot
            self.griglia.matrix[origin_x, origin_y] = START_CELL
            self.griglia.dict_tiles[(origin_x, origin_y)].original_color = START_CELL
            if self.griglia.dict_tiles[(goal_x, goal_y)].occupied == 0:
                # attenzione che questo va a modificare la griglia
                self.griglia.matrix[goal_x, goal_y] = GOAL_CELL
                # in caso contrario vuol dire che c'è un agente in quella posizione
                # e visto che questo agente prima o poi lascerà la posizione, possiamo
                # imporre che il nuovo colore originale sia proprio quello di una cella goal
                # che specifichiamo alla riga qui sotto
            self.griglia.dict_tiles[(goal_x, goal_y)].original_color = GOAL_CELL

            self.n_TOTAL_agents = self.n_TOTAL_agents + 1  # incrementiamo il numero totale di agenti nel sistema
            # alla fine numero_agenti_considerati dovrebbe essere uguale a n_TOTAL_agents

        g.close()
        print(self.composition_goal)
        print(self.composition_start)

    def solve_MAPF(self, plot):
        """
        Metodo della classe MAPF utilizzato per
        risolvere il problema di planning
        :param plot: booleano per indicare se si vuole
                    considerare una rappresentazione grafica (1)
                    oppure no (0)
        :return: se plot = 1 restituisce la sequenza di plot.
        """

        # ORA INIZIA L'ALGORITMO
        if plot == 1:
            fig = plt.figure()
            ax = plt.axes()
            # we build our window
            ax.imshow(self.griglia.matrix, cmap=cmap, norm=norm)
            # ax.imshow(self.griglia.matrix, cmap=cmap)
            # with this command we display data as an image, i.e.,
            # on a 2D regular raster.
            # let's draw gridlines
            ax.grid(which='major', axis='both', linestyle='-', color='k', linewidth=1)
            ax.set_xticks(np.arange(0.5, self.larghezza_griglia, 1))
            ax.set_yticks(np.arange(0.5, self.altezza_griglia, 1))
            plt.tick_params(axis='both', which='both', bottom=False,
                            left=False, labelbottom=False,
                            labelleft=False)
            # fig.set_size_inches((8.5, 11), forward=False)
            stringa_titolo = 'Astar_{}.png'
            stringa_titolo_completo = stringa_titolo.format(-1)
            plt.savefig(stringa_titolo_completo)
            plt.pause(1)

        start_time_python = time.time()
        # RISOLUZIONE DEL PROBLEMA DA UN PUNTO DI VISTA CENTRALIZZATO
        came_from_bis, cost_so_far_bis = self.multi_a_star(self.composition_start,
                                                       self.composition_goal)

        stop_time_python = time.time()
        stop_tempo_intermedio = stop_time_python - start_time_python
        print("tutti gli agenti sono arrivati: tempo ", stop_tempo_intermedio)  # corrisponde in sostanza
        # al total travel time del sistema implementato in python, mentre il total travel time
        # in termini di timesteps potrebbe essere ambiguo dal momento che
        # stiamo ragionando in maniera online
        came_from = came_from_bis.copy()
        cost_so_far = cost_so_far_bis.copy()
        # the code to reconstruct the path is simple:
        # follow the arrows backwards from the goal to
        # the start. A path is a sequence of edges,
        # but often it's easier to store the nodes.
        cammino = []
        corrente = self.composition_goal  # lista fatta di tuple
        while corrente != self.composition_start.copy():
            cammino.append(corrente)
            corrente = came_from[tuple(corrente)]  # corrente a primo membro è una tupla
            # per costruzione di came_from (dizionario)
            # ricorda came_from[next] = current
            corrente = list(corrente)  # ritrasformo in lista

        cammino.append(self.composition_start.copy())
        # nota che cammino non ha la posizione attuale
        cammino.reverse()

        self.path = cammino.copy()  # CONTROLLA CHE CI SIA ANCHE LA POSIZIONE INIZIALE
        print(self.composition_start)
        print(self.path)
        print(self.composition_goal)
        self.makespan_timesteps = len(self.path) - 1  # perchè partiamo dalla posizione iniziale
        print(self.makespan_timesteps)
        # now we compute the individual paths
        for www in range(0, len(self.dizionario_agenti)):
            for yyy in range(0, len(self.path)):
                vettore_con_indice_di_tempo = self.path[(yyy)]  # lista di tuple
                self.dizionario_agenti[(www)].path.append(vettore_con_indice_di_tempo[(www)])
                #print('cammino:')
                #print(self.dizionario_agenti[(www)].path)

            print(self.dizionario_agenti[(www)].path[len(self.dizionario_agenti[(www)].path) - 1])
            print(self.dizionario_agenti[(www)].goal)
            while self.dizionario_agenti[(www)].path[len(self.dizionario_agenti[(www)].path)-1] == \
                tuple(self.dizionario_agenti[(www)].goal):
                self.dizionario_agenti[(www)].path.pop()
            self.dizionario_agenti[(www)].path.append(self.dizionario_agenti[(www)].goal)
            self.dizionario_agenti[(www)].timestep_agente = len(self.dizionario_agenti[(www)].path) - 1


        if plot == 1:
            for qqq in range(1, self.makespan_timesteps+1):
                for www in range(0, len(self.dizionario_agenti)):
                    (posizione_x_PREC, posizione_y_PREC) = self.path[qqq - 1][(www)]
                    self.griglia.dict_tiles[(posizione_x_PREC, posizione_y_PREC)].occupied = 0
                    self.griglia.matrix[posizione_x_PREC, posizione_y_PREC] = \
                        self.griglia.dict_tiles[(posizione_x_PREC, posizione_y_PREC)].original_color
                for www in range(0, len(self.dizionario_agenti)):
                    (posizione_x, posizione_y) = self.path[qqq][(www)]
                    self.griglia.dict_tiles[(posizione_x, posizione_y)].occupied = 1
                    self.griglia.matrix[posizione_x, posizione_y] = MOVE_CELL

                # we build our window
                ax = plt.axes()
                ax.imshow(self.griglia.matrix, cmap=cmap, norm=norm)
                # ax.imshow(self.griglia.matrix, cmap=cmap)
                # with this command we display data as an image, i.e.,
                # on a 2D regular raster.
                # let's draw gridlines
                ax.grid(which='major', axis='both', linestyle='-', color='k', linewidth=1)
                ax.set_xticks(np.arange(0.5, self.larghezza_griglia, 1))
                ax.set_yticks(np.arange(0.5, self.altezza_griglia, 1))
                plt.tick_params(axis='both', which='both', bottom=False,
                                left=False, labelbottom=False,
                                labelleft=False)
                # fig.set_size_inches((8.5, 11), forward=False)
                # plt.savefig(saveImageName + ".png", dpi=500)
                stringa_titolo_completo = stringa_titolo.format(qqq)
                plt.savefig(stringa_titolo_completo)
                plt.pause(1)


        max_timestep = 0
        max_timestep_id = None
        somma_totale_timesteps_tutti = 0
        for sss in range(0, len(self.dizionario_agenti)):
            agente_considerato = self.dizionario_agenti[(sss)]
            print("timesteps per agente ", agente_considerato.id, " : ", agente_considerato.timestep_agente)
            somma_totale_timesteps_tutti = somma_totale_timesteps_tutti + agente_considerato.timestep_agente
            if agente_considerato.timestep_agente > max_timestep:
                max_timestep = agente_considerato.timestep_agente
                max_timestep_id = agente_considerato.id
        print("max timestep: agente ", max_timestep_id, " : ", max_timestep)

        self.somma_totale_timesteps_tutti = somma_totale_timesteps_tutti
        self.tempo_totale = stop_tempo_intermedio
        print("somma timesteps (sum of costs): ", somma_totale_timesteps_tutti)


    def multi_a_star(self, start_vector, goal_vector):
        """
            Funzione che implementa la ricerca A* per lo shortest path
            nel caso multi-agenti
            :param start_vector: posizione di partenza (lista di tuple)
            :param goal_vector: posizione di arrivo (lista di tuple)
            :return: si ritornano dei dizionari che sono
                    came_from (descrive in sostanza il
                     percorso all'indietro) e cost_so_far (dice il
                     costo dello shortest path dalla partenza fino
                     ad un nodo specifico)
        """

        frontier = PriorityQueue()
        frontier.put(start_vector, 0)
        # all'inizio la frontiera è fatta dal solo nodo
        # di partenza (che è una lista (di tuple))
        came_from = {}  # LE CHIAVI DEVONO ESSERE TUPLE E I VALORI ANCHE
        # con il comando sopra vogliamo tenere conto delle
        # posizioni precedenti a quelle raggiunte (che sono le
        # chiavi del dizionario).
        cost_so_far = {}
        # THE ABOVE VARIABLE IS USED TO TAKE THE MOVEMENT
        # COSTS INTO ACCOUNT WHEN DECIDING HOW TO EVALUATE
        # LOCATIONS
        # inizializzazione
        came_from[tuple(start_vector)] = None
        cost_so_far[tuple(start_vector)] = 0  # in quanto dizionario, cost_so_far deve
        # avere almeno delle tuple come chiavi

        while not frontier.empty():
            # prendiamo una cella e la rimuoviamo dalla frontiera
            current = frontier.get()  # current dovrebbe essere una lista di Tuple
            #print('current: ', current)

            if current == goal_vector:  # entrambe liste di tuple
                break  # ci fermiamo se siamo arrivati alla fine

            for next in self.composite_neighbors(current):  # next dovrebbe essere una lista di Tuple
                # CALCOLIAMO IL NUOVO COSTO
                new_cost = cost_so_far[tuple(current)] + 1
                # di fatto è una ricerca su grafo, quindi passare
                # da un nodo ad altro in un grafo con nodi composti
                # di nodi può essere ragionevolmente fatto con
                # costo 1 (inoltre la nostra euristica
                # non crea problemi, è in accordo con questa scelta)
                if tuple(next) not in cost_so_far or new_cost < cost_so_far[tuple(next)]:
                    # mentre con new cost abbiamo solo calcolato qual è
                    # il costo nuovo movendosi in un vicino, ora decidiamo
                    # se metterlo in cost so far e sostanzialmente lo mettiamo
                    # se non abbiamo ancora una chiave next, oppure se
                    # questo nuovo costo è migliore per il nodo next
                    cost_so_far[tuple(next)] = new_cost
                    priority = new_cost + multi_agent_heuristic(next, goal_vector)
                    # qui entra in gioco l'euristica e si ha la vera
                    # differenza fondamentale con lo algoritmo di
                    # DIJKSTRA, infatti in DIJKSTRA la frontiera si
                    # espande in tutte le direzioni. Questa è una scelta
                    # ragionevole se stiamo cercando di trovare un cammino
                    # verso tutte le altre o quasi tutte le posizioni.
                    # Tuttavia, generalmente vogliamo trovare un cammino
                    # verso una sola locazione. Quindi in sostanza vogliamo
                    # far espandere la frontiera verso il goal più che verso
                    # le altre direzioni. Per farlo ci serviamo del concetto
                    # di funzione euristica, che ci dice quanto siamo vicini
                    # al goal.
                    frontier.put(next, priority)
                    # ricorda che una priority queue associa ad ogni
                    # item un numero chiamato priority. Quando deve
                    # essere ritornato un item, prende quello
                    # con priority minore
                    # NEXT è UNA LISTA DI [TUPLE] CHE INDICANO POSIZIONI
                    came_from[tuple(next)] = tuple(current)  # perchè, in base alla
                    # condizione nell'if, se non avevamo ancora
                    # visitato quel nodo (next) allora dobbiamo
                    # specificare da dove arriva, mentre se
                    # lo avevamo visitato e abbiamo trovato un cammino
                    # dalla partenza fino a lui che costa meno di quello
                    # che avevamo, modifichiamo il suo came_from.

        return came_from, cost_so_far


    def composite_neighbors(self, cell):
        # la cella è intesa qui come una lista di posizioni (lista di tuple)
        composite_neighbors_list = []
        for j in range(0, len(cell)):  # ciclo su ogni agente
            nodo_tupla = cell[j]  # non c'è copy perchè è una tuple
            # nodo_tupla corrisponde ad una posizione nella griglia
            # bidimensionale, dovrebbe essere espresso come Tupla
            neighbors_list_for_nodo_tupla = []
            neighbors_list_for_nodo_tupla = self.griglia.neighbors(nodo_tupla).copy() # sarà una lista di tuple
            # dove ogni tupla è un vicino nella griglia 2D
            neighbors_list_for_nodo_tupla.append(nodo_tupla)  # ci serve per garantire la
            # possibilità che uno degli agenti resti fermo
            #print(neighbors_list_for_nodo_tupla)

            if composite_neighbors_list != []:  # cioè se abbiamo già processato degli agenti
                composite_neighbors_list_2 = []
                lunghezza = len(composite_neighbors_list)
                for i in range(0, lunghezza):
                    for jjjj in range(0, len(neighbors_list_for_nodo_tupla)):
                        oggetto = composite_neighbors_list[i].copy()
                        # sto prendendo l'i-esima lista di posizioni tuple di
                        # agenti fino all'agente i
                        oggetto_nuovo = neighbors_list_for_nodo_tupla[jjjj]  # sarebbe tupla
                        oggetto.append(oggetto_nuovo)  # stiamo aggiungendo ad una lista di tuple una
                        # nuova tupla. Qui sono tuple, non [tuple]
                        composite_neighbors_list_2.append(oggetto)
                composite_neighbors_list = composite_neighbors_list_2.copy()
            else:  # siamo all'inizio
                for jbis in range(0, len(neighbors_list_for_nodo_tupla)):
                    oggetto_nuovo_bis = neighbors_list_for_nodo_tupla[jbis]  # sarebbe tupla
                    composite_neighbors_list.append([oggetto_nuovo_bis])

            k = 0
            while k < len(composite_neighbors_list):
                print(len(composite_neighbors_list))
                print('k:', k)
                for posizione_singolo_agente in composite_neighbors_list[k]:
                    if composite_neighbors_list[k].count(posizione_singolo_agente) > 1:
                        composite_neighbors_list.remove(composite_neighbors_list[k])  # scartiamo tutta la lista
                k = k + 1


        #print(composite_neighbors_list)
        return composite_neighbors_list



class Grid:
    """
    Classe per la griglia.
    """

    def __init__(self, file_griglia):
        """
        Method for Initialization.
        :param file_griglia: file containing grid information
        """
        # ATTRIBUTO file_griglia (Attributo di Istanza)
        self.file_griglia = file_griglia

        # ATTRIBUTO dict_tiles (Attributo di Istanza)
        self.dict_tiles = {}  # INSERIREMO GLI OGGETTI TILES

        # ATTRIBUTO Obstacles (Attributo di Istanza)
        self.Obstacles = []  # lista di coppie x,y

        f = open(self.file_griglia, 'r')
        # ATTRIBUTO righe_totali (Attributo di Istanza)
        _ = f.readline()  # la prima riga non ci interessa, dovrebbe essere 'type octile\n'
        file_line = f.readline()  # generalmente questa seconda riga contiene la altezza della griglia
        file_line = file_line.rsplit()  # con questo comando diventa lista di stringhe
        self.righe_totali = int(file_line[1])
        # ATTRIBUTO colonne_totali (Attributo di Istanza)
        file_line_2 = f.readline()  # generalmente questa seconda riga contiene la larghezza della griglia
        file_line_2 = file_line_2.rsplit()  # con questo comando diventa lista di stringhe
        self.colonne_totali = int(file_line_2[1])
        _ = f.readline()  # non ci interessa, dovrebbe essere 'map\n'

        # ATTRIBUTO matrix (Attributo di Istanza)
        self.matrix = np.zeros(self.righe_totali * self.colonne_totali).reshape(self.righe_totali, self.colonne_totali)
        # since they are zeros, they are considered initially as empty cells

        # da adesso leggo
        # (COSTRUZIONE AGENTI TILES: per ora nella griglia si sta solo considerando
        # la presenza di ostacoli fissi, quindi le tiles sono definite per tutte
        # le altre celle)
        counter = -1
        for aaa in range(0, self.righe_totali):  # conteggio sulle righe
            linea = f.readline()
            linea = linea.rsplit()
            linea_lista = list(linea[0])  # controlla che list non sia stato
            # salvato come un oggetto
            # la dimensione dovrebbe essere 256, oppure 81, ...
            for bbb in range(0, self.colonne_totali):  # conteggio sulle colonne
                if linea_lista[bbb] == '.':  # spazio vuoto
                    counter = counter + 1
                    self.dict_tiles[(aaa, bbb)] = Tile(id=counter, position=[aaa, bbb], occupied=0)
                    # ricorda che la chiave deve essere non lista (quindi ad esempio tupla)
                else:
                    self.Obstacles.append([aaa, bbb])
                    self.matrix[aaa, bbb] = OBSTACLE_CELL
                    # dunque a seconda che il valore in ogni cella della
                    # matrice sia 1 oppure 0 capiamo se ci sono
                    # ostacoli fissi oppure no (ricorda che
                    # non stiamo considerando gli altri agenti)
                    self.dict_tiles[(aaa, bbb)] = None  # nel nostro caso vuol dire che
                    # in corrispondenza di quella tile ci
                    # sono degli ostacoli fissi
        f.close()  # chiusura file


    def neighbors(self, cell):
        """
        Method of class taking the cell position
        in the grid as input and giving as output a
        single or a list of neighbors
        :param cell: cell position in the grid (tuple)
        :return: list of neighbors (list of tuple)
        """
        [xx, yy] = cell
        neighbors_list = []  # sarà una lista di tuple, dove ogni tupla corrisponde
        # ad una coppia (x,y)

        # ricorda che questo ci serve allo interno
        # dello algoritmo A*, che per ora usiamo
        # non considerando gli altri agenti
        if (xx + 1 >= 0) and (xx + 1 <= self.righe_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix[xx + 1, yy] != OBSTACLE_CELL:
                neighbors_list.append((xx + 1, yy))
        if (xx - 1 >= 0) and (xx - 1 <= self.righe_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix[xx - 1, yy] != OBSTACLE_CELL:
                neighbors_list.append((xx - 1, yy))
        if (yy - 1 >= 0) and (yy - 1 <= self.colonne_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix[xx, yy - 1] != OBSTACLE_CELL:
                neighbors_list.append((xx, yy - 1))
        if (yy + 1 >= 0) and (yy + 1 <= self.colonne_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix[xx, yy + 1] != OBSTACLE_CELL:
                neighbors_list.append((xx, yy + 1))

        return neighbors_list


class Tile:
    """
    Classe rappresentante gli agenti tiles.
    """

    def __init__(self, id, position, occupied):
        """
        Metodo di inizializzazione
        :param id: id della tile (serve per identificarla
                    nella lista)
        :param position: posizione della tile
                    (lista di coordinate x e y)
        :param occupied: flag per indicare se la tile è
                    libera od occupata
        """

        # ATTRIBUTO id (Attributo di Istanza)
        self.id = id  # numero intero

        # ATTRIBUTO position (Attributo di Istanza)
        self.position = position  # lista

        # ATTRIBUTO GOAL (Attributo di Istanza)
        self.occupied = occupied  # booleano 0/1

        # ATTRIBUTO agent_on_tile (Attributo di Istanza)
        self.agent_on_tile = None

        # ATTRIBUTO original_color (Attributo di Istanza)
        self.original_color = EMPTY_CELL



class Mobile_Agent:
    """
    Classe rappresentante gli agenti mobili (skids).
    """

    def __init__(self, id, origin, goal, arrived):
        """
        Metodo di inizializzazione
        :param id: id agente
        :param origin: posizione origine dell'agente
                    (lista di coordinate x e y)
        :param goal: posizione obiettivo dell'agente
                    (lista di coordinate x e y)
        :param arrived: flag 0/1 per dire se l'agente
                    è arrivato a destinazione
        """

        # ATTRIBUTO ORIGIN (Attributo di Istanza)
        self.id = id

        # ATTRIBUTO ORIGIN (Attributo di Istanza)
        self.origin = origin

        # ATTRIBUTO GOAL (Attributo di Istanza)
        self.goal = goal

        # ATTRIBUTO POSITION (Attributo di Istanza)
        self.position = origin

        # ATTRIBUTO ARRIVED (Attributo di Istanza)
        self.arrived = arrived  # booleano 0/1

        # ATTRIBUTO PATH (Attributo di Istanza)
        self.path = []  # dalla posizione attuale al goal

        # ATTRIBUTO costo_agente (Attributo di Istanza)
        self.costo_agente = 0  # inizialmente assegniamo valore nullo

        # ATTRIBUTO timestep_agente (Attributo di Istanza)
        self.timestep_agente = 0  # inizialmente assegniamo valore nullo

        # ATTRIBUTO considerato (Attributo di Istanza)
        self.considerato = 0  # ci serve solo per una questione di plottare correttamente

        # ATTRIBUTO in_system (Attributo di Istanza)
        self.in_system = 0  # ci serve per capire se l'agente che abbiamo
        # costruito può essere processato oppure se si trova su una cella attualmente
        # occupata e quindi dobbiamo aspettare prima di poterlo considerare
        # nel sistema a tutti gli effetti
