"""
Modulo creato da Andrea Bertolini. Settembre 2022.
"""

# PERCHE' FUNZIONI, DOBBIAMO
# CONSIDERARE MENO DI CIRCA
# 1000 AGENTI

# Questo modulo contiene l'implementazione di HCA*
# NON STIAMO CONSIDERANDO UN ADATTAMENTO ONLINE, QUINDI IN TEORIA POTREMMO MIGLIORARE QUESTO
# ALGORITMO ULTERIORMENTE FACENDO USO DI ASSEGNAZIONI APPROPRIATE DI PRIORITA'

# To tackle the cooperative pathfinding problem, the search
# algorithm needs to have full knowledge of both obstacles and units. However,
# when units move around there is no satisfactory way to represent their
# routes on a stationary map. To overcome this problem,
# we extend the map to include a third dimension: time. We
# will call the original map the space map and the new, extended map the space-time map.

# A* search can now be used on the space-time map.

# Once a unit has chosen a path, it needs to make sure that other units know to avoid the cells along its path.
# This is achieved by marking each cell into a reservation table. This is
# a straightforward data structure containing an entry for every cell of the space-time map. Each
# entry specifies whether the corresponding cell is available or reserved. Once an entry is
# reserved, it is illegal for any other unit to move into that cell. The reservation acts like a
# transient obstacle.
# Note, this way of using the reservation table doesn't prevent two units crossing
# through each other, head to head. Despite this, in our implementation
# head-to-head collisions won't be possible since we have a for cylce which
# guarantees a consecutive process of the agents (no
# agents can plan at the same time)


# import modules
import matplotlib.pyplot as plt
import numpy as np
import random
import heapq
import time
from matplotlib import colors

random.seed(10)

# grid_file = 'Boston_0_256.map'
# scenarios_file = 'Boston_0_256-even-1.scen'
# scenarios_file = 'Boston_0_256-random-1.scen'
# grid_file = 'den312d.map'
# scenarios_file = 'den312d-even-1.scen'
# scenarios_file = 'den312d-random-1.scen'

EMPTY_CELL = 0
OBSTACLE_CELL = 1  # da non cambiare
START_CELL = 2
GOAL_CELL = 3
MOVE_CELL = 4


# create discrete colormap
cmap = colors.ListedColormap(['white', 'black', 'red', 'green', 'blue'])
bounds = [EMPTY_CELL, OBSTACLE_CELL, START_CELL, GOAL_CELL, MOVE_CELL, MOVE_CELL + 1]
# bounds defines the edges of bins, and data falling within a bin is mapped to the color with the same index
# quindi dovrebbe essere giusto che bounds ha un elemento in più rispetto a cmap
norm = colors.BoundaryNorm(bounds, cmap.N)






def Manhattan_heuristic(a, b):
    (x1, y1) = a  # GridLocation
    (x2, y2) = b  # GridLocation
    return abs(x1 - x2) + abs(y1 - y2)
# NOTE: THE PERFORMANCE OF A* DEPENDS UPON THE CHOICE OF HEURISTIC. WITH
# THE SEARCH SPACE EXTENDED BY AN EXTRA DIMENSION, THE CHOICE OF
# HEURISTIC BECOMES EVEN MORE IMPORTANT. FOR GRID-BASED MAPS, THE MANHATTAN
# DISTANCE IS OFTEN USED AS A HEURISTIC. IT IS SIMPLY THE SUM
# OF THE X AND Y DISTANCES TO THE DESTINATION. HOWEVER, IF THE SHORTEST
# PATH TO THE DESTINATION IS CIRCUITOUS, THEN THE MANHATTAN DISTANCE BECOMES
# A POOR ESTIMATE. AS A CONSEQUENCE, USING THE MANHATTAN DISTANCE HEURISTIC,
# MANY LOCATIONS ON THE MAP CAN HAVE AN F VALUE THAT IS LESS THAN THE TRUE DISTANCE
# TO THE DESTINATION. AS A CONSEQUENCE, ALMOST THE ENTIRE MAP COULD BE EXPLORED BEFORE
# THE DESTINATION IS FOUND, A PHENOMENON KNOWN AS FLOODING.
# BY CONSIDERING THE MANHATTAN DISTANCE IN A SPACE-TIME MAP, WE FIND
# THE PROBLEM IS EVEN MAGNIFIED MANY TIMES.

# SO IT'S CLEAR THAT WE NEED A MORE ACCURATE HEURISTIC FOR SEARCHING SPACE-TIME.
# THE TRUE DISTANCE HEURISTIC, I.E. THE SHORTEST DISTANCE TO THE
# DESTINATION, TAKING ACCOUNT OF OBSTACLES, BUT IGNORING UNITS, IS THE SOLUTION.
# THE TRUE DISTANCE HEURISTIC SUBSTANTIALLY MEASURES THE PATH THAT
# A "NORMAL" PATHFINDING ALGORITHM WOULD FIND TO THE DESTINATION.

# THE HEURISTIC IS REQUIRED AT EVERY LOCATION EXPLORED BY SPACE-TIME A*. IF WE
# NAIVELY EXECUTE SPATIAL A* FROM EACH LOCATION, THIS WILL BE EVEN
# SLOWER THAN USING A POOR HEURISTIC.
# TO EFFICIENTLY CALCULATE THE TRUE DISTANCE HEURISTIC, WE MUST MAKE A
# REVERSE FLIP AND IMAGINE WHAT HAPPENS IF SPATIAL A* IS RUN BACKWARDS.

# IN PRACTICE, WE RUN TWO SEARCHES SIDE BY SIDE. PATHFINDING IS PERFORMED BY THE MAIN SEARCH, USING
# SPACE-TIME A*. AT EACH LOCATION EXPLORED BY THE MAIN SEARCH, THE TRUE DISTANCE HEURISTIC IS
# REQUESTED. THIS IS WHERE THE AUXILIARY SEARCH COMES IN, USING
# BACKWARDS SPATIAL A*. IF THE LOCATION IS ALREADY ON THE CLOSED LIST, ITS
# g VALUE IS RETURNED IMMEDIATELY, OTHERWISE, THE BACKWARDS SEARCH IS RESUMED
# UNTIL THE REQUESTED LOCATION IS PUT ONTO THE CLOSED LIST,
# AT WHICH POINT ITS g VALUE IS RETURNED.
# (Recall, during A* search, new locations are kept on the open list and explored
# locations are kept on the closed list. At each step, the most promising location is
# selected from the open list according to its f value. The f value estimates the total
# distance to the destination, passing through that location. It is
# the sum of g, the distance traveled by A* to reach the location,
# and h, the heuristic distance from the location to the distance)

### To ease the implementation, we will apply Dijkstra Algorithm once for all the future cases in which we
### want to understand the true distance from the destination


def initialize_RRA_star(spatial_graph, start2D, goal2D):
    # attenzione che in questo caso procediamo da goal a start, non viceversa come
    # facciamo normalmente con A*

    # QUI RAGIONIAMO IN 2D

    frontier_reversable_Astar = PriorityQueue()  # gli items in questa priority queue sono liste
    frontier_reversable_Astar.put(goal2D, 0)
    # all'inizio la frontiera è fatta dal solo punto
    # di partenza (DI ARRIVO perchè inverso A*) (che è una lista)
    came_from_reversable_Astar = {}  # LE CHIAVI DEVONO ESSERE TUPLE E I VALORI ANCHE
    # con il comando sopra vogliamo tenere conto delle
    # posizioni precedenti a quelle raggiunte (che sono le
    # chiavi del dizionario).
    cost_so_far_reversable_Astar = {}
    # THE ABOVE VARIABLE IS USED TO TAKE THE MOVEMENT
    # COSTS INTO ACCOUNT WHEN DECIDING HOW TO EVALUATE
    # LOCATIONS
    # inizializzazione
    came_from_reversable_Astar[tuple(goal2D)] = None
    cost_so_far_reversable_Astar[tuple(goal2D)] = 0  # in quanto dizionario, cost_so_far deve
    # avere almeno delle tuple come chiavi

    came_from_reversable_Astar_bis, cost_so_far_reversable_Astar_bis, frontier_reversable_Astar_bis = resume_RRAstar(spatial_graph, start2D,
                                                                                             came_from_reversable_Astar,
                                                                                             cost_so_far_reversable_Astar,
                                                                                             frontier_reversable_Astar, start2D)
    came_from_reversable_Astar = came_from_reversable_Astar_bis.copy()
    cost_so_far_reversable_Astar = cost_so_far_reversable_Astar_bis.copy()
    frontier_reversable_Astar = frontier_reversable_Astar_bis

    return came_from_reversable_Astar, cost_so_far_reversable_Astar, frontier_reversable_Astar



# nella funzione di seguito non stiamo considerando gli altri agenti, infatti questa funzione
# ci serve solo per estrarre la euristica
# QUI RAGIONIAMO IN 2D
def resume_RRAstar(spatial_graph, node_2D_to_be_found, came_from_RRA_star_resume, cost_so_far_RRA_star_resume, frontier_RRA_resume, start2D_resume):

    while not frontier_RRA_resume.empty():
        # prendiamo una cella e la rimuoviamo dalla frontiera
        current_resume = frontier_RRA_resume.get()  # current dovrebbe essere una lista
        if current_resume == node_2D_to_be_found:
            # ha senso che lo rimettiamo nella frontiera, per gli eventuali futuri usi di rra*
            frontier_RRA_resume.put(current_resume, cost_so_far_RRA_star_resume[tuple(current_resume)])
            return came_from_RRA_star_resume, cost_so_far_RRA_star_resume, frontier_RRA_resume

        for next_resume in spatial_graph.neighbors(current_resume):  # next dovrebbe essere una lista
            # CALCOLIAMO IL NUOVO COSTO
            new_cost_resume = cost_so_far_RRA_star_resume[tuple(current_resume)] + 1  # in implementazione alternativa
                                            # potremmo voler mettere pesi
                                            # diversi
            # dall'argomento del seguente if capiamo facilmente che andremo a visitare tutti
            # gli elementi della griglia
            if tuple(next_resume) not in cost_so_far_RRA_star_resume or new_cost_resume < cost_so_far_RRA_star_resume[tuple(next_resume)]:
                # mentre con new cost abbiamo solo calcolato qual è
                # il costo nuovo movendosi in un vicino, ora decidiamo
                # se metterlo in cost so far e sostanzialmente lo mettiamo
                # se non abbiamo ancora una chiave next, oppure se
                # questo nuovo costo è migliore per il nodo next
                cost_so_far_RRA_star_resume[tuple(next_resume)] = new_cost_resume
                priority_resume = new_cost_resume + Manhattan_heuristic(next_resume, start2D_resume)
                frontier_RRA_resume.put(next_resume, priority_resume)
                # ricorda che una priority queue associa ad ogni
                # item un numero chiamato priority. Quando deve
                # essere ritornato un item, prende quello
                # con priority minore
                came_from_RRA_star_resume[tuple(next_resume)] = tuple(current_resume) #perchè, in base alla
                # condizione nell'if, se non avevamo ancora
                # visitato quel nodo (next) allora dobbiamo
                # specificare da dove arriva, mentre se
                # lo avevamo visitato e abbiamo trovato un cammino
                # dalla partenza fino a lui che costa meno di quello
                # che avevamo, modifichiamo il suo came_from.

    #print(cost_so_far_RRA_star_resume.keys())
    #print(len(cost_so_far_RRA_star_resume.keys()))
    #print('nodo cercato', node_2D_to_be_found)
    raise Exception('Non è stato possibile espandere il nodo cercato.')





# la seguente funzione ci serve per determinare il cammino minimo del generico agente
# dalla propria origine alla propria destinazione tenendo conto che nella griglia
# spazio-temporale ci stanno sia gli ostacoli fissi, sia quelli mobili (cioè i cammini degli
# agenti precedentemente processati)
# utilizza anche la funzione precedentemente definita che applica l'algoritmo di Dijkstra
def Spatio_Temporal_A_star_search(spatio_temporal_graph, spatial_graph, start2D, goal2D):
    """
    Funzione che implementa la ricerca A* per lo shortest path in griglia spazio-tempo-dimensionale
    :param spatio_temporal_graph: oggetto su cui si effettua la ricerca
    :param spatial_graph: oggetto su cui si effettua la ricerca
    :param start2D: posizione di partenza
    :param goal2D: posizione di arrivo
    :return: si ritornano dei dizionari che sono
            came_from (descrive in sostanza il
             percorso all'indietro) e cost_so_far (dice il
             costo dello shortest path dalla partenza fino
             ad un nodo specifico)
    """

    start3D = [start2D[0], start2D[1], 0]
    # goal3D forse non ci serve
    frontier = PriorityQueue()  # gli items in questa priority queue sono liste
    frontier.put(start3D, 0)
    # all'inizio la frontiera è fatta dal solo punto
    # di partenza (che è una lista)
    came_from = {}  # LE CHIAVI DEVONO ESSERE TUPLE E I VALORI ANCHE
    # con il comando sopra vogliamo tenere conto delle
    # posizioni precedenti a quelle raggiunte (che sono le
    # chiavi del dizionario).
    cost_so_far = {}
    # THE ABOVE VARIABLE IS USED TO TAKE THE MOVEMENT
    # COSTS INTO ACCOUNT WHEN DECIDING HOW TO EVALUATE
    # LOCATIONS
    # inizializzazione
    came_from[tuple(start3D)] = None
    cost_so_far[tuple(start3D)] = 0  # in quanto dizionario, cost_so_far deve
    # avere almeno delle tuple come chiavi

    # inizializziamo Reverse Resumable A*
    # per la stima (true distance heuristic)
    came_from_init, cost_so_far_init, frontier_init = initialize_RRA_star(spatial_graph, start2D, goal2D)
    came_from_RRA_star = came_from_init.copy()
    cost_so_far_RRA_star = cost_so_far_init.copy()
    frontier_RRA_star = frontier_init


    while not frontier.empty():
        # prendiamo una cella e la rimuoviamo dalla frontiera
        current3D = frontier.get()  # current dovrebbe essere una lista
        current2D = [current3D[0], current3D[1]]

        tempo_trovato = current3D[2]
        goal3D_trovato = [goal2D[0], goal2D[1], tempo_trovato]

        if current2D == goal2D:
            return came_from, cost_so_far, goal3D_trovato
            # Essendo next definito come il vicino di current (ma inteso come vicino allo
            # istante di tempo successivo), avremo certamente che came_from
            # di un certo elemento contiene solo elementi dell'istante di tempo
            # precedente, mentre cost_so_far contiene elementi di tempi anche diversi

        for next3D in spatio_temporal_graph.neighbors(current3D):  # next dovrebbe essere una lista
            # CALCOLIAMO IL NUOVO COSTO:
            # NOTA IL COSTO CHE AGGIUNGIAMO
            new_cost = cost_so_far[tuple(current3D)] + 1  # in implementazione alternativa
                                            # potremmo voler mettere pesi
                                            # diversi

            if tuple(next3D) not in cost_so_far or new_cost < cost_so_far[tuple(next3D)]:
                # mentre con new cost abbiamo solo calcolato qual è
                # il costo nuovo movendosi in un vicino, ora decidiamo
                # se metterlo in cost so far e sostanzialmente lo mettiamo
                # se non abbiamo ancora una chiave next, oppure se
                # questo nuovo costo è migliore per il nodo next
                cost_so_far[tuple(next3D)] = new_cost

                # applichiamo la true distance heuristic
                next2D = [next3D[0], next3D[1]]
                # il seguente if ci serve per capire se abbiamo
                # già la true distance heuristic oppure no
                # in caso non ce l'avessimo dovremmo
                # applicare resume RRA*
                if tuple(next2D) in cost_so_far_RRA_star:
                    true_distance_heuristic = cost_so_far_RRA_star[tuple(next2D)]
                else:
                    # proseguiamo ad applicare Reverse Resumable A*
                    # per la stima (true distance heuristic)
                    came_from_RRA_star_bis, cost_so_far_RRA_star_bis, frontier_RRA_star_bis = resume_RRAstar(spatial_graph, next2D, came_from_RRA_star, cost_so_far_RRA_star, frontier_RRA_star, start2D)
                    came_from_RRA_star = came_from_RRA_star_bis.copy()
                    cost_so_far_RRA_star = cost_so_far_RRA_star_bis.copy()
                    frontier_RRA_star = frontier_RRA_star_bis
                    true_distance_heuristic = cost_so_far_RRA_star[tuple(next2D)]

                priority = new_cost + true_distance_heuristic

                frontier.put(next3D, priority)
                # ricorda che una priority queue associa ad ogni
                # item un numero chiamato priority. Quando deve
                # essere ritornato un item, prende quello
                # con priority minore
                came_from[tuple(next3D)] = tuple(current3D)  # perchè, in base alla
                # condizione nell'if, se non avevamo ancora
                # visitato quel nodo (next) allora dobbiamo
                # specificare da dove arriva, mentre se
                # lo avevamo visitato e abbiamo trovato un cammino
                # dalla partenza fino a lui che costa meno di quello
                # che avevamo, modifichiamo il suo came_from.

    raise Exception('Non è stato possibile espandere il nodo cercato.')





class PriorityQueue:
    """
    CLASS FOR PRIORITY QUEUE. A PRIORITY QUEUE ASSOCIATES WITH EACH
    ITEM A NUMBER CALLED A PRIORITY. WHEN RETURNING AN ITEM, IT PICKS
    THE ONE WITH LOWEST NUMBER.
    """

    def __init__(self):
        """
        Method for Initialization
        """
        self.elements = []  # List[Tuple]
        # THE ELEMENTS OF THIS PRIORITY QUEUE ARE STORED
        # INSIDE A LIST WHERE EACH ITEM IS A TUPLE CORRESPONDING
        # TO A NODE

    def empty(self):
        """
        Method for the class PriorityQueue telling whether the
        priority queue is empty or not
        :return: boolean value 1 if the priority queue is empty
                boolean value 0 if the priority queue is not empty
        """
        return not self.elements

    def put(self, item, priority):
        """
        Method for the class PriorityQueue used to insert
        a new element in the priority queue
        :param item: item to be added in the priority queue
        :param priority: priority value (type float) of the item to be inserted
        """
        # FOR THIS PURPOSE, THE PACKAGE HEAPQ IS USED
        heapq.heappush(self.elements, (priority, item))

    def get(self):
        """
        Method for the class PriorityQueue used to extract the
        item with lowest priority
        :return: item with lowest priority
        """
        return heapq.heappop(self.elements)[1]


# attenzione 65x81 vuol dire 65 colonne e 81 righe
class MAPF_FILE:
    """
    CLASS FOR MAPF STARTING FROM GRID AND SCENARIOS FILES.
    """

    def __init__(self, grid_file, scenarios_file, num_agents_starting):
        """
        Method for Initialization
        :param grid_file: file contenente la struttura della griglia
        :param scenarios_file: file contenente le posizione di partenza ed arrivo degli
                                agenti da inserire nella griglia
        """
        # ATTRIBUTO grid_file (Attributo di Istanza)
        self.grid_file = grid_file

        # ATTRIBUTO scenarios_file (Attributo di Istanza)
        self.scenarios_file = scenarios_file

        # ATTRIBUTO griglia (Attributo di Istanza)
        self.griglia_3D = Space_Time_Grid(self.grid_file)

        # ATTRIBUTO griglia (Attributo di Istanza)
        self.griglia_2D = Spatial_Grid(self.grid_file)

        # ATTRIBUTO altezza_griglia (Attributo di Istanza)
        self.altezza_griglia = self.griglia_2D.righe_totali  # numero righe

        # ATTRIBUTO larghezza_griglia (Attributo di Istanza)
        self.larghezza_griglia = self.griglia_2D.colonne_totali  # numero colonne

        # ATTRIBUTO dizionario_agenti (Attributo di Istanza)
        self.dizionario_agenti = {}  # la chiave sarà l'ID dell'agente, mentre
        # il valore sarà l'oggetto agente

        # ATTRIBUTO list_agents_start (Attributo di Istanza)
        self.list_agents_start = []

        # Attributo list_agents_goal (Attributo di Istanza)
        self.list_agents_goal = []

        # Attributo numero_agenti_considerati (Attributo di Istanza)
        self.num_agents_starting = num_agents_starting  # STIAMO RAGIONANDO NEL CASO OFFLINE, QUINDI
        # QUESTO ATTRIBUTO E' PROPRIO UGUALE AL NUMERO TOTALE DI AGENTI

        # ATTRIBUTO n_TOTAL_agents (Attributo di Istanza)
        self.n_TOTAL_agents = 0

        # ATTRIBUTO list_agents_position (Attributo di Istanza)
        self.dict_agents_position = {}  # la chiave sarà l'ID dell'agente, mentre
        # il valore sarà la posizione attuale

        # ATTRIBUTO sum_of_steps (Attributo di Istanza)
        self.sum_of_steps = 0

        # COSTRUZIONE AGENTI CART
        self.build_agents_MAPF(self.scenarios_file, self.num_agents_starting)

    def build_agents_MAPF(self, file_agenti, num_agenti_cart):
        """
        Metodo della classe MAPF per costruire
        gli agenti cart
        :param file_agenti: file contenente gli agenti da costruire
        :param num_agenti_cart: numero di agenti da costruire
        """

        g = open(file_agenti, 'r')
        _ = g.readline()  # la prima riga non contiene informazioni interessanti

        # cerchiamo di evitare di dover mettere il seguente comando,
        # detto altrimenti:
        # CONSIDERIAMO MENO DI CIRCA 1000 AGENTI
        #for ppp in range(0, self.n_TOTAL_agents):
        #    content = g.readline()  # così non devo ricontare gli stessi agenti ogni volta
        #    if not content:  # è finito il file --> ricominciamo a leggerlo
        #        g.close()
        #        print(
        #            "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")
        #        g = open(file_agenti, 'r')
        #        _ = g.readline()  # la prima riga non contiene informazioni interessanti
        #        content = g.readline()  # in un certo senso recuperiamo quella riga che era diventata vuota

        for qqq in range(0, num_agenti_cart):  # 950 = numero massimo di agenti nel file
            linea = g.readline()
            # cerchiamo di evitare di dover mettere il seguente comando,
            # detto altrimenti:
            # CONSIDERIAMO MENO DI CIRCA 1000 AGENTI
            #if not linea:  # è finito il file --> ricominciamo a leggerlo
            #    g.close()
            #    print(
            #        "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA")
            #    g = open(file_agenti, 'r')
            #    _ = g.readline()  # la prima riga non contiene informazioni interessanti
            #    linea = g.readline()  # in un certo senso recuperiamo quella riga che era diventata vuota

            linea = linea.rsplit()
            origin_y = int(linea[4])  # colonne
            origin_x = int(linea[5])  # righe
            goal_y = int(linea[6])  # colonne
            goal_x = int(linea[7])  # righe
            numero = float(linea[8])

            # COSTRUZIONE AGENTI CART
            self.dizionario_agenti[(self.n_TOTAL_agents)] = Mobile_Agent(id=self.n_TOTAL_agents,
                                                                         origin=[origin_x, origin_y],
                                                                         goal=[goal_x, goal_y])
            # nella linea di codice precedente abbiamo posto come chiave l'id dell'agente mobile
            # e come valore l'oggetto Mobile_Agent associato

            self.griglia_3D.matrix_agents[origin_x, origin_y, 0] = self.n_TOTAL_agents
            self.list_agents_start.append([origin_x, origin_y])
            self.list_agents_goal.append([goal_x, goal_y])
            self.n_TOTAL_agents = self.n_TOTAL_agents + 1  # incrementiamo il numero totale di agenti nel sistema
            # alla fine numero_agenti_considerati dovrebbe essere uguale a n_TOTAL_agents

        g.close()


    def solve_MAPF(self, plot):
        """
        Metodo della classe MAPF utilizzato per
        risolvere il problema di planning
        """
        if plot == 1:
            for s in range(0, self.n_TOTAL_agents):
                origin = self.dizionario_agenti[(s)].origin
                self.griglia_2D.matrix_2D[origin[0], origin[1]] = START_CELL
                self.griglia_3D.matrix[origin[0], origin[1], 0] = 1
                self.griglia_2D.dict_tiles[(origin[0], origin[1])] = START_CELL  # CONTIENE IN QUESTO CASO
                # IL COLORE ORIGINAL
                goal = self.dizionario_agenti[(s)].goal
                if self.griglia_2D.matrix_2D[(goal[0], goal[1])] != MOVE_CELL:
                    self.griglia_2D.matrix_2D[(goal[0], goal[1])] = GOAL_CELL
                self.griglia_2D.dict_tiles[(goal[0], goal[1])] = GOAL_CELL  # CONTIENE IN QUESTO CASO
                # IL COLORE ORIGINAL

            fig = plt.figure()
            ax = plt.axes()
            # we build our window
            ax.imshow(self.griglia_2D.matrix_2D, cmap=cmap, norm=norm)
            # ax.imshow(self.griglia.matrix, cmap=cmap)
            # with this command we display data as an image, i.e.,
            # on a 2D regular raster.
            # let's draw gridlines
            ax.grid(which='major', axis='both', linestyle='-', color='k', linewidth=1)
            ax.set_xticks(np.arange(0.5, self.larghezza_griglia, 1))
            ax.set_yticks(np.arange(0.5, self.altezza_griglia, 1))
            plt.tick_params(axis='both', which='both', bottom=False,
                            left=False, labelbottom=False,
                            labelleft=False)
            # fig.set_size_inches((8.5, 11), forward=False)
            stringa_titolo = 'HCA_{}.png'
            stringa_titolo_completo = stringa_titolo.format(-1)
            plt.savefig(stringa_titolo_completo)
            plt.pause(1)

        ATTENZIONE = 0
        agente_problematico = None
        t_max = 0
        agente_massimo = None
        start_time_python = time.time()  # tempo di inizio esecuzione risoluzione
        # ORA INIZIA L'ALGORITMO
        for s in range(0, self.n_TOTAL_agents):
            came_from_agente_x, cost_so_far_agente_x, goal_3d_trovato_x = Spatio_Temporal_A_star_search(spatio_temporal_graph=self.griglia_3D,
                                                                                                  spatial_graph=self.griglia_2D,
                                                                                                  start2D=self.dizionario_agenti[(s)].origin,
                                                                                                  goal2D=self.dizionario_agenti[(s)].goal)
            # ricorda che i due output alla riga precedente sono dei dizionari le cui chiavi (e nel caso di came_from_agente
            # anche i valori) sono tuple a 3 entrate; ad essi si aggiunge la lista a tre entrate corrispondente
            # al goal che è stato trovato (ci serve semplicemente perchè dobbiamo capire se è possibile arrivare
            # ad una soluzione (a causa del discorso di priorità) e nel caso dopo quanti step)
            came_from_agente = came_from_agente_x.copy()
            cost_so_far_agente = cost_so_far_agente_x.copy()
            goal_3d_trovato = goal_3d_trovato_x.copy()

            cammino = []
            corrente3D = goal_3d_trovato
            while corrente3D != [self.dizionario_agenti[s].origin[0], self.dizionario_agenti[s].origin[1], 0]:
                cammino.append(corrente3D)
                corrente3D = came_from_agente[tuple(corrente3D)]  # corrente a primo membro è una tupla
                                                            # per costruzione di came_from (dizionario)
                # ricorda came_from[next] = current
                corrente3D = list(corrente3D)  # ritrasformo in lista

                # adesso modifichiamo la griglia 3D
                # ricorda che ragioniamo con disappear at target, quindi
                # non avremo ostacoli mobili dopo che un agente ha raggiunto
                # la sua destinazione
                aaaa = corrente3D[0]
                bbbb = corrente3D[1]
                cccc = corrente3D[2]
                self.griglia_3D.matrix[aaaa, bbbb, cccc] = 1
                self.griglia_3D.matrix_agents[aaaa, bbbb, cccc] = self.dizionario_agenti[(s)].id
                # nota che la griglia 2D non è da modificare perchè
                # essa contiene delle informazioni che non riguardano
                # la evoluzione temporale.

            #cammino = cammino.reverse()
            self.dizionario_agenti[(s)].path = cammino.copy()
            # per ora non invertiamo
            self.dizionario_agenti[(s)].path_to_be_removed = cammino.copy()

            tempo_python = time.time()
            tempo_intermedio = tempo_python - start_time_python
            print('Cammino identificato per agente ', s, ' al tempo tempo: ', tempo_intermedio)
            print('Di seguito riportiamo il cammino identificato (reverse): ')
            print(self.dizionario_agenti[(s)].path)
            print('Timesteps richiesti per portare agente ', s, ' a destinazione: ', self.dizionario_agenti[(s)].path[0][2])
            self.sum_of_steps = self.sum_of_steps + self.dizionario_agenti[(s)].path[0][2]
            if self.dizionario_agenti[(s)].path[0][2] > t_max:
                # aggiorniamo il timestep massimo richiesto
                # e l'agente associato
                t_max = self.dizionario_agenti[(s)].path[0][2]
                agente_massimo = s

        # ora diamo informazioni conclusive
        tempo_python_final = time.time()
        tempo_finale = tempo_python_final - start_time_python
        print('Tempo massimo richiesto per concludere la ricerca:', tempo_finale)
        print('Timestep massimo richiesto per concludere la ricerca: ', t_max, '(agente ', agente_massimo, ')')
        print('Sum of steps: ', self.sum_of_steps)


        if plot == 1:
            tempo_discreto = 0
            while tempo_discreto < t_max:
                for qqq in range(0, len(self.dizionario_agenti)):
                    if self.dizionario_agenti[(qqq)].path_to_be_removed != []:
                        posizione = self.dizionario_agenti[(qqq)].path_to_be_removed.pop()
                        posizione_2D = [posizione[0], posizione[1]]
                        self.griglia_2D.matrix_2D[posizione_2D[0], posizione_2D[1]] = MOVE_CELL
                        if posizione_2D == self.dizionario_agenti[(qqq)].goal:
                            self.griglia_2D.matrix_2D[posizione_2D[0], posizione_2D[1]] = GOAL_CELL


                # we build our window
                ax = plt.axes()
                ax.imshow(self.griglia_2D.matrix_2D, cmap=cmap, norm=norm)
                # ax.imshow(self.griglia.matrix, cmap=cmap)
                # with this command we display data as an image, i.e.,
                # on a 2D regular raster.
                # let's draw gridlines
                ax.grid(which='major', axis='both', linestyle='-', color='k', linewidth=1)
                ax.set_xticks(np.arange(0.5, self.larghezza_griglia, 1))
                ax.set_yticks(np.arange(0.5, self.altezza_griglia, 1))
                plt.tick_params(axis='both', which='both', bottom=False,
                                left=False, labelbottom=False,
                                labelleft=False)
                # fig.set_size_inches((8.5, 11), forward=False)
                # plt.savefig(saveImageName + ".png", dpi=500)
                stringa_titolo_completo = stringa_titolo.format(tempo_discreto)
                plt.savefig(stringa_titolo_completo)
                plt.pause(1)

                for xxxx in range(0, self.altezza_griglia):
                    for yyyy in range(0, self.larghezza_griglia):
                        self.griglia_2D.matrix_2D[xxxx, yyyy] = self.griglia_2D.dict_tiles[(xxxx, yyyy)]

                tempo_discreto = tempo_discreto + 1





class Space_Time_Grid:
    """
    Classe per la griglia.
    """

    def __init__(self, file_griglia):
        """
        Method for Initialization.
        :param file_griglia: file containing grid information
        """

        # ATTRIBUTO file_griglia (Attributo di Istanza)
        self.file_griglia = file_griglia

        # ATTRIBUTO Obstacles (Attributo di Istanza)
        self.Obstacles = []  # lista di coppie x,y (solo gli ostacoli fissi)

        f = open(self.file_griglia, 'r')
        # ATTRIBUTO righe_totali (Attributo di Istanza)
        _ = f.readline()  # la prima riga non ci interessa, dovrebbe essere 'type octile\n'
        file_line = f.readline()  # generalmente questa seconda riga contiene la altezza della griglia
        file_line = file_line.rsplit()  # con questo comando diventa lista di stringhe
        self.righe_totali = int(file_line[1])
        # ATTRIBUTO colonne_totali (Attributo di Istanza)
        file_line_2 = f.readline()  # generalmente questa seconda riga contiene la larghezza della griglia
        file_line_2 = file_line_2.rsplit()  # con questo comando diventa lista di stringhe
        self.colonne_totali = int(file_line_2[1])
        _ = f.readline()  # non ci interessa, dovrebbe essere 'map\n'

        # ATTRIBUTO matrix (Attributo di Istanza)
        self.matrix = np.zeros((self.righe_totali, self.colonne_totali, 20*max(self.righe_totali, self.colonne_totali)))
        # since they are zeros, they are considered initially as empty cells
        # stiamo considerando in questo caso che il tempo "massimo" sia il doppio del
        # massimo tra il numero di righe e di colonne

        # ATTRIBUTO matrix_agents (Attributo di Istanza)
        self.matrix_agents = -np.ones((self.righe_totali, self.colonne_totali, 20*max(self.righe_totali, self.colonne_totali)))

        # da adesso leggo
        for aaa in range(0, self.righe_totali):  # conteggio sulle righe
            linea = f.readline()
            linea = linea.rsplit()
            linea_lista = list(linea[0])  # controlla che list non sia stato
            # salvato come un oggetto
            # la dimensione dovrebbe essere 256, oppure 81, ...
            for bbb in range(0, self.colonne_totali):  # conteggio sulle colonne
                if linea_lista[bbb] != '.':  # spazio NON vuoto
                    self.Obstacles.append([aaa, bbb])
                    self.matrix[aaa, bbb, :] = 1
                    # dunque a seconda che il valore in ogni cella della
                    # matrice sia 1 oppure 0 capiamo se ci sono
                    # ostacoli fissi oppure no (ricorda che
                    # non stiamo considerando gli altri agenti)
        f.close()  # chiusura file
        #print(self.matrix)


    def neighbors(self, cell):  # la cella è intesa qui come
                                # una cella 3D
        """
        Method of class taking the cell position
        in the grid as input and giving as output a
        single or a list of neighbors
        :param cell: cell position in the grid (list)
        :return: list of neighbors (list of lists)
        """
        [xx, yy, tt] = cell
        neighbors_list = []  # sarà una lista di liste, dove ogni lista interna corrisponde
        # ad una terna x,y,t

        # ricorda che questo ci serve allo interno
        # dello algoritmo A*
        if (xx + 1 >= 0) and (xx + 1 <= self.righe_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix[xx + 1, yy, tt + 1] != 1:
                # NOTA CHE SCRIVENDO 1 E NON OBSTACLE CELL, QUI GLI OSTACOLI DIVENTANO
                # GLI OGGETTI AGENTS STESSI, COME IN EFFETTI VOGLIAMO PER COME
                # E' DEFINITO CA*

                # CHECK SU POSSIBILE HEAD-TO-HEAD COLLISION
                if self.matrix[xx, yy, tt + 1] == 1:  # allora controlliamo che non ci sia head-to-head collision
                    agente_occupante = self.matrix_agents[xx, yy, tt + 1]  # id dell'agente che occupa
                                                                            # la cella [xx, yy] al tempo t + 1
                    if self.matrix_agents[xx + 1, yy, tt] != agente_occupante:  # non c'è head-to-head collision
                        neighbors_list.append([xx + 1, yy, tt + 1])
                else:  # non c'è head-to-head collision
                    neighbors_list.append([xx + 1, yy, tt + 1])

        if (xx - 1 >= 0) and (xx - 1 <= self.righe_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix[xx - 1, yy, tt + 1] != 1:
                # CHECK SU POSSIBILE HEAD-TO-HEAD COLLISION
                if self.matrix[xx, yy, tt + 1] == 1:  # allora controlliamo che non ci sia head-to-head collision
                    agente_occupante = self.matrix_agents[xx, yy, tt + 1]  # id dell'agente che occupa
                                                                            # la cella [xx, yy] al tempo t + 1
                    if self.matrix_agents[xx - 1, yy, tt] != agente_occupante:  # non c'è head-to-head collision
                        neighbors_list.append([xx - 1, yy, tt + 1])
                else:
                    neighbors_list.append([xx - 1, yy, tt + 1])

        if (yy - 1 >= 0) and (yy - 1 <= self.colonne_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix[xx, yy - 1, tt + 1] != 1:
                # CHECK SU POSSIBILE HEAD-TO-HEAD COLLISION
                if self.matrix[xx, yy, tt + 1] == 1:  # allora controlliamo che non ci sia head-to-head collision
                    agente_occupante = self.matrix_agents[xx, yy, tt + 1]  # id dell'agente che occupa
                                                                            # la cella [xx, yy] al tempo t + 1
                    if self.matrix_agents[xx, yy - 1, tt] != agente_occupante:  # non c'è head-to-head collision
                        neighbors_list.append([xx, yy - 1, tt + 1])
                else:
                    neighbors_list.append([xx, yy - 1, tt + 1])

        if (yy + 1 >= 0) and (yy + 1 <= self.colonne_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix[xx, yy + 1, tt + 1] != 1:
                # CHECK SU POSSIBILE HEAD-TO-HEAD COLLISION
                if self.matrix[xx, yy, tt + 1] == 1:  # allora controlliamo che non ci sia head-to-head collision
                    agente_occupante = self.matrix_agents[xx, yy, tt + 1]  # id dell'agente che occupa
                                                                            # la cella [xx, yy] al tempo t + 1
                    if self.matrix_agents[xx, yy + 1, tt] != agente_occupante:  # non c'è head-to-head collision
                        neighbors_list.append([xx, yy + 1, tt + 1])
                else:
                    neighbors_list.append([xx, yy + 1, tt + 1])

        if self.matrix[xx, yy, tt + 1] != 1:  # possibilità di rimanere fermi
            # NON CI PUO' CHIARAMENTE ESSERE POSSIBILITA' DI HEAD-TO-HEAD COLLISION
            neighbors_list.append([xx, yy, tt + 1])

        return neighbors_list




class Spatial_Grid:
    """
    Classe per la griglia.
    """

    def __init__(self, file_griglia):
        """
        Method for Initialization.
        :param file_griglia: file containing grid information
        """

        # ATTRIBUTO file_griglia (Attributo di Istanza)
        self.file_griglia = file_griglia

        # ATTRIBUTO dict_tiles (Attributo di Istanza)
        self.dict_tiles = {}  # contiene in questo caso il colore originale

        # ATTRIBUTO Obstacles (Attributo di Istanza)
        self.Obstacles = []  # lista di coppie x,y
        # ostacoli intesi come fissi

        f = open(self.file_griglia, 'r')
        # ATTRIBUTO righe_totali (Attributo di Istanza)
        _ = f.readline()  # la prima riga non ci interessa, dovrebbe essere 'type octile\n'
        file_line = f.readline()  # generalmente questa seconda riga contiene la altezza della griglia
        file_line = file_line.rsplit()  # con questo comando diventa lista di stringhe
        self.righe_totali = int(file_line[1])
        # ATTRIBUTO colonne_totali (Attributo di Istanza)
        file_line_2 = f.readline()  # generalmente questa seconda riga contiene la larghezza della griglia
        file_line_2 = file_line_2.rsplit()  # con questo comando diventa lista di stringhe
        self.colonne_totali = int(file_line_2[1])
        _ = f.readline()  # non ci interessa, dovrebbe essere 'map\n'

        # ATTRIBUTO matrix (Attributo di Istanza)
        self.matrix_2D = np.zeros((self.righe_totali, self.colonne_totali))
        # since they are zeros, they are considered initially as empty cells
        # stiamo considerando in questo caso che il tempo "massimo" sia il doppio del
        # massimo tra il numero di righe e di colonne
        for iii in range(0, self.righe_totali):
            for jjj in range(0, self.colonne_totali):
                self.dict_tiles[(iii, jjj)] = EMPTY_CELL

        # da adesso leggo
        for aaa in range(0, self.righe_totali):  # conteggio sulle righe
            linea = f.readline()
            linea = linea.rsplit()
            linea_lista = list(linea[0])  # controlla che list non sia stato
            # salvato come un oggetto
            # la dimensione dovrebbe essere 256, oppure 81, ...
            for bbb in range(0, self.colonne_totali):  # conteggio sulle colonne
                if linea_lista[bbb] != '.':  # spazio NON vuoto
                    self.Obstacles.append([aaa, bbb])
                    self.matrix_2D[aaa, bbb] = OBSTACLE_CELL
                    # dunque a seconda che il valore in ogni cella della
                    # matrice sia 1 oppure 0 capiamo se ci sono
                    # ostacoli fissi oppure no (ricorda che
                    # non stiamo considerando gli altri agenti)
                    self.dict_tiles[(aaa, bbb)] = OBSTACLE_CELL

        f.close()  # chiusura file


    def neighbors(self, cell):  # la cella è intesa qui come
                                # una cella 2D
        """
        Method of class taking the cell position
        in the grid as input and giving as output a
        single or a list of neighbors
        :param cell: cell position in the grid (list)
        :return: list of neighbors (list of lists)
        """
        [xx, yy] = cell
        neighbors_list = []  # sarà una lista di liste, dove ogni lista interna corrisponde
        # ad una coppia x,y

        # ricorda che questo ci serve allo interno
        # dello algoritmo A*
        if (xx + 1 >= 0) and (xx + 1 <= self.righe_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix_2D[xx + 1, yy] != 1:
                neighbors_list.append([xx + 1, yy])
        if (xx - 1 >= 0) and (xx - 1 <= self.righe_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix_2D[xx - 1, yy] != 1:
                neighbors_list.append([xx - 1, yy])
        if (yy - 1 >= 0) and (yy - 1 <= self.colonne_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix_2D[xx, yy - 1] != 1:
                neighbors_list.append([xx, yy - 1])
        if (yy + 1 >= 0) and (yy + 1 <= self.colonne_totali - 1):  # check per non uscire fuori dalla griglia
            if self.matrix_2D[xx, yy + 1] != 1:
                neighbors_list.append([xx, yy + 1])
        #if self.matrix[xx, yy, tt + 1] != 1:
        #    neighbors_list.append([xx, yy, tt + 1])
        # GIUSTAMENTE COMMENTIAMO PERCHE' QUANDO USIAMO SPATIAL_GRID NON CI INTERESSA LA POSSIBILITA' DI
        # RESTARE FERMI, INFATTI SPATIAL_GRID VIENE CONSIDERATO SOLO PER DETERMINARE IL VALORE DELLA
        # EURISTICA TRUE DISTANCE
        return neighbors_list





class Mobile_Agent:
    """
    Classe rappresentante gli agenti mobili (skids).
    """

    def __init__(self, id, origin, goal):
        """
        Metodo di inizializzazione
        :param id: id agente
        :param origin: posizione origine dell'agente
                    (lista di coordinate x e y)
        :param goal: posizione obiettivo dell'agente
                    (lista di coordinate x e y)
        """

        # ATTRIBUTO ORIGIN (Attributo di Istanza)
        self.id = id

        # ATTRIBUTO ORIGIN (Attributo di Istanza)
        self.origin = origin

        # ATTRIBUTO GOAL (Attributo di Istanza)
        self.goal = goal

        # ATTRIBUTO POSITION (Attributo di Istanza)
        self.position = origin

        # ATTRIBUTO PATH (Attributo di Istanza)
        self.path = []  # dalla posizione attuale al goal

        # ATTRIBUTO PATH_TO_BE_REMOVED (Attributo di Istanza)
        self.path_to_be_removed = []

        # ATTRIBUTO costo_agente (Attributo di Istanza)
        self.costo_agente = 0  # inizialmente assegniamo valore nullo

        # ATTRIBUTO timestep_agente (Attributo di Istanza)
        self.timestep_agente = 0  # inizialmente assegniamo valore nullo

