function triload(filename)
% TRILOAD - loads trimmed flight-conditions from file
%
% TRILOAD calls FDCLOAD to load files of type *.TRI (trimmed flight-
% conditions). Used for initialization of nonlinear Simulink models 
% from the FDC toolbox.
%
% Usage:
% ======
% triload
%    will open a dialog box with all available TRI-files in the used 
%    data-directory. Normally, the FDC data-directory will be used as 
%    starting point, but if that directory is not available TRILOAD will 
%    display a warning message, and use the current working directory
%    instead.
%
% triload('filename')
%    will do the same, except 'filename.tri' will be used as default
%    filename (this can still be overruled by selecting a different file
%    from the load dialog). Wildcards '?' and '*' may be used.
%
% Note: Specifying a non-existing filename as default TRI-file does not
%    yield an error, unless one actually tries to open this non-existing
%    file from the load dialog. 
%
% See also FDCLOAD.

% Variables:
% ----------
% filename   used to store default filename (without extension; the complete
%             file becomes 'filename.tri')

if nargin == 0
  feval('fdcload','tri','trimmed flight condition');
elseif nargin == 1
  feval('fdcload',[filesep filename '.tri'],'trimmed flight condition');
end

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------