% RESPLOT - plots aircraft simulation results
%
% RESPLOT is a simple Matlab script that will plot the most important 
% time-trajectories of states, inputs, and outputs for the Beaver model. 
% It can be used only after performing a simulation and running the 
% RESULTS utility first, as it needs all time-trajectories to be 
% available in the Matlab workspace to function properly. Notice that 
% RESPLOT does not contain any error-checking facilities: it is up to 
% the user to make sure that it can find the required variables in the 
% Matlab workspace by running RESULTS before trying to generate these 
% plots.
%
% If you want to change the appearance of these plots, or display other 
% results, it will be necessary to change the RESPLOT.M source-code.


% First, close all existing figures
% ---------------------------------
close all

% Verify if the units for angular values and angular rates are still 
% present in the workspace (they should be if RESULTS was run first). If 
% for some unforseen reason, these variables were still cleared, display
% the angles and angular rates WITHOUT  a unit.
% ----------------------------------------------------------------------
if not(exist('unit_angle'))
   unit_angle = '';
end
if not(exist('unit_rate'))
   unit_rate = '';
end

% Plot relevant results
% ---------------------
hold off;
clf
subplot(221); plot(time,V); grid;
xlabel('time [s]'); ylabel('V [m/s]');
subplot(222); plot(time,alpha); grid;
xlabel('time [s]'); ylabel(['alpha ' unit_angle]);
subplot(223); plot(time,beta); grid;
xlabel('time [s]'); ylabel(['beta ' unit_angle]);
subplot(224); plot(time,H); grid;
xlabel('time [s]'); ylabel('H [m]');
pause

clf
subplot(221); plot(time,p); grid;
xlabel('time [s]'); ylabel(['p ' unit_rate]);
subplot(222); plot(time,q); grid;
xlabel('time [s]'); ylabel(['q ' unit_rate]);
subplot(223); plot(time,r); grid;
xlabel('time [s]'); ylabel(['r ' unit_rate]);
pause

clf
subplot(221); plot(time,psi); grid;
xlabel('time [s]'); ylabel(['psi ' unit_angle]);
subplot(222); plot(time,theta); grid;
xlabel('time [s]'); ylabel(['theta ' unit_angle]);
subplot(223); plot(time,phi); grid;
xlabel('time [s]'); ylabel(['phi ' unit_angle]);
pause

clf
subplot(221); plot(time,deltae); grid;
xlabel('time [s]'); ylabel(['deltae ' unit_angle]);
subplot(222); plot(time,deltaa); grid;
xlabel('time [s]'); ylabel(['deltaa ' unit_angle]);
subplot(223); plot(time,deltar); grid;
xlabel('time [s]'); ylabel(['deltar ' unit_angle]);
subplot(224); plot(time,uw,time,vw,time,ww); grid;
xlabel('time [s]'); ylabel('uw, vw, ww [m/s]');

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: July 17, 2005. 
%-----------------------------------------------------------------------
