function matload(filename)
% MATLOAD - loads MAT-files from the FDC datadirectory
%
% MATLOAD calls FDCLOAD to load files of type *.MAT (Matlab data-
% files).
%
% Usage:
% ======
% matload
%    will open a dialog box with all available MAT-files in the used 
%    data-directory. Normally, the FDC data-directory will be used as 
%    starting point, but if that directory is not available MATLOAD will 
%    display a warning message, and use the current working directory
%    instead.
%
% matload('filename')
%    will do the same, except 'filename.mat' will be used as default
%    filename (this can still be overruled by selecting a different file
%    from the load dialog). Wildcards '?' and '*' may be used.
%
% Note: Specifying a non-existing filename as default MAT-file does not
%    yield an error, unless one actually tries to open this non-existing
%    file from the load dialog. 
%
% See also FDCLOAD.

% Variables:
% ----------
% filename   used to store default filename (without extension; the complete
%             file becomes 'filename.mat')

if nargin == 0
  feval('fdcload','mat','Matlab data');
elseif nargin == 1
  feval('fdcload',[filesep filename '.mat'],'Matlab data');
end

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------