function linload(filename)
% LINLOAD - loads linearized models from file
%
% LINLOAD calls FDCLOAD to load files of type *.LIN (containing the
% parameters of linearized dynamic models). Used for initialization of 
% linear Simulink models from the FDC toolbox.
%
% Usage:
% ======
% linload
%    will open a dialog box with all available LIN-files in the used 
%    data-directory. Normally, the FDC data-directory will be used as 
%    starting point, but if that directory is not available LINLOAD will 
%    display a warning message, and use the current working directory
%    instead.
%
% linload('filename')
%    will do the same, except 'filename.lin' will be used as default
%    filename (this can still be overruled by selecting a different file
%    from the load dialog). Wildcards '?' and '*' may be used.
%
% Note: Specifying a non-existing filename as default LIN-file does not
%    yield an error, unless one actually tries to open this non-existing
%    file from the load dialog. 
%
% See also FDCLOAD.

% Variables:
% ----------
% filename   used to store default filename (without extension; the complete
%             file becomes 'filename.lin')

if nargin == 0
  feval('fdcload','lin','linearized model parameters');
elseif nargin == 1
  feval('fdcload',[filesep filename '.lin'],'linearized model parameters');
end

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------