function fdc_splash
% FDC_SPLASH - shows splash-screen for the FDC toolbox.


% Determine screensize for figure positioning in character-units
% --------------------------------------------------------------
screen_size = screensize;

% Figure size, expressed in pixels
% --------------------------------
fig_width  = 480;
fig_height = 176;

% Initial figure position: horizontally centered on the screen, vertical position
% slightly above screen center. The variables x_fig and y_fig are used to store
% the (x,y) coordinate of the lower left corner of the figure.
% -------------------------------------------------------------------------------
x_fig = floor(0.5*(screen_size(3)-fig_width));
y_fig = floor(0.7*(screen_size(4)-fig_height));

% Load Beaver graphic
% -------------------
splash_screen = imread('beaver.jpg');

% Draw the figure
% ---------------
fig_handle = figure('DefaultAxesPosition',[0 0 1 1], ...
     'DefaultAxesVisible','off', ...
     'KeypressFcn','close(gcf)', ...
     'MenuBar','none', ...
     'Name','The Flight Dynamics and Control Toolbox, version 1.4.0', ...
     'NumberTitle','off', ...
     'Position',[x_fig y_fig fig_width fig_height], ...
     'Resize','off', ...
     'WindowButtonDownFcn','close(gcf)', ... 
     'WindowStyle','modal');

% Show Beaver graphic
% -------------------
image(splash_screen);

% Don't do anything else, until the figure is closed (by pressing any 
% key, or on mouse click; see KeypressFcn and WindowButtonDownFcn)
% -------------------------------------------------------------------
uiwait(fig_handle);


%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------
