
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CREATE TRIMMED-FLIGHT CURVE %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc
disp('==============================================');
disp('                   Wait');
disp('==============================================');
V=50:3:65
H=500:500:2000


% ELEVATOR
figure(1)
for i=1:1:4
plot(V,-deltae1_m(:,i).*180./pi);
hold on
end
title('Elevator deflection ');
xlabel('V [m/s]');
ylabel('-\delta_{e} [deg]');
text(53, 7.5, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
grid on
hold off

% AILERON
figure(2)
for i=1:1:4
plot(V,-deltaa1_m(:,i).*180./pi);
hold on
end
title('AILERON deflection');
xlabel('V [m/s]');
ylabel('-\delta_{a} [deg]');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
grid on
hold off

% RUDDER
figure(3)
for i=1:1:4
plot(V,-deltar1_m(:,i).*180./pi);
hold on
end
title('RUDDER deflection');
xlabel('V [m/s]');
ylabel('-\delta_{r} [deg]');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
grid on
hold off

% ALPHA
figure(4)
for i=1:1:4
plot(V,alpha1_m(:,i).*180./pi);
hold on
end
title('ALPHA');
xlabel('V [m/s]');
ylabel('\alpha [deg]');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
grid on
hold off


% THROTTLE
figure(5)
for i=1:1:4
plot(V,MANETTA_m(:,i));
hold on
end
title('THROTTLE');
xlabel('V [m/s]');
ylabel('%');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
grid on
hold off


% POWER
%%%%%%%%%%%%%%%%%%%%%%%%%%
% Dati ISA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


rho_sl  = 1.225;               % Densità aria a livello del mare [kg/m^3]
T_sl    = 288.15;                  % Temperatura a livello del mare [K]
a       = -0.0065;             % Gradiente termico [K/m]


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Variazione della potenza disponibile con la quota
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Quota variabile 
h=H;
% Valutazione della temperatura e della densita' al variare della quota (fino a tropopausa)
for  i = 1:length(h)
T(i)     = T_sl + a.*h(i);
rho(i)   = rho_sl*(T(i)/T_sl).^4.25;

i = i+1;
end

PSI1=rho./rho_sl.*sqrt(T_sl./T);
PTENZA_m=[POTENZA_m(:,1)*PSI1(1) POTENZA_m(:,2)*PSI1(2) POTENZA_m(:,3)*PSI1(3) POTENZA_m(:,4)*PSI1(4)];

 figure(6)
for i=1:1:4
plot(V,POTENZA_m(:,i));
hold on
end
title('POWER');
xlabel('V [m/s]');
ylabel('W');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
hold off

disp('==============================================');
disp('                  END, ready');
disp('==============================================');
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CREATE TRIMMED-FLIGHT CURVE PERCENTAGE %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clc
disp('==============================================');
disp('                   Wait');
disp('==============================================');
V=50:3:65
H=500:500:2000

deltae_up=-29; %gradi
deltae_down=8;%gradi

deltaa_up=-28;
deltaa_down=23;

deltar_max=25;
deltar_min=-25;

% ELEVATOR
figure(1)
for i=1:1:4
plot(V,deltae1_m(:,i).*180./pi./deltae_up.*100);
hold on
end
title('Elevator deflection percentage');
xlabel('V [m/s]');
ylabel('%');
text(53, 7.5, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
hold off

% AILERON
figure(2)
for i=1:1:4
plot(V,deltaa1_m(:,i).*180./pi./deltaa_up.*100);
hold on
end
title('AILERON deflection percentuage');
xlabel('V [m/s]');
ylabel('%');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
hold off

% RUDDER
figure(3)
for i=1:1:4
plot(V, -deltar1_m(:,i).*180./pi./deltar_max.*100);
hold on
end
title('RUDDER deflection percentage');
xlabel('V [m/s]');
ylabel('%');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
hold off

% ALPHA
figure(4)
for i=1:1:4
plot(V,alpha1_m(:,i).*180./pi);
hold on
end
title('ALPHA');
xlabel('V [m/s]');
ylabel('\alpha [deg]');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
hold off


% THROTTLE
figure(5)
for i=1:1:4
plot(V,MANETTA_m(:,i));
hold on
end
title('THROTTLE');
xlabel('V [m/s]');
ylabel('%');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
hold off


% POWER
%%%%%%%%%%%%%%%%%%%%%%%%%%
% Dati ISA
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


rho_sl  = 1.225;               % Densità aria a livello del mare [kg/m^3]
T_sl    = 288.15;                  % Temperatura a livello del mare [K]
a       = -0.0065;             % Gradiente termico [K/m]


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Variazione della potenza disponibile con la quota
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Quota variabile 
h=H;
% Valutazione della temperatura e della densita' al variare della quota (fino a tropopausa)
for  i = 1:length(h)
T(i)     = T_sl + a.*h(i);
rho(i)   = rho_sl*(T(i)/T_sl).^4.25;

i = i+1;
end

PSI1=rho./rho_sl.*sqrt(T_sl./T);
PTENZA_m=[POTENZA_m(:,1)*PSI1(1) POTENZA_m(:,2)*PSI1(2) POTENZA_m(:,3)*PSI1(3) POTENZA_m(:,4)*PSI1(4)];

 figure(6)
for i=1:1:4
plot(V,POTENZA_m(:,i));
hold on
end
title('POWER');
xlabel('V [m/s]');
ylabel('W');
text(35, 0.8, ['Engine speed: ' num2str(n) ' RPM']);
legend('h 500m', 'h 1000m', 'h 1500m', 'h 2000m')
hold off

disp('==============================================');
disp('                  END, ready');
disp('==============================================');


