% The FDC toolbox - Examples of using FDC models and tools.
% =========================================================
% The directory EXAMPLES contains demo-files for the FDC toolbox. The following 
% files are contained in this directory:
%
% AEROPROPMODEL.MDL   Simulink model that is used by PROPCOEFF.M to plot
%              aerodynamic and propulsive force and moment coefficients.
%
% OLOOP1.MDL   Interactive Simulink model for evaluating nonlinear open-loop 
%              responses of the 'Beaver' aircraft to block or ramp-shaped 
%              control inputs to the elevator, rudder, ailerons, flaps, 
%              manifold pressure, and/or engine RPM.
%
% OLOOP1A.MDL  Simulink model for evaluating nonlinear open-loop responses of 
%              the 'Beaver' aircraft to arbitrary test-inputs. This system is 
%              used by OPENLOOP.M to determine responses to the same test-
%              inputs as those used in OLOOP1.MDL (except OPENLOOP.M uses 
%              batch-processing whereas OLOOP1.MDL uses interactive simulations).
%              
% OLOOP2.MDL   Interactive Simulink model for evaluating open-loop responses 
%              of the 'Beaver' aircraft to atmospheric turbulence.
%
% OLOOP3.MDL   Interactive Simulink model for evaluating linear open-loop 
%              responses of the 'Beaver' aircraft to control inputs, using a 
%              linearized version of the aircraft model (linear state-space 
%              matrices determined by applying the linearization program ACLIN 
%              to the non-linear aircraft model BEAVER.MDL from the directory 
%              AIRCRAFT).
%
% OLOOP3A.MDL  Simulink model for evaluating linear open-loop responses of 
%              the 'Beaver' aircraft to arbitrary test-inputs. This system is 
%              used by OPENLOOP.M to determine responses to the same test-
%              inputs as those used in OLOOP3.MDL (except OPENLOOP.M uses 
%              batch-processing whereas OLOOP3.MDL uses interactive simulations).
%
% OPENLOOP.M   Matlab macro that determines nonlinear responses of the 'Beaver'
%              aircraft to the same six test-inputs that are available in 
%              OLOOP1.MDL. OPENLOOP.M uses OLOOP1A.MDL for the simulations and
%              plots all relevant results in six figures.
%
% PROPCOEFF.M  Utility that plots aerodynamic and propulsive force and moment 
%              coefficients of the Beaver aircraft as a function of the angle 
%              of attack, sideslip angle, and dimensionless increase of pressure 
%              in the plane of the propeller. Uses the Simulink system 
%              AEROPROPMODEL.MDL.
%
% TRIMDEMO.M   Demonstration of the steady-state trim option, applied to the
%              system beaver.mdl. This demo computes steady-state values for
%              the elevator deflection as a function of the true airspeed
%              and puts the results in a figure. The source-code of this
%              demo has been copied largely from the routine ACTRIM.M, con-
%              tained in the directory PROGRAMS.
%
% Note: 'interactive' means that the user can start simulations by opening 
% the Simulink model, possibly changing the model parameters, and starting 
% a simulation from the 'Simulation' menu. The Simulink systems which are 
% not qualified as such are called as batch-processes from within Matlab 
% subroutines; simulations of those systems are started by means of the SIM 
% command instead of interactively via the 'Simulation' menu.

%-----------------------------------------------------------------------
% The Flight Dynamics and Control Toolbox version 1.4.0. 
% (c) Copyright Marc Rauw, 1994-2005. Licensed under the Open Software 
% License version 2.1; see COPYING.TXT and LICENSE.TXT for more details.
% Last revision of this file: December 31, 2004. 
%-----------------------------------------------------------------------